/*
 * Decompiled with CFR 0.152.
 */
package com.takyon;

import com.takyon.Ball;
import com.takyon.BilliardTable;
import com.takyon.globals;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public class Billiards
extends Applet
implements Runnable {
    Thread BallTimer;
    Image offImage;
    Graphics offGraphics;
    BilliardTable T = new BilliardTable(0.0, 0.0, 300 / globals.DrawScale, 300 / globals.DrawScale);
    Ball[] B = new Ball[10];
    Color TableColor = new Color(0, 0, 0);

    @Override
    public void run() {
        int i = 0;
        int x = 0;
        int y = 0;
        double[] pX = new double[10];
        double[] pY = new double[10];
        System.out.println("Run");
        Graphics g = this.getGraphics();
        while (true) {
            this.offGraphics.setColor(this.TableColor);
            this.offGraphics.fillRect((int)this.T.Left * globals.DrawScale, (int)this.T.Top * globals.DrawScale, (int)this.T.Width * globals.DrawScale, (int)this.T.Height * globals.DrawScale);
            this.offGraphics.setColor(Color.black);
            i = 0;
            while (i < 10) {
                pX[i] = this.B[i].Px;
                pY[i] = this.B[i].Py;
                this.B[i].Move(0.05);
                ++i;
            }
            i = 0;
            while (i < 10) {
                this.CheckWallBounce(this.B[i]);
                ++i;
            }
            x = 0;
            while (x < 10) {
                y = x + 1;
                while (y < 10) {
                    if (this.Separation(this.B[x], this.B[y]) <= this.RadSum(this.B[x], this.B[y])) {
                        this.Collide(this.B[x], this.B[y]);
                    }
                    ++y;
                }
                ++x;
            }
            i = 0;
            while (i < 10) {
                this.B[i].Draw(this.offGraphics);
                ++i;
            }
            this.T.DrawBorder(this.offGraphics);
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            g.setColor(Color.white);
            g.drawImage(this.offImage, 0, 0, null);
        }
    }

    public Color RandColor() {
        int r = (int)(Math.random() * 256.0);
        int g = (int)(Math.random() * 256.0);
        int b = (int)(Math.random() * 256.0);
        return new Color(r, g, b);
    }

    @Override
    public void init() {
        this.setSize(300, 300);
        this.offImage = this.createImage((int)(this.T.Width + this.T.Left) * globals.DrawScale, (int)(this.T.Height + this.T.Top) * globals.DrawScale);
        this.offGraphics = this.offImage.getGraphics();
        int i = 0;
        while (i < 10) {
            double tmpY;
            double tmpX;
            boolean overlap;
            double tmpRad = Math.random() * globals.SizeRange + globals.MinSize;
            do {
                overlap = false;
                tmpX = Math.random() * this.T.Width + this.T.Left;
                tmpY = Math.random() * this.T.Height + this.T.Top;
                int x = 0;
                while (x < i) {
                    double dX = this.B[x].Px - tmpX;
                    double dY = this.B[x].Py - tmpY;
                    double Rads = this.B[x].Radius + tmpRad;
                    if (Math.sqrt(dX * dX + dY * dY) < Rads) {
                        overlap = true;
                    }
                    ++x;
                }
            } while (overlap);
            this.B[i] = new Ball(tmpX, tmpY, tmpRad);
            this.B[i].Vx = (Math.random() * globals.VelocityRange + globals.MinVelocity) * (double)this.PosNegRand();
            this.B[i].Vy = (Math.random() * globals.VelocityRange + globals.MinVelocity) * (double)this.PosNegRand();
            this.B[i].BallColor = this.RandColor();
            ++i;
        }
        this.repaint();
        this.BallTimer = new Thread(this);
        this.BallTimer.start();
    }

    public int PosNegRand() {
        double a = Math.random() * 2.0;
        if (a >= 1.0) {
            a = 1.0;
        }
        if (a < 1.0) {
            a = -1.0;
        }
        return (int)a;
    }

    public void CheckWallBounce(Ball B) {
        double Xleft = B.Px;
        double Ytop = B.Py;
        double Ybottom = B.Py + 2.0 * B.Radius;
        double Xright = B.Px + 2.0 * B.Radius;
        if (Xleft < this.T.minX()) {
            B.Px = this.T.minX();
            B.WallBounceX();
        }
        if (Ytop < this.T.minY()) {
            B.Py = this.T.minY();
            B.WallBounceY();
        }
        if (Xright > this.T.maxX()) {
            B.Px = this.T.maxX() - 2.0 * B.Radius;
            B.WallBounceX();
        }
        if (Ybottom > this.T.maxY()) {
            B.Py = this.T.maxY() - 2.0 * B.Radius;
            B.WallBounceY();
        }
    }

    public void PrintData() {
        double TotalM = 0.0;
        double TotalK = 0.0;
        int i = 0;
        while (i < 10) {
            System.out.println("Ball " + i + ": ");
            this.B[i].PrintData();
            System.out.println();
            TotalM += this.B[i].Momentum();
            TotalK += this.B[i].Kinetic();
            ++i;
        }
        System.out.println("Total Momentum:  " + TotalM);
        System.out.println("Total Kinetic:  " + TotalK);
        System.out.println();
    }

    @Override
    public void paint(Graphics g) {
        this.T.Draw(g, this.TableColor);
    }

    public double Separation(Ball B1, Ball B2) {
        double X1 = B1.Px + B1.Radius;
        double X2 = B2.Px + B2.Radius;
        double Y1 = B1.Py + B1.Radius;
        double Y2 = B2.Py + B2.Radius;
        return Math.sqrt((X2 - X1) * (X2 - X1) + (Y2 - Y1) * (Y2 - Y1));
    }

    public double RadSum(Ball B1, Ball B2) {
        return B1.Radius + B2.Radius;
    }

    public void Collide(Ball B1, Ball B2) {
        double X1 = B1.Px + B1.Radius;
        double X2 = B2.Px + B2.Radius;
        double Y1 = B1.Py + B1.Radius;
        double Y2 = B2.Py + B2.Radius;
        double DxR = X2 - X1;
        double DyR = Y2 - Y1;
        double distance = Math.sqrt(DxR * DxR + DyR * DyR);
        double Dx = this.RadSum(B1, B2) * DxR / distance;
        double Dy = this.RadSum(B1, B2) * DyR / distance;
        if (B1.Mass < B2.Mass) {
            B1.Px = (X1 -= Dx - DxR) - B1.Radius;
            B1.Py = (Y1 -= Dy - DyR) - B1.Radius;
        } else {
            B2.Px = (X2 += Dx - DxR) - B2.Radius;
            B2.Py = (Y2 += Dy - DyR) - B2.Radius;
        }
        double Dx1 = B1.Radius / this.RadSum(B1, B2) * (X2 - X1);
        double Dx2 = B2.Radius / this.RadSum(B1, B2) * (X2 - X1);
        double Dy1 = B1.Radius / this.RadSum(B1, B2) * (Y2 - Y1);
        double Dy2 = B2.Radius / this.RadSum(B1, B2) * (Y2 - Y1);
        double Vs1 = this.StraightVelocity(B1.Vx, B1.Vy, Dx1, Dy1, B1.Radius);
        double Vp1 = this.PerpendicularVelocity(B1.Vx, B1.Vy, Dx1, Dy1, B1.Radius);
        double Vs2 = this.StraightVelocity(B2.Vx, B2.Vy, Dx2, Dy2, B2.Radius);
        double Vp2 = this.PerpendicularVelocity(B2.Vx, B2.Vy, Dx2, Dy2, B2.Radius);
        double newVs1 = this.CollisionVelocity(Vs1, Vs2, B1.Mass, B2.Mass);
        double newVs2 = this.CollisionVelocity(Vs2, Vs1, B2.Mass, B1.Mass);
        B1.Vx = this.XVelocity(newVs1, Vp1, Dx1, Dy1, B1.Radius);
        B1.Vy = this.YVelocity(newVs1, Vp1, Dx1, Dy1, B1.Radius);
        B2.Vx = this.XVelocity(newVs2, Vp2, Dx2, Dy2, B2.Radius);
        B2.Vy = this.YVelocity(newVs2, Vp2, Dx2, Dy2, B2.Radius);
    }

    public double StraightVelocity(double Vx, double Vy, double Dx, double Dy, double R) {
        return Vx * Dx / R + Vy * Dy / R;
    }

    public double PerpendicularVelocity(double Vx, double Vy, double Dx, double Dy, double R) {
        return Vy * Dx / R - Vx * Dy / R;
    }

    public double XVelocity(double Vs, double Vp, double Dx, double Dy, double R) {
        return Vs * Dx / R - Vp * Dy / R;
    }

    public double YVelocity(double Vs, double Vp, double Dx, double Dy, double R) {
        return Vs * Dy / R + Vp * Dx / R;
    }

    public double CollisionVelocity(double V1, double V2, double m1, double m2) {
        return V1 * (m1 - m2) / (m1 + m2) + V2 * (2.0 * m2) / (m1 + m2);
    }
}

