/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game;

import com.badlogic.gdx.math.collision.Segment;
import com.takyon.battle.game.physics.Ball;

public class Arena {
    public float Left;
    public float Top;
    public float Width;
    public float Height;
    private int[] blocs_1;
    private int[] blocs_2;
    public Segment north;
    public Segment south;
    public Segment west;
    public Segment east;

    protected Arena() {
    }

    public Arena(float L, float T, float W, float H) {
        this.Left = L;
        this.Top = T;
        this.Width = W;
        this.Height = H;
        this.blocs_1 = new int[7];
        int i = 0;
        while (i < this.blocs_1.length) {
            this.blocs_1[i] = 0;
            ++i;
        }
        this.blocs_2 = new int[7];
        i = 0;
        while (i < this.blocs_2.length) {
            this.blocs_2[i] = 0;
            ++i;
        }
        this.north = new Segment(this.Left, this.Top, 0.0f, this.Left + this.Width, this.Top, 0.0f);
        this.south = new Segment(this.Left, this.Top + this.Height, 0.0f, this.Left + this.Width, this.Top + this.Height, 0.0f);
        this.west = new Segment(this.Left, this.Top, 0.0f, this.Left, this.Top + this.Height, 0.0f);
        this.east = new Segment(this.Left + this.Width, this.Top, 0.0f, this.Left + this.Width, this.Top + this.Height, 0.0f);
    }

    public void setSegments(float radius) {
        this.north.a.set(this.Left, this.Top + radius, 0.0f);
        this.north.b.set(this.Left + this.Width, this.Top + radius, 0.0f);
        this.south.a.set(this.Left, this.Top + this.Height - radius, 0.0f);
        this.south.b.set(this.Left + this.Width, this.Top + this.Height - radius, 0.0f);
        this.west.a.set(this.Left + radius, this.Top, 0.0f);
        this.west.b.set(this.Left + radius, this.Top + this.Height, 0.0f);
        this.east.a.set(this.Left + this.Width - radius, this.Top, 0.0f);
        this.east.b.set(this.Left + this.Width - radius, this.Top + this.Height, 0.0f);
    }

    public void CheckWallBounce(Ball ball, float dx, float dy) {
        if (ball.position.x - ball.radius < this.minX()) {
            ball.position.x = this.minX() + ball.radius;
        }
        if (ball.position.x + ball.radius > this.maxX()) {
            ball.position.x = this.maxX() - ball.radius;
        }
        if (ball.position.y - ball.radius < this.minY()) {
            ball.position.y = this.minY() + ball.radius;
        }
        if (ball.position.y + ball.radius > this.maxY()) {
            ball.position.y = this.maxY() - ball.radius;
        }
        float bx = ball.position.x + dx;
        float by = ball.position.y + dy;
        if (bx - ball.radius < this.minX()) {
            ball.position.x = this.minX() + ball.radius;
            ball.WallBounceX();
        }
        if (bx + ball.radius > this.maxX()) {
            ball.position.x = this.maxX() - ball.radius;
            ball.WallBounceX();
        }
        if (by - ball.radius < this.minY()) {
            ball.position.y = this.minY() + ball.radius;
            ball.WallBounceY();
            this.checkBlocsCollision(ball);
        }
        if (by + ball.radius > this.maxY()) {
            ball.position.y = this.maxY() - ball.radius;
            ball.WallBounceY();
            this.checkBlocsCollision(ball);
        }
    }

    private void checkBlocsCollision(Ball ball) {
        int x = (int)((ball.position.x - 15.0f) / 150.0f);
        if (ball.position.y > 960.0f) {
            int n = x;
            this.blocs_1[n] = this.blocs_1[n] + 1;
        } else {
            int n = x;
            this.blocs_2[n] = this.blocs_2[n] + 1;
        }
    }

    public float minX() {
        return this.Left;
    }

    public float minY() {
        return this.Top;
    }

    public float maxX() {
        return this.Left + this.Width;
    }

    public float maxY() {
        return this.Top + this.Height;
    }
}

