/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game;

import com.badlogic.gdx.utils.Array;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.states.StatePlaying;
import com.takyon.battle.game.states.StateWaitForPlay;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.game.rules.OptionsPlayer;
import com.takyon.gamelib.GDXImageRegion;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public class PlayerBattle {
    public PlayerColor color;
    public PionBattle roi;
    public Array<PionBattle> pions;
    public Array<PionBattle> pionsPris;
    public int nbRoiPris;
    public int nbPionPris;
    public int nbGolds;
    public boolean hasFinishedPlacing;
    public OptionsPlayer optionsPlayer;
    private int nbPass;
    public boolean canPass;
    public boolean isUsingCombo;
    public StateWaitForPlay stateWaitForPlay;
    public StatePlaying statePlaying;
    public boolean lifeDisplayCircle;
    public GDXImageRegion imageFond;

    public PlayerBattle() {
    }

    public PlayerBattle(PlayerColor color) {
        this.color = color;
        this.pions = new Array();
        this.pionsPris = new Array();
        this.optionsPlayer = new OptionsPlayer();
        this.stateWaitForPlay = new StateWaitForPlay(this, PlayerStateEnum.WAITING_FOR_PLAY);
        this.statePlaying = new StatePlaying(this, PlayerStateEnum.PLAYING);
    }

    public void init() {
        this.reset();
    }

    public void copyFrom(PlayerBattle player) {
        this.color = player.color;
        this.nbRoiPris = player.nbRoiPris;
        this.nbPionPris = player.nbPionPris;
        this.hasFinishedPlacing = player.hasFinishedPlacing;
    }

    public PlayerColor getColor() {
        return this.color;
    }

    public void setColor(PlayerColor color) {
        this.color = color;
    }

    public void addPion(PionBattle pion) {
        pion.id = this.pions.size;
        this.pions.add((Object)pion);
    }

    public boolean hasFinishedPlacing() {
        return this.hasFinishedPlacing;
    }

    public void changeTurn() {
        this.nbPass = 0;
    }

    public boolean isAllPionStun() {
        boolean isAllstun = true;
        for (PionBattle pion : this.pions) {
            if (pion.isStun) continue;
            isAllstun = false;
            break;
        }
        return isAllstun;
    }

    public void pass() {
        ++this.nbPass;
        if (this.nbPass == 2) {
            this.canPass = false;
        }
    }

    public int nbJokersMax() {
        return this.optionsPlayer.nbJokersMax.value;
    }

    public int nbRoisAPrendre() {
        return this.optionsPlayer.nbRoisAPrendre.value;
    }

    public int nbPionsAPrendre() {
        return this.optionsPlayer.nbPionsAPrendre.value;
    }

    public int nbOeufsRemplisMax() {
        return this.optionsPlayer.nbOeufsRemplisMax.value;
    }

    public int nbJokersEclosion() {
        return this.optionsPlayer.nbJokersEclosion.value;
    }

    public int nbJokersBoussole() {
        return this.optionsPlayer.nbJokersBoussole.value;
    }

    public boolean canChangeBoussole() {
        return this.optionsPlayer.canChangeBoussole.value;
    }

    public boolean canChangeBoussoleOpponent() {
        return this.optionsPlayer.canChangeBoussoleOpponent.value;
    }

    public void reset() {
        this.nbRoiPris = 0;
        this.nbPionPris = 0;
        this.nbGolds = 0;
        this.lifeDisplayCircle = true;
        this.hasFinishedPlacing = false;
        this.nbPass = 0;
        this.canPass = true;
        this.isUsingCombo = false;
    }

    public void logic(float dt) {
        int i = 0;
        while (i < this.pions.size) {
            PionBattle pion = (PionBattle)this.pions.get(i);
            pion.state.logic(dt);
            ++i;
        }
    }

    public void drawHudBack() {
        int i = 0;
        while (i < this.pions.size) {
            PionBattle pion = (PionBattle)this.pions.get(i);
            if (pion.isVisible()) {
                Position pos = pion.getPositionScale();
                pos.x += (float)Graphics.decalageX;
                float r = (pion.ball.radius + 2.0f) * Scene2D.RATIO;
                pion.drawLife(pos, r);
            }
            ++i;
        }
    }

    public void drawHudFront() {
        int i = 0;
        while (i < this.pions.size) {
            PionBattle pion = (PionBattle)this.pions.get(i);
            if (pion.isVisible()) {
                Position pos = pion.getPositionScale();
                pos.x += (float)Graphics.decalageX;
                float r = (pion.ball.radius + 2.0f) * Scene2D.RATIO;
                pion.drawHud(pos, r);
            }
            ++i;
        }
    }

    public String toString() {
        return "" + (Object)((Object)this.color);
    }

    public PionBattle getPion(int id) {
        for (PionBattle pion : this.pions) {
            if (pion.id != id) continue;
            return pion;
        }
        return null;
    }

    public static enum PlayerActionEnum {
        ATTACK;

    }

    public static enum PlayerStateEnum {
        PLAYING,
        WAITING_FOR_PLAY;

    }
}

