/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.ia;

import com.badlogic.gdx.math.Intersector;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.collision.Segment;
import com.badlogic.gdx.utils.Array;
import com.takyon.battle.BattleGame;
import com.takyon.battle.game.Arena;
import com.takyon.battle.game.Coup;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.ia.WallIntersection;
import com.takyon.battle.game.physics.Wall;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.screens.BattleGameScreen;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class BattleIA {
    public static PlayerBattle IAPlayer;
    public static PlayerBattle HumanPlayer;
    public int max_depth = 5;
    public static Comparator<PionBattle> lifeComparator;
    public static Comparator<PionBattle> powerComparator;
    public static Comparator<Coup> coupComparator;
    private static Array<PionBattle> pions;
    private static Array<PionBattle> pionsnotStun;
    public static Vector2 position_start_1;
    public static Vector2 position_start_2;
    public static Vector2 position_end_1;
    public static Vector2 position_end_2;
    public static Segment[] segments;
    public static Comparator<Triplet> tripletComparator;

    static {
        tripletComparator = new Comparator<Triplet>(){

            @Override
            public int compare(Triplet a, Triplet b) {
                return a.value - b.value;
            }
        };
    }

    public BattleIA() {
        pions = new Array();
        pionsnotStun = new Array();
        lifeComparator = new Comparator<PionBattle>(){

            @Override
            public int compare(PionBattle pion1, PionBattle pion2) {
                return pion1.getLife() - pion2.getLife();
            }
        };
        powerComparator = new Comparator<PionBattle>(){

            @Override
            public int compare(PionBattle pion1, PionBattle pion2) {
                return pion2.getValue() - pion1.getValue();
            }
        };
        coupComparator = new Comparator<Coup>(){

            @Override
            public int compare(Coup coup1, Coup coup2) {
                return coup2.getValue() - coup1.getValue();
            }
        };
    }

    private static void setPionsNotStun() {
        pionsnotStun.clear();
        int i = 0;
        while (i < BattleIA.IAPlayer.pions.size) {
            PionBattle pion = (PionBattle)BattleIA.IAPlayer.pions.get(i);
            if (!pion.isStun) {
                pionsnotStun.add((Object)pion);
            }
            ++i;
        }
    }

    private static PionBattle getPionLePlusPuissant() {
        BattleIA.setPionsNotStun();
        pionsnotStun.sort(powerComparator);
        return (PionBattle)pionsnotStun.get(0);
    }

    private static PionBattle getPionLePlusPuissantPourTuer(PionBattle ennemy) {
        PionBattle pion;
        int i;
        pions.clear();
        BattleIA.setPionsNotStun();
        switch (ennemy.type) {
            case AIR: {
                i = 0;
                while (i < BattleIA.pionsnotStun.size) {
                    pion = (PionBattle)pionsnotStun.get(i);
                    if (pion.type == PionBattle.Type.FEU && !BattleIA.hasObstacle(pion, ennemy)) {
                        return pion;
                    }
                    ++i;
                }
                break;
            }
            case FEU: {
                i = 0;
                while (i < BattleIA.pionsnotStun.size) {
                    pion = (PionBattle)pionsnotStun.get(i);
                    if (pion.type == PionBattle.Type.EAU && !BattleIA.hasObstacle(pion, ennemy)) {
                        return pion;
                    }
                    ++i;
                }
                break;
            }
            case EAU: {
                i = 0;
                while (i < BattleIA.pionsnotStun.size) {
                    pion = (PionBattle)pionsnotStun.get(i);
                    if (pion.type == PionBattle.Type.AIR && !BattleIA.hasObstacle(pion, ennemy)) {
                        return pion;
                    }
                    ++i;
                }
                break;
            }
        }
        i = 0;
        while (i < BattleIA.pionsnotStun.size) {
            pion = (PionBattle)pionsnotStun.get(i);
            if (!BattleIA.hasObstacle(pion, ennemy)) {
                pions.add((Object)pion);
            }
            ++i;
        }
        pions.sort(powerComparator);
        if (BattleIA.pions.size > 0) {
            return (PionBattle)pions.get(0);
        }
        int r = MathUtils.random((int)0, (int)(BattleIA.IAPlayer.pions.size - 1));
        return (PionBattle)BattleIA.IAPlayer.pions.get(r);
    }

    private static PionBattle getEnnemyLePlusFaible() {
        pions.clear();
        for (PionBattle pion : BattleIA.HumanPlayer.pions) {
            pions.add((Object)pion);
        }
        pions.sort(lifeComparator);
        return (PionBattle)pions.get(0);
    }

    private static int getCoupValue(PionBattle pionIA, PionBattle pion) {
        boolean isKingIndanger = false;
        int c = 0;
        if (!pion.isStun && !BattleIA.hasObstacle(BattleIA.IAPlayer.roi, pion)) {
            c = 5;
        }
        if (pionIA.type == PionBattle.Type.FEU ? pion.type == PionBattle.Type.AIR : (pionIA.type == PionBattle.Type.AIR ? pion.type == PionBattle.Type.EAU : pionIA.type == PionBattle.Type.EAU && pion.type == PionBattle.Type.FEU)) {
            return 10 + c;
        }
        return pionIA.getValue();
    }

    private static Coup getMeilleurCoup() {
        Array coups = new Array();
        BattleIA.setPionsNotStun();
        int i = 0;
        while (i < BattleIA.pionsnotStun.size) {
            PionBattle pionIA = (PionBattle)pionsnotStun.get(i);
            int j = 0;
            while (j < BattleIA.HumanPlayer.pions.size) {
                PionBattle pion = (PionBattle)BattleIA.HumanPlayer.pions.get(j);
                if (!BattleIA.hasObstacle(pionIA, pion)) {
                    int value = BattleIA.getCoupValue(pionIA, pion);
                    coups.add((Object)new Coup(pionIA, pion, value));
                } else {
                    coups.add((Object)new Coup(pionIA, pion, 0));
                }
                ++j;
            }
            ++i;
        }
        if (coups.size > 0) {
            if (coups.size == 1) {
                return (Coup)coups.get(0);
            }
            coups.sort(coupComparator);
            return (Coup)coups.get(0);
        }
        return BattleIA.coupRandom();
    }

    private static Coup calculateCoup(PionBattle pionIA, PionBattle pionAttack, PionBattle pionAimed) {
        Vector2 vecAttack = new Vector2();
        vecAttack.set(pionAimed.getPosition().x - pionAttack.getPosition().x, pionAimed.getPosition().y - pionAttack.getPosition().y);
        Vector2 vecAim = new Vector2();
        vecAim.set(pionAttack.getPosition().x - pionIA.getPosition().x, pionAttack.getPosition().y - pionIA.getPosition().y);
        float angle = vecAttack.angle(vecAim);
        Vector2 vecAim2 = new Vector2(vecAim);
        vecAim2.limit(1.0f);
        vecAim2.rotate(-90.0f);
        vecAim2.scl(pionAttack.ball.radius + pionIA.ball.radius);
        vecAim2.set(pionAttack.getPosition().x + vecAim2.x, pionAttack.getPosition().y + vecAim2.y);
        vecAim2.set(vecAim2.x - pionIA.getPosition().x, vecAim2.y - pionIA.getPosition().y);
        float angleAmpli = Math.abs(vecAim2.angle(vecAim));
        vecAim.rotate(angleAmpli * (angle / 90.0f));
        return new Coup(pionIA, vecAim, 0);
    }

    private static Coup coupRandom() {
        BattleIA.setPionsNotStun();
        int rIA = MathUtils.random((int)0, (int)(BattleIA.pionsnotStun.size - 1));
        PionBattle pionIA = (PionBattle)pionsnotStun.get(rIA);
        int r = MathUtils.random((int)0, (int)(BattleIA.HumanPlayer.pions.size - 1));
        PionBattle pion = (PionBattle)BattleIA.HumanPlayer.pions.get(r);
        return new Coup(pionIA, pion, 0);
    }

    private static Vector2 findTrajectoire(Wall wall, PionBattle pion1, PionBattle pion2) {
        return BattleIA.findTrajectoire(wall, pion1.ball.getPosition(), pion1.ball.radius, pion2.getPosition());
    }

    private static Vector2 findTrajectoire(Wall wall, Position position1, float radius, Position position2) {
        float IX = 0.0f;
        float IY = 0.0f;
        Vector2 result = new Vector2();
        if (wall == Wall.NORTH) {
            IY = BattleGame.arena.Top - radius;
            float e = Math.abs(position2.y - IY) / Math.abs(position1.y - IY);
            float H = Math.abs(position1.x - position2.x);
            float h = H / (1.0f + e);
            result.y = IY - position1.y;
            result.x = position1.x > position2.x ? -h : h;
        } else if (wall == Wall.EAST) {
            IX = BattleGame.arena.Left + BattleGame.arena.Width + radius;
            float e = Math.abs(position2.x - IX) / Math.abs(position1.x - IX);
            float H = Math.abs(position1.y - position2.y);
            float h = H / (1.0f + e);
            result.x = IX - position1.x;
            result.y = position1.y > position2.y ? -h : h;
        } else if (wall == Wall.SOUTH) {
            IY = BattleGame.arena.Top + BattleGame.arena.Height - radius;
            float e = Math.abs(position2.y - IY) / Math.abs(position1.y - IY);
            float H = Math.abs(position1.x - position2.x);
            float h = H / (1.0f + e);
            result.y = IY - position1.y;
            result.x = position1.x > position2.x ? -h : h;
        } else if (wall == Wall.WEST) {
            IX = BattleGame.arena.Left + radius;
            float e = Math.abs(position2.x - IX) / Math.abs(position1.x - IX);
            float H = Math.abs(position1.y - position2.y);
            float h = H / (1.0f + e);
            result.x = IX - position1.x;
            result.y = position1.y > position2.y ? -h : h;
        }
        result.x *= 10.0f;
        result.y *= 10.0f;
        return result;
    }

    public static boolean hasObstacle(PionBattle pionIA, PionBattle pion) {
        Vector2 seg = new Vector2(pion.getPosition().x - pionIA.getPosition().x, pion.getPosition().y - pionIA.getPosition().y);
        Vector2 seg_left_start = new Vector2(seg.x, seg.y);
        Vector2 seg_right_start = new Vector2(seg.x, seg.y);
        Vector2 seg_left_end = new Vector2(seg.x, seg.y);
        Vector2 seg_right_end = new Vector2(seg.x, seg.y);
        seg_left_start.limit(pionIA.ball.radius);
        seg_left_start.rotate90(1);
        seg_right_start.limit(pionIA.ball.radius);
        seg_right_start.rotate90(-1);
        seg_left_end.limit(pion.ball.radius);
        seg_left_end.rotate90(1);
        seg_right_end.limit(pion.ball.radius);
        seg_right_end.rotate90(-1);
        position_start_1 = new Vector2(pionIA.getPosition().x + seg_left_start.x, pionIA.getPosition().y + seg_left_start.y);
        position_start_2 = new Vector2(pionIA.getPosition().x + seg_right_start.x, pionIA.getPosition().y + seg_right_start.y);
        position_end_1 = new Vector2(pion.getPosition().x + seg_left_end.x, pion.getPosition().y + seg_left_end.y);
        position_end_2 = new Vector2(pion.getPosition().x + seg_right_end.x, pion.getPosition().y + seg_right_end.y);
        Vector2 center = new Vector2();
        for (PionBattle pionBattle : BattleIA.IAPlayer.pions) {
            if (pionIA == pionBattle) continue;
            center.set(pionBattle.getPosition().x, pionBattle.getPosition().y);
            if (!Intersector.intersectSegmentCircle((Vector2)position_start_1, (Vector2)position_end_1, (Vector2)center, (float)(pionBattle.ball.radius * pionBattle.ball.radius)) && !Intersector.intersectSegmentCircle((Vector2)position_start_2, (Vector2)position_end_2, (Vector2)center, (float)(pionBattle.ball.radius * pionBattle.ball.radius))) continue;
            return true;
        }
        for (PionBattle pionBattle : BattleIA.HumanPlayer.pions) {
            if (pion == pionBattle) continue;
            center.set(pionBattle.getPosition().x, pionBattle.getPosition().y);
            if (!Intersector.intersectSegmentCircle((Vector2)position_start_1, (Vector2)position_end_1, (Vector2)center, (float)(pionBattle.ball.radius * pionBattle.ball.radius)) && !Intersector.intersectSegmentCircle((Vector2)position_start_2, (Vector2)position_end_2, (Vector2)center, (float)(pionBattle.ball.radius * pionBattle.ball.radius))) continue;
            return true;
        }
        return false;
    }

    public static Segment[] getReflections(PionBattle attacker, Vector2 vec, int n, float radius) {
        Vector2 pos = new Vector2(attacker.getPosition().x, attacker.getPosition().y);
        Segment[] segments = new Segment[n];
        int i = 0;
        while (i < n) {
            WallIntersection wallIntersection = BattleIA.getWallIntersection(BattleGame.arena, pos, vec, radius);
            if (wallIntersection != null) {
                segments[i] = new Segment(pos.x, pos.y, 0.0f, wallIntersection.intersection.x, wallIntersection.intersection.y, 0.0f);
                pos.set(wallIntersection.intersection.x, wallIntersection.intersection.y);
                if (wallIntersection.wall == Wall.NORTH || wallIntersection.wall == Wall.SOUTH) {
                    vec.y *= -1.0f;
                } else if (wallIntersection.wall == Wall.EAST || wallIntersection.wall == Wall.WEST) {
                    vec.x *= -1.0f;
                }
                if (BattleIA.hasObstacle(attacker, segments[i])) break;
            }
            ++i;
        }
        return segments;
    }

    private static boolean hasObstacle(PionBattle attacker, Segment segment) {
        Vector2 center = new Vector2();
        Vector2 segment_start = new Vector2();
        Vector2 segment_end = new Vector2();
        for (PionBattle pionBattle : BattleIA.IAPlayer.pions) {
            if (pionBattle == attacker) continue;
            center.set(pionBattle.getPosition().x, pionBattle.getPosition().y);
            segment_start.set(segment.a.x, segment.a.y);
            segment_end.set(segment.b.x, segment.b.y);
            if (!Intersector.intersectSegmentCircle((Vector2)segment_start, (Vector2)segment_end, (Vector2)center, (float)(pionBattle.ball.radius * pionBattle.ball.radius))) continue;
            return true;
        }
        for (PionBattle pionBattle : BattleIA.HumanPlayer.pions) {
            if (pionBattle == attacker) continue;
            center.set(pionBattle.getPosition().x, pionBattle.getPosition().y);
            segment_start.set(segment.a.x, segment.a.y);
            segment_end.set(segment.b.x, segment.b.y);
            if (!Intersector.intersectSegmentCircle((Vector2)segment_start, (Vector2)segment_end, (Vector2)center, (float)(pionBattle.ball.radius * pionBattle.ball.radius))) continue;
            return true;
        }
        return false;
    }

    private static WallIntersection getWallIntersection(Arena arena, Vector2 position, Vector2 vec, float radius) {
        arena.setSegments(radius);
        WallIntersection wallIntersection = new WallIntersection();
        Segment segment = null;
        Vector2 pos = new Vector2(position);
        Vector2 vecUnit = new Vector2(vec);
        int i = 0;
        while (i < 1000) {
            pos.x += vecUnit.x;
            pos.y += vecUnit.y;
            if (pos.y < arena.Top && pos.x > arena.Left && pos.x < arena.Left + arena.Width) {
                segment = arena.north;
                wallIntersection.wall = Wall.NORTH;
                break;
            }
            if (pos.y > arena.Top + arena.Height && pos.x > arena.Left && pos.x < arena.Left + arena.Width) {
                segment = arena.south;
                wallIntersection.wall = Wall.SOUTH;
                break;
            }
            if (pos.x < arena.Left && pos.y > arena.Top && pos.y < arena.Top + arena.Height) {
                segment = arena.west;
                wallIntersection.wall = Wall.WEST;
                break;
            }
            if (pos.x > arena.Left + arena.Width && pos.y > arena.Top && pos.y < arena.Top + arena.Height) {
                segment = arena.east;
                wallIntersection.wall = Wall.EAST;
                break;
            }
            ++i;
        }
        Vector2 intersection = new Vector2();
        if (segment != null) {
            Intersector.intersectLines((Vector2)position, (Vector2)new Vector2(position.x + vec.x, position.y + vec.y), (Vector2)new Vector2(segment.a.x, segment.a.y), (Vector2)new Vector2(segment.b.x, segment.b.y), (Vector2)intersection);
            wallIntersection.intersection.set(intersection);
            return wallIntersection;
        }
        return null;
    }

    public static void drawSegments(Segment[] segments) {
        Graphics.shapeRenderer.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        if (segments != null) {
            Segment[] segmentArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                Segment segment = segmentArray[n2];
                if (segment != null) {
                    float startX_1 = (float)Graphics.decalageX + Graphics.getPositionScaleX(segment.a.x);
                    float startY_1 = Graphics.getPositionScaleY(segment.a.y);
                    float endX_1 = (float)Graphics.decalageX + Graphics.getPositionScaleX(segment.b.x);
                    float endY_1 = Graphics.getPositionScaleY(segment.b.y);
                    Graphics.shapeRenderer.line(startX_1, startY_1, endX_1, endY_1);
                }
                ++n2;
            }
        }
    }

    public static void playIA() {
        Coup coup = null;
        ArrayList<Triplet> list = new ArrayList<Triplet>();
        int i = 0;
        while (i < BattleIA.IAPlayer.pions.size) {
            PionBattle thrower = (PionBattle)BattleIA.IAPlayer.pions.get(i);
            int j = 0;
            while (j < BattleIA.IAPlayer.pions.size) {
                PionBattle thrown = (PionBattle)BattleIA.IAPlayer.pions.get(j);
                if (thrown != thrower && !BattleIA.hasObstacle(thrower, thrown)) {
                    int k = 0;
                    while (k < BattleIA.HumanPlayer.pions.size) {
                        PionBattle ennemy = (PionBattle)BattleIA.HumanPlayer.pions.get(k);
                        if (!BattleIA.hasObstacle(thrown, ennemy)) {
                            int value = 0;
                            value = thrown.type == PionBattle.Type.FEU && ennemy.type == PionBattle.Type.AIR ? 10 : (thrown.type == PionBattle.Type.AIR && ennemy.type == PionBattle.Type.EAU ? 10 : (thrown.type == PionBattle.Type.EAU && ennemy.type == PionBattle.Type.FEU ? 10 : ennemy.getValue()));
                            list.add(new Triplet(thrower, thrown, ennemy, value));
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(list, tripletComparator);
        if (list.size() > 0) {
            int r = MathUtils.random((int)0, (int)(list.size() - 1));
            Triplet triplet = (Triplet)list.get(r);
            coup = BattleIA.calculateCoup(triplet.thrower, triplet.thrown, triplet.aim);
        }
        if (coup == null) {
            coup = BattleIA.coupRandom();
        }
        coup.pion.isThrower = true;
        BattleGameScreen.screenTutorialLiveScreenGame.attack(coup.pion, coup.aim);
    }

    public static class Triplet {
        public PionBattle thrower;
        public PionBattle thrown;
        public PionBattle aim;
        public int value;

        public Triplet(PionBattle thrower, PionBattle thrown, PionBattle aim, int value) {
            this.thrower = thrower;
            this.thrown = thrown;
            this.aim = aim;
            this.value = value;
        }
    }
}

