/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.physics;

import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.game.physics.Ball;
import com.takyon.gamelib.Position;

public class BallPhysics {
    public static Vector2 vector(Ball ball1, Ball ball2) {
        return new Vector2(ball2.position.x - ball1.position.x, ball2.position.y - ball1.position.y);
    }

    public static double distance(Position position1, Position position2) {
        return Math.sqrt((position2.x - position1.x) * (position2.x - position1.x) + (position2.y - position1.y) * (position2.y - position1.y));
    }

    public static double distance(Ball ball1, Ball ball2) {
        return Math.sqrt((ball2.position.x - ball1.position.x) * (ball2.position.x - ball1.position.x) + (ball2.position.y - ball1.position.y) * (ball2.position.y - ball1.position.y));
    }

    public static double RadSum(Ball ball1, Ball ball2) {
        return ball1.radius + ball2.radius;
    }

    public static void Collide(Ball ball1, Ball ball2) {
        double radSum = BallPhysics.RadSum(ball1, ball2);
        float X1 = ball1.position.x + ball1.radius;
        float X2 = ball2.position.x + ball2.radius;
        float Y1 = ball1.position.y + ball1.radius;
        float Y2 = ball2.position.y + ball2.radius;
        double DxR = X2 - X1;
        double DyR = Y2 - Y1;
        double distance = Math.sqrt(DxR * DxR + DyR * DyR);
        double Dx = radSum * DxR / distance;
        double Dy = radSum * DyR / distance;
        if (ball1.mass < ball2.mass) {
            X1 = (float)((double)X1 - (Dx - DxR));
            Y1 = (float)((double)Y1 - (Dy - DyR));
        } else {
            X2 = (float)((double)X2 + (Dx - DxR));
            Y2 = (float)((double)Y2 + (Dy - DyR));
        }
        double Dx1 = (double)ball1.radius / radSum * (double)(X2 - X1);
        double Dx2 = (double)ball2.radius / radSum * (double)(X2 - X1);
        double Dy1 = (double)ball1.radius / radSum * (double)(Y2 - Y1);
        double Dy2 = (double)ball2.radius / radSum * (double)(Y2 - Y1);
        double Vs1 = BallPhysics.StraightVelocity(ball1.velocity.x, ball1.velocity.y, Dx1, Dy1, ball1.radius);
        double Vp1 = BallPhysics.PerpendicularVelocity(ball1.velocity.x, ball1.velocity.y, Dx1, Dy1, ball1.radius);
        double Vs2 = BallPhysics.StraightVelocity(ball2.velocity.x, ball2.velocity.y, Dx2, Dy2, ball2.radius);
        double Vp2 = BallPhysics.PerpendicularVelocity(ball2.velocity.x, ball2.velocity.y, Dx2, Dy2, ball2.radius);
        double newVs1 = BallPhysics.CollisionVelocity(Vs1, Vs2, ball1.mass, ball2.mass);
        double newVs2 = BallPhysics.CollisionVelocity(Vs2, Vs1, ball2.mass, ball1.mass);
        float coeff = 0.9f;
        ball1.pion.setVelocity0((float)BallPhysics.XVelocity(newVs1, Vp1, Dx1, Dy1, ball1.radius) * coeff, (float)BallPhysics.YVelocity(newVs1, Vp1, Dx1, Dy1, ball1.radius) * coeff);
        ball2.pion.setVelocity0((float)BallPhysics.XVelocity(newVs2, Vp2, Dx2, Dy2, ball2.radius) * coeff, (float)BallPhysics.YVelocity(newVs2, Vp2, Dx2, Dy2, ball2.radius) * coeff);
    }

    private static double StraightVelocity(double Vx, double Vy, double Dx, double Dy, double R) {
        return Vx * Dx / R + Vy * Dy / R;
    }

    private static double PerpendicularVelocity(double Vx, double Vy, double Dx, double Dy, double R) {
        return Vy * Dx / R - Vx * Dy / R;
    }

    private static double XVelocity(double Vs, double Vp, double Dx, double Dy, double R) {
        return Vs * Dx / R - Vp * Dy / R;
    }

    private static double YVelocity(double Vs, double Vp, double Dx, double Dy, double R) {
        return Vs * Dy / R + Vp * Dx / R;
    }

    private static double CollisionVelocity(double V1, double V2, double m1, double m2) {
        return V1 * (m1 - m2) / (m1 + m2) + V2 * (2.0 * m2) / (m1 + m2);
    }

    public static boolean isCollision(Ball ball1, Ball ball2, float dx, float dy) {
        float b1x = ball1.position.x + dx;
        float b1y = ball1.position.y + dy;
        float distance = (float)Math.sqrt((ball2.position.x - b1x) * (ball2.position.x - b1x) + (ball2.position.y - b1y) * (ball2.position.y - b1y));
        return (double)distance <= BallPhysics.RadSum(ball1, ball2);
    }

    public static boolean isCollision(float x, float y, float radius, Ball ball) {
        float distance = (float)Math.sqrt((ball.position.x - x) * (ball.position.x - x) + (ball.position.y - y) * (ball.position.y - y));
        return distance <= radius + ball.radius;
    }

    public static void findCollision(float B2VX, float B2VY, Ball ball1, Ball ball2) {
        double radSum = BallPhysics.RadSum(ball1, ball2);
        float X1 = ball1.position.x + ball1.radius;
        float Y1 = ball1.position.y + ball1.radius;
        float X2 = ball2.position.x + ball2.radius;
        float Y2 = ball2.position.y + ball2.radius;
        double DxR = X2 - X1;
        double DyR = Y2 - Y1;
        double distance = Math.sqrt(DxR * DxR + DyR * DyR);
        double Dx = radSum * DxR / distance;
        double Dy = radSum * DyR / distance;
        if (ball1.mass < ball2.mass) {
            X1 = (float)((double)X1 - (Dx - DxR));
            Y1 = (float)((double)Y1 - (Dy - DyR));
        } else {
            X2 = (float)((double)X2 + (Dx - DxR));
            Y2 = (float)((double)Y2 + (Dy - DyR));
        }
        double Dx1 = (double)ball1.radius / radSum * (double)(X2 - X1);
        double Dx2 = (double)ball2.radius / radSum * (double)(X2 - X1);
        double Dy1 = (double)ball1.radius / radSum * (double)(Y2 - Y1);
        double Dy2 = (double)ball2.radius / radSum * (double)(Y2 - Y1);
        double Vs1 = BallPhysics.StraightVelocity(ball1.velocity.x, ball1.velocity.y, Dx1, Dy1, ball1.radius);
        double Vp1 = BallPhysics.PerpendicularVelocity(ball1.velocity.x, ball1.velocity.y, Dx1, Dy1, ball1.radius);
        double Vs2 = BallPhysics.StraightVelocity(B2VX, B2VY, Dx2, Dy2, ball2.radius);
        double Vp2 = BallPhysics.PerpendicularVelocity(B2VX, B2VY, Dx2, Dy2, ball2.radius);
        double newVs1 = BallPhysics.CollisionVelocity(Vs1, Vs2, ball1.mass, ball2.mass);
        double newVs2 = BallPhysics.CollisionVelocity(Vs2, Vs1, ball2.mass, ball1.mass);
        float coeff = 0.9f;
        ball2.velocity.x = (float)BallPhysics.XVelocity(newVs2, Vp2, Dx2, Dy2, ball2.radius) * coeff;
        ball2.velocity.y = (float)BallPhysics.YVelocity(newVs2, Vp2, Dx2, Dy2, ball2.radius) * coeff;
        double M1 = 2.0 * ball1.mass / (ball1.mass + ball2.mass);
        double M2 = (ball2.mass - ball1.mass) / (ball1.mass + ball2.mass);
        double P2x = Vp2 * Dx / (double)ball2.radius;
        double P2y = Vp2 * Dy / (double)ball2.radius;
        double CX = (((double)B2VX + P2y) / (Dx / (double)ball2.radius) - Vs2 * M2) / M1;
        double CY = (((double)B2VY - P2x) / (Dy / (double)ball2.radius) - Vs2 * M2) / M1;
    }
}

