/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.pions;

import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.physics.Ball;
import com.takyon.battle.game.physics.BallPhysics;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.pions.PionBattleFactory;

public class AirBattle
extends PionBattle {
    public AirBattle() {
    }

    public AirBattle(PlayerBattle player, PionBattle.Type type) {
        super(player, type);
    }

    @Override
    public void onHit(PionBattle ennemy) {
        super.onHit(ennemy);
        ennemy.swordCut = PionBattleFactory.swordcutAir;
        ennemy.swordCut.startAnimation();
        if (this.nbHit > 2) {
            return;
        }
        if (ennemy.type == PionBattle.Type.ROI) {
            if (this.isEvolue) {
                ennemy.perdVie(this.getDamage(25));
            } else {
                ennemy.perdVie(this.getDamage(10));
            }
        } else if (ennemy.type == PionBattle.Type.TERRE) {
            ennemy.perdVie(this.getDamage(25));
        } else if (ennemy.type == PionBattle.Type.EAU) {
            ennemy.perdVie(this.getDamage(50));
            if (ennemy.isDead) {
                this.isEvolue = true;
            }
        } else if (ennemy.type == PionBattle.Type.FEU) {
            ennemy.perdVie(this.getDamage(10));
        } else if (ennemy.type == PionBattle.Type.AIR) {
            ennemy.perdVie(this.getDamage(25));
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.isFury) {
            this.fury();
            this.isFury = false;
        }
    }

    @Override
    public void fury() {
        super.fury();
        int i = 0;
        while (i < this.player.pions.size) {
            Vector2 vec;
            PionBattle pion = (PionBattle)this.player.pions.get(i);
            if (pion != this && (vec = BallPhysics.vector(this.ball, pion.ball)).len() < 5.0f * this.ball.radius + pion.ball.radius) {
                vec.scl(5.0f);
                Ball virtualBall = new Ball(this);
                virtualBall.setPosition(this.getPosition().x, this.getPosition().y);
                virtualBall.setRadius(this.ball.radius);
                virtualBall.velocity.set(vec);
                pion.isThrown = true;
                pion.setState(pion.stateAttacking);
                BallPhysics.Collide(virtualBall, pion.ball);
            }
            ++i;
        }
    }

    @Override
    public void enableCapacity() {
        this.setVisible(false);
    }

    @Override
    public void disableCapacity() {
        this.setVisible(true);
    }

    @Override
    public void move(float dx, float dy, float dt) {
        super.move(dx, dy, dt);
    }

    @Override
    public void onChangeTurn() {
        super.onChangeTurn();
    }

    @Override
    public int getHierarchy() {
        return 2;
    }

    @Override
    public int getValue() {
        return 2;
    }
}

