/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.pions;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.BattleGame;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.pions.PionBattleFactory;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;

public class FeuBattle
extends PionBattle {
    private FireBall[] fireballs;
    public int nbShootMax = 10;
    public int indexShoot = 0;
    ParticleEffect particlesLanceFlammes;
    private boolean hasBeganFury;
    private Vector2 segment1 = new Vector2();
    private Vector2 segment2 = new Vector2();
    private float angleFury;

    public FeuBattle() {
    }

    public FeuBattle(PlayerBattle player, PionBattle.Type type) {
        super(player, type);
        this.fireballs = new FireBall[this.nbShootMax];
        int i = 0;
        while (i < this.nbShootMax) {
            this.fireballs[i] = new FireBall();
            this.fireballs[i].particles.load(Gdx.files.internal("kit_battle/images/particles/fireball.fx"), Gdx.files.internal("kit_battle/images/particles"));
            this.fireballs[i].init();
            ++i;
        }
        this.particlesLanceFlammes = new ParticleEffect();
        this.particlesLanceFlammes.load(Gdx.files.internal("kit_battle/images/particles/lanceflammes.fx"), Gdx.files.internal("kit_battle/images/particles"));
        this.hasBeganFury = false;
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onHit(PionBattle ennemy) {
        super.onHit(ennemy);
        ennemy.swordCut = PionBattleFactory.swordcutFeu;
        ennemy.swordCut.startAnimation();
        if (this.nbHit > 2) {
            return;
        }
        if (this.isInFire) {
            ennemy.setBurning(true);
        }
        if (ennemy.type == PionBattle.Type.ROI) {
            if (this.isEvolue) {
                ennemy.perdVie(this.getDamage(25));
            } else {
                ennemy.perdVie(this.getDamage(10));
            }
        } else if (ennemy.type == PionBattle.Type.TERRE) {
            ennemy.perdVie(this.getDamage(25));
        } else if (ennemy.type == PionBattle.Type.AIR) {
            ennemy.perdVie(this.getDamage(50));
            if (ennemy.isDead) {
                this.isEvolue = true;
                this.gagneVie(50);
            }
        } else if (ennemy.type == PionBattle.Type.FEU) {
            ennemy.perdVie(this.getDamage(25));
        } else if (ennemy.type == PionBattle.Type.EAU) {
            ennemy.perdVie(this.getDamage(10));
        }
    }

    @Override
    public void gagneVie(int vie) {
        super.gagneVie(vie);
    }

    @Override
    public void perdVie(int vie) {
        super.perdVie(vie);
    }

    @Override
    public void onChangeTurn() {
    }

    @Override
    public void logic(float dt) {
        super.logic(dt);
        if (this.isFury && this.hasBeganFury) {
            this.particlesLanceFlammes.update(dt);
            if (this.particlesLanceFlammes.isComplete()) {
                this.particlesLanceFlammes.reset();
                this.isFury = false;
                this.hasBeganFury = false;
            }
        }
    }

    public void shootFire(float velocityX, float velocityY) {
        if (this.indexShoot < this.nbShootMax) {
            FireBall fireball = this.fireballs[this.indexShoot];
            fireball.aim.set(-velocityX, velocityY);
            fireball.velocity.set(velocityX, velocityY);
            fireball.velocity.limit(1.0f);
            fireball.velocity.scl(1000.0f);
            fireball.setPosition(this.getPosition());
            fireball.setVisible(true);
            float deg = fireball.aim.angle();
            float amp = 30.0f;
            ((ParticleEmitter)fireball.particles.getEmitters().first()).getAngle().setHigh(deg + amp, deg - amp);
            ((ParticleEmitter)fireball.particles.getEmitters().first()).getAngle().setLow(deg);
            fireball.particles.reset();
            fireball.particles.start();
            ++this.indexShoot;
            PlayerBattle ennemyPlayer = BattleGame.getEnnemy(this.player);
            for (PionBattle ennemy : ennemyPlayer.pions) {
                ennemy.isHit = false;
            }
        }
    }

    @Override
    public void attack(Vector2 aim) {
        if (this.isFury) {
            Vector2 vAim = new Vector2(aim.x, aim.y);
            vAim.y *= -1.0f;
            float deg = vAim.angle();
            Position pos = this.getPositionScale();
            ParticleEmitter emitter = (ParticleEmitter)this.particlesLanceFlammes.getEmitters().first();
            emitter.setPosition((float)Graphics.decalageX + pos.x, pos.y);
            emitter.getAngle().setHigh(deg + 40.0f, deg - 40.0f);
            emitter.getAngle().setLow(deg);
            this.particlesLanceFlammes.reset();
            this.particlesLanceFlammes.start();
            this.fury();
        } else {
            super.attack(aim);
        }
    }

    @Override
    public void fury() {
        super.fury();
        this.hasBeganFury = true;
        PlayerBattle ennemyPlayer = BattleGame.getEnnemy(this.player);
        for (PionBattle ennemy : ennemyPlayer.pions) {
            Vector2 vec = new Vector2();
            vec.set(ennemy.getPosition().x - this.getPosition().x, ennemy.getPosition().y - this.getPosition().y);
            float angle = vec.angle();
            if (!(Math.abs(angle - this.angleFury) < 30.0f)) continue;
            ennemy.perdVie(25);
        }
    }

    @Override
    public void drawParticles() {
        if (this.isFury) {
            this.particlesLanceFlammes.draw((Batch)GDXImage.batch);
        } else {
            super.drawParticles();
        }
    }

    public void drawFuryAim(Vector2 aim) {
        this.angleFury = aim.angle();
        Position pos = this.getPositionScale();
        pos.x += (float)Graphics.decalageX;
        this.segment1.set(aim);
        this.segment1.y *= -1.0f;
        this.segment1.rotate(-30.0f);
        this.segment2.set(aim);
        this.segment2.y *= -1.0f;
        this.segment2.rotate(30.0f);
        Gdx.gl.glLineWidth(5.0f);
        Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
        Graphics.shapeRenderer.setColor(1.0f, 0.5f, 0.0f, 0.0f);
        Graphics.shapeRenderer.triangle(pos.x, pos.y, pos.x + this.segment1.x, pos.y + this.segment1.y, pos.x + this.segment2.x, pos.y + this.segment2.y);
        Graphics.shapeRenderer.end();
        Gdx.gl20.glLineWidth(1.0f);
    }

    @Override
    public int getHierarchy() {
        return 2;
    }

    @Override
    public int getValue() {
        return 4;
    }

    class FireBall
    extends DrawableObject {
        public ParticleEffect particles;
        public Vector2 aim = new Vector2();
        public Vector2 velocity = new Vector2();
        public float radius = 35.0f;

        public FireBall() {
            this.particles = new ParticleEffect();
        }

        public void init() {
            this.setVisible(false);
        }

        public void logic(float dt) {
            if (this.isVisible()) {
                this.moveX(this.velocity.x * dt);
                this.moveY(this.velocity.y * dt);
                this.getPositionScale();
                ((ParticleEmitter)this.particles.getEmitters().first()).setPosition((float)Graphics.decalageX + this.positionScaled.x, this.positionScaled.y);
                this.particles.update(dt);
            }
        }

        @Override
        public void draw() {
            if (this.isVisible()) {
                this.particles.draw((Batch)GDXImage.batch);
            }
        }
    }
}

