/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.pions;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.takyon.battle.BattleGame;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.pions.AirBattle;
import com.takyon.battle.game.pions.EauBattle;
import com.takyon.battle.game.pions.FeuBattle;
import com.takyon.battle.game.pions.OeufBattle;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.pions.RoiBattle;
import com.takyon.battle.game.pions.TerreBattle;
import com.takyon.gamelib.GDXImageRegion;
import com.takyon.gamelib.GDXSprite;

public class PionBattleFactory {
    public static transient GDXImageRegion[] imagesPions;
    public static transient GDXImageRegion imageEtoile;
    public static transient GDXImageRegion imageBurning;
    public static transient GDXImageRegion effectEau;
    public static transient GDXImageRegion effectFury;
    public static transient ParticleEffect particlesFeu;
    public static transient ParticleEffect particlesAir;
    public static transient ParticleEffect particlesEau;
    public static transient ParticleEffect particlesTerre;
    public static transient ParticleEffect particlesRoi;
    public static transient Sound fx_feu;
    public static transient Sound fx_eau;
    public static transient Sound fx_terre;
    public static transient Sound fx_air;
    public static transient Sound fx_roi;
    public static transient Sound fx_attaque;
    public static transient Sound fx_rebond;
    public static transient TextureAtlas atlasPions;
    public static transient TextureAtlas atlasEffects;
    public static transient GDXSprite swordcutAir;
    public static transient GDXSprite swordcutEau;
    public static transient GDXSprite swordcutFeu;
    public static transient GDXSprite swordcutTerre;

    public static void initImages() {
        atlasPions = new TextureAtlas(Gdx.files.internal(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/pions/pions.atlas"));
        atlasEffects = new TextureAtlas(Gdx.files.internal(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/effects/effects.atlas"));
        effectEau = new GDXImageRegion((TextureRegion)atlasEffects.findRegion("eau"));
        effectFury = new GDXImageRegion((TextureRegion)atlasEffects.findRegion("fury"));
        particlesFeu = new ParticleEffect();
        particlesFeu.load(Gdx.files.internal("kit_battle/images/particles/feu.fx"), Gdx.files.internal("kit_battle/images/particles"));
        particlesAir = new ParticleEffect();
        particlesAir.load(Gdx.files.internal("kit_battle/images/particles/air.fx"), Gdx.files.internal("kit_battle/images/particles"));
        particlesEau = new ParticleEffect();
        particlesEau.load(Gdx.files.internal("kit_battle/images/particles/eau.fx"), Gdx.files.internal("kit_battle/images/particles"));
        particlesTerre = new ParticleEffect();
        particlesTerre.load(Gdx.files.internal("kit_battle/images/particles/terre.fx"), Gdx.files.internal("kit_battle/images/particles"));
        particlesRoi = new ParticleEffect();
        particlesRoi.load(Gdx.files.internal("kit_battle/images/particles/roi.fx"), Gdx.files.internal("kit_battle/images/particles"));
        imagesPions = new GDXImageRegion[PionBattle.Type.values().length];
        int i = 0;
        while (i < PionBattle.Type.values().length) {
            PionBattle.Type type = PionBattle.Type.values()[i];
            String typeName = type.toString().toLowerCase();
            PionBattleFactory.imagesPions[type.ordinal()] = new GDXImageRegion((TextureRegion)atlasPions.findRegion(typeName));
            ++i;
        }
        imageEtoile = new GDXImageRegion((TextureRegion)atlasPions.findRegion("etoile"));
        imageBurning = new GDXImageRegion((TextureRegion)atlasPions.findRegion("burning"));
        swordcutAir = new GDXSprite(new Texture(Gdx.files.internal(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/effects/swordcut/sword_effect_air.png")), 3, 2, 20);
        swordcutEau = new GDXSprite(new Texture(Gdx.files.internal(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/effects/swordcut/sword_effect_eau.png")), 3, 2, 20);
        swordcutFeu = new GDXSprite(new Texture(Gdx.files.internal(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/effects/swordcut/sword_effect_feu.png")), 3, 2, 20);
        swordcutTerre = new GDXSprite(new Texture(Gdx.files.internal(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/effects/swordcut/sword_effect_terre.png")), 3, 2, 20);
    }

    public static void initSounds() {
    }

    public static PionBattle createPion(PlayerBattle player, PionBattle.Type type) {
        PionBattle pion = null;
        float c = 2.0f;
        int size = 80;
        switch (type) {
            case ROI: {
                pion = new RoiBattle(player, type);
                pion.setRadiusInitial(size);
                pion.speed_max = 800.0f * c;
                pion.particles = new ParticleEffect(particlesRoi);
                break;
            }
            case AIR: {
                pion = new AirBattle(player, type);
                pion.setRadiusInitial(size);
                pion.speed_max = 1200.0f * c;
                pion.particles = new ParticleEffect(particlesAir);
                break;
            }
            case FEU: {
                pion = new FeuBattle(player, type);
                pion.setRadiusInitial(size);
                pion.speed_max = 1000.0f * c;
                pion.particles = new ParticleEffect(particlesFeu);
                break;
            }
            case EAU: {
                pion = new EauBattle(player, type);
                pion.setRadiusInitial(size);
                pion.speed_max = 1000.0f * c;
                pion.particles = new ParticleEffect(particlesEau);
                break;
            }
            case TERRE: {
                pion = new TerreBattle(player, type);
                pion.setRadiusInitial(size);
                pion.speed_max = 500.0f * c;
                pion.particles = new ParticleEffect(particlesTerre);
                break;
            }
            case OEUF: {
                pion = new OeufBattle(player, type);
                break;
            }
        }
        return pion;
    }

    public static PionBattle createPionFrom(PlayerBattle player, PionBattle pion) {
        if (pion.type == PionBattle.Type.OEUF) {
            OeufBattle oeuf = (OeufBattle)pion;
            OeufBattle newOeuf = new OeufBattle(player, pion.type);
            newOeuf.content = oeuf.content;
            return newOeuf;
        }
        return PionBattleFactory.createPion(player, pion.type);
    }

    public static PionBattle createPion(PlayerBattle player, PionBattle.Type type, int i, int j) {
        PionBattle pion = PionBattleFactory.createPion(player, type);
        return pion;
    }
}

