/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.pions;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.BattleGame;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.physics.Ball;
import com.takyon.battle.game.physics.BallPhysics;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.pions.PionBattleFactory;
import com.takyon.battle.game.statemachine.PionState;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public class TerreBattle
extends PionBattle {
    public TerreBattle() {
    }

    public TerreBattle(PlayerBattle player, PionBattle.Type type) {
        super(player, type);
    }

    @Override
    public void logic(float dt) {
        super.logic(dt);
        this.particles = this.isInFire ? PionBattleFactory.particlesFeu : PionBattleFactory.particlesTerre;
    }

    @Override
    public void onHit(PionBattle ennemy) {
        super.onHit(ennemy);
        ennemy.swordCut = PionBattleFactory.swordcutTerre;
        ennemy.swordCut.startAnimation();
        if (this.nbHit > 2) {
            return;
        }
        if (ennemy.type == PionBattle.Type.ROI) {
            ennemy.perdVie(this.getDamage(5));
        } else {
            ennemy.perdVie(this.getDamage(25));
        }
    }

    @Override
    public void fury() {
        super.fury();
        if (this.state.pionStateEnum == PionBattle.PionStateEnum.ATTACKING) {
            PlayerBattle ennemy = BattleGame.getEnnemy(this.player);
            int i = 0;
            while (i < ennemy.pions.size) {
                PionBattle pionEnnemy = (PionBattle)ennemy.pions.get(i);
                Vector2 vec = BallPhysics.vector(this.ball, pionEnnemy.ball);
                if (vec.len() < 5.0f * this.ball.radius + pionEnnemy.ball.radius) {
                    vec.scl(1.5f);
                    Ball virtualBall = new Ball(this);
                    virtualBall.setPosition(this.getPosition().x, this.getPosition().y);
                    virtualBall.setRadius(this.ball.radius);
                    virtualBall.velocity.set(vec);
                    pionEnnemy.setState(pionEnnemy.stateHit);
                    BallPhysics.Collide(virtualBall, pionEnnemy.ball);
                    pionEnnemy.perdVie(20);
                    pionEnnemy.isHit = true;
                }
                ++i;
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.isFury) {
            this.fury();
            this.isFury = false;
        }
    }

    @Override
    public void setState(PionState state) {
        super.setState(state);
    }

    @Override
    public void onChangeTurn() {
        super.onChangeTurn();
    }

    @Override
    public void enableCapacity() {
    }

    @Override
    public void disableCapacity() {
    }

    @Override
    public int getHierarchy() {
        return 1;
    }

    @Override
    public int getValue() {
        return 1;
    }

    @Override
    public void drawHud(Position pos, float r) {
        super.drawHud(pos, r);
        if (this.isFury) {
            Gdx.gl20.glLineWidth(5.0f);
            Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            Graphics.shapeRenderer.setColor(0.7f, 0.6f, 0.25f, 1.0f);
            Graphics.drawCircle(pos, this.ball.radius * 5.0f * Scene2D.RATIO, 0, 360);
            Graphics.shapeRenderer.end();
            Gdx.gl20.glLineWidth(1.0f);
        }
    }
}

