/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.screens;

import com.takyon.battle.BattleGame;
import com.takyon.battle.network.messages.game.InviteBattleMessage;
import com.takyon.battle.screens.BattleGameScreen;
import com.takyon.chess.utils.Fonts;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXDialog;
import com.takyon.gamelib.GDXGameNet;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GDXTextButton;
import com.takyon.gamelib.Language;
import com.takyon.gamelib.network.JoueurNetLine;
import com.takyon.gamelib.network.Partie;
import com.takyon.gamelib.network.PlayerNet;
import com.takyon.gamelib.network.server.AcceptInvitationMessage;
import com.takyon.gamelib.network.server.CreerPartieMessage;
import com.takyon.gamelib.network.server.RequestListeJoueursMessage;
import java.util.ArrayList;

public class BattleScreenParties
extends BattleGameScreen {
    private GDXTextButton btnCreerPartie;
    private GDXTextButton btnRefreshGame;
    public static ArrayList<Partie> listParties;
    public static GDXDialog inviteDialog;
    public static ArrayList<JoueurNetLine> listJoueurs;
    public static ArrayList<PlayerNet> joueurs;

    @Override
    public void firstInit() {
    }

    @Override
    public void init() {
        inviteDialog = new GDXDialog(){

            @Override
            public void onYes() {
                GDXGameNet.playerNet.opponentId = this.opponentId;
                GDXGameNet.clientToServer.id = GDXGameNet.playerNet.id;
                GDXGameNet.clientToServer.sendToServer(new AcceptInvitationMessage(this.opponentId, GDXGameNet.playerNet.id));
            }
        };
        listParties = new ArrayList();
        listJoueurs = new ArrayList();
        this.btnCreerPartie = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/create", true, false, false);
        this.btnCreerPartie.label = new GDXText(Fonts.BUTTON, Language.tr("menu.creategame"));
        this.btnCreerPartie.setPosition(150.0f, 250.0f);
        this.btnRefreshGame = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/refresh", true, false, false);
        this.btnRefreshGame.setPosition(550.0f, 250.0f);
        this.btnRefreshGame.label = new GDXText(Fonts.BUTTON, Language.tr("menu.refreshgames"));
    }

    public static void refreshJoueurs(ArrayList<PlayerNet> joueurs) {
        int c = 0;
        listJoueurs.clear();
        for (PlayerNet playerNet : joueurs) {
            if (playerNet.id == GDXGameNet.playerNet.id) continue;
            GDXText text = new GDXText(Fonts.TEXT, playerNet.name);
            text.setPosition(150.0f, c * 100 + 450);
            GDXButton button = new GDXButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, false);
            button.setPosition(650.0f, c * 100 + 450);
            JoueurNetLine joueurLine = new JoueurNetLine();
            joueurLine.joueur = playerNet;
            joueurLine.text = text;
            joueurLine.button = button;
            listJoueurs.add(joueurLine);
            ++c;
        }
    }

    @Override
    public void display() {
        GDXImage.batch.begin();
        this.btnCreerPartie.draw();
        this.btnRefreshGame.draw();
        for (JoueurNetLine line : listJoueurs) {
            line.text.draw();
            line.button.draw();
        }
        inviteDialog.draw();
        GDXImage.batch.end();
    }

    @Override
    public void finish() {
    }

    @Override
    public void process(float dt) {
        if (joueurs != null) {
            BattleScreenParties.refreshJoueurs(joueurs);
            joueurs = null;
        }
        for (JoueurNetLine joueurNetLine : listJoueurs) {
        }
    }

    @Override
    public void onTouched(int x, int y, int pointer, int button) {
        if (inviteDialog.isVisible()) {
            inviteDialog.onTouchDown(x, y);
        } else if (this.btnCreerPartie.isClicked(x, y)) {
            GDXGameNet.clientToServer.sendToServer(new CreerPartieMessage(GDXGameNet.playerNet.id, GDXGameNet.playerNet.name));
        } else if (this.btnRefreshGame.isClicked(x, y)) {
            GDXGameNet.clientToServer.sendToServer(new RequestListeJoueursMessage());
        } else {
            for (JoueurNetLine joueurNetLine : listJoueurs) {
                if (!joueurNetLine.button.isClicked(x, y)) continue;
                GDXGameNet.clientToServer.sendMessage(joueurNetLine.joueur.id, new InviteBattleMessage(GDXGameNet.playerNet.id));
            }
        }
    }
}

