/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle_royale.desktop;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.SerializationException;
import com.takyon.battle_royale.desktop.DesktopLauncher;
import com.takyon.chess.game.ChessGame;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.network.messages.game.PlacementMessage;
import com.takyon.chess.screens.ScreenGame;
import com.takyon.chess.test.SaveBug;
import com.takyon.chess.test.SaveOptions;
import com.takyon.chess.test.SavePlateau;
import com.takyon.gamelib.AbstractMessage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TestInterface
extends JFrame {
    private static JList<SavePlateau> listPlacements;
    private static JList<SaveOptions> listOptions;
    private static JList<SaveBug> listBugs;
    private JButton buttonResetPlateau;
    private JButton buttonSavePlateau;
    private JButton buttonLoadPlateau;
    private JButton buttonSaveBug;
    private JButton buttonSaveOptions;
    private JButton buttonLoadOptions;
    private JButton buttonLoadBug;
    private JButton buttonNextAction;
    private SavePlateau[] savesPlateau;
    private SaveOptions[] savesOptions;
    private SaveBug[] bugs;
    private SaveBug currentBug;
    private int indiceAction;
    private Json json = new Json();

    public TestInterface() {
        this.json.setOutputType(JsonWriter.OutputType.json);
        this.setLayout(null);
        this.buttonResetPlateau = new JButton("Reset Placement");
        this.buttonResetPlateau.setBounds(0, 0, 250, 25);
        this.buttonSavePlateau = new JButton("Sauvegarder Placement");
        this.buttonSavePlateau.setBounds(0, 25, 250, 25);
        this.buttonLoadPlateau = new JButton("Charger Placement");
        this.buttonLoadPlateau.setBounds(0, 50, 250, 25);
        this.buttonSaveBug = new JButton("Sauvegarder bug");
        this.buttonSaveBug.setBounds(250, 0, 250, 25);
        this.buttonLoadBug = new JButton("Charger bug");
        this.buttonLoadBug.setBounds(250, 25, 250, 25);
        this.buttonNextAction = new JButton("Action suivante");
        this.buttonNextAction.setBounds(250, 50, 250, 25);
        this.buttonSaveOptions = new JButton("Sauvegarder options");
        this.buttonSaveOptions.setBounds(500, 25, 250, 25);
        this.buttonLoadOptions = new JButton("Charger options");
        this.buttonLoadOptions.setBounds(500, 0, 250, 25);
        this.add(this.buttonResetPlateau);
        this.add(this.buttonSavePlateau);
        this.add(this.buttonLoadPlateau);
        this.add(this.buttonSaveBug);
        this.add(this.buttonLoadBug);
        this.add(this.buttonSaveOptions);
        this.add(this.buttonLoadOptions);
        this.add(this.buttonNextAction);
        this.buttonNextAction.setVisible(false);
        listPlacements = new JList();
        this.setListPlacements();
        listPlacements.setFixedCellHeight(25);
        listPlacements.setBorder(BorderFactory.createTitledBorder("placements"));
        JScrollPane sp_listPlacements = new JScrollPane(listPlacements);
        sp_listPlacements.setBounds(0, 75, 250, 700);
        listBugs = new JList();
        this.setListBugs();
        listBugs.setFixedCellHeight(25);
        listBugs.setBorder(BorderFactory.createTitledBorder("bugs"));
        JScrollPane sp_listBugs = new JScrollPane(listBugs);
        sp_listBugs.setBounds(250, 75, 250, 700);
        listOptions = new JList();
        this.setListOptions();
        listOptions.setFixedCellHeight(25);
        listOptions.setBorder(BorderFactory.createTitledBorder("options"));
        JScrollPane sp_listOptions = new JScrollPane(listOptions);
        sp_listOptions.setBounds(500, 75, 250, 300);
        this.add(sp_listPlacements);
        this.add(sp_listOptions);
        this.add(sp_listBugs);
        this.setEvents();
        this.setSize(1920, 800);
        this.setVisible(true);
    }

    private void setEvents() {
        this.buttonResetPlateau.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestInterface.this.resetPlateauTest();
            }
        });
        this.buttonLoadPlateau.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChessGame.loadPlacement((SavePlateau)listPlacements.getSelectedValue());
            }
        });
        this.buttonSavePlateau.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestInterface.this.savePlateauTest();
            }
        });
        this.buttonSaveBug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestInterface.this.saveBug();
            }
        });
        this.buttonLoadBug.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestInterface.this.loadBug();
            }
        });
        this.buttonNextAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestInterface.this.nextAction();
            }
        });
        this.buttonSaveOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestInterface.this.saveOptions();
            }
        });
        this.buttonLoadOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TestInterface.this.loadOptions((SaveOptions)listOptions.getSelectedValue());
            }
        });
        listBugs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TestInterface.this.currentBug = (SaveBug)listBugs.getSelectedValue();
            }
        });
    }

    protected void resetPlateauTest() {
        GameRules.grid.reset();
        GameRules.historiqueActions.clear();
        ChessGame.playerRed.reset();
        ChessGame.playerBlue.reset();
        ScreenGame.isPlacing = true;
    }

    private void setListPlacements() {
        File dir = new File("tests");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("plac");
            }
        });
        if (files != null && files.length > 0) {
            this.savesPlateau = new SavePlateau[files.length];
            int i = 0;
            while (i < this.savesPlateau.length) {
                try {
                    if (files[i].getName().endsWith(".plac")) {
                        this.savesPlateau[i] = (SavePlateau)this.json.fromJson(SavePlateau.class, (Reader)new FileReader(files[i]));
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SerializationException se) {
                    se.printStackTrace();
                }
                ++i;
            }
            listPlacements.setListData((SavePlateau[])this.savesPlateau);
        }
    }

    private void savePlateauTest() {
        String name = JOptionPane.showInputDialog(this, "Nom de la sauvegarde :\n", "Nom de la sauvegarde");
        SavePlateau save = new SavePlateau(name);
        save.saveP();
        this.setListPlacements();
        this.repaint();
    }

    private void setListBugs() {
        File dir = new File("bugs");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("bug");
            }
        });
        if (files != null && files.length > 0) {
            this.bugs = new SaveBug[files.length];
            int i = 0;
            while (i < this.bugs.length) {
                try {
                    this.bugs[i] = (SaveBug)this.json.fromJson(SaveBug.class, (Reader)new FileReader(files[i]));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SerializationException se) {
                    se.printStackTrace();
                }
                ++i;
            }
            listBugs.setListData((SaveBug[])this.bugs);
        }
    }

    public void saveBug() {
        String name = JOptionPane.showInputDialog(this, "Nom du bug :\n", "Nom du bug");
        SaveBug saveBug = new SaveBug(name);
        saveBug.save();
        this.setListBugs();
        this.repaint();
    }

    public void loadBug() {
        this.buttonNextAction.setVisible(true);
        this.indiceAction = 0;
    }

    protected void saveOptions() {
        String name = JOptionPane.showInputDialog(this, "Options :\n", "Nom du fichier d'options");
        SaveOptions saveOptions = new SaveOptions(name);
        saveOptions.optionNbColumnsGrid = GameRules.optionNbColumnsGrid;
        saveOptions.optionNbRowsGrid = GameRules.optionNbRowsGrid;
        saveOptions.optionsBlack = GameRules.optionsRed;
        saveOptions.optionsWhite = GameRules.optionsBlue;
        saveOptions.save();
        this.setListOptions();
        this.repaint();
    }

    protected void loadOptions(SaveOptions saveOptions) {
        GameRules.optionNbColumnsGrid = saveOptions.optionNbColumnsGrid;
        GameRules.optionNbRowsGrid = saveOptions.optionNbRowsGrid;
        GameRules.optionsRed = saveOptions.optionsBlack;
        GameRules.optionsBlue = saveOptions.optionsWhite;
    }

    private void setListOptions() {
        File dir = new File("options");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("opt");
            }
        });
        if (files != null && files.length > 0) {
            this.savesOptions = new SaveOptions[files.length];
            int i = 0;
            while (i < this.savesOptions.length) {
                try {
                    this.savesOptions[i] = (SaveOptions)this.json.fromJson(SaveOptions.class, (Reader)new FileReader(files[i]));
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (SerializationException se) {
                    se.printStackTrace();
                }
                ++i;
            }
            listOptions.setListData((SaveOptions[])this.savesOptions);
        }
    }

    public void nextAction() {
        if (this.indiceAction < this.currentBug.bug.size) {
            ((AbstractMessage)this.currentBug.bug.get(this.indiceAction++)).execute();
            if (this.currentBug.bug.get(this.indiceAction - 1) instanceof PlacementMessage) {
                GameRules.currentPlayer.hasFinishedPlacing = true;
                if (ChessGame.playerRed.hasFinishedPlacing() && ChessGame.playerBlue.hasFinishedPlacing()) {
                    ScreenGame.isPlacing = false;
                }
                ScreenGame.changeTurn();
            }
        }
    }

    public static void main(String[] args) {
        ChessGame.KIT_DIRECTORY = "kit";
        if (args.length > 0) {
            ChessGame.KIT_DIRECTORY = args[0];
        }
        new TestInterface();
        DesktopLauncher.main(null);
    }
}

