/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battleship;

import com.takyon.battleship.Part;

public class Ship {
    public Part[] parts;
    public boolean isDestroyed;

    public Ship(int i, int j, Direction direction, int length) {
        block3: {
            block2: {
                this.parts = new Part[length];
                if (direction != Direction.HORIZONTAL) break block2;
                int c = 0;
                while (c < length) {
                    this.parts[c] = new Part(i + c, j);
                    ++c;
                }
                break block3;
            }
            if (direction != Direction.VERTICAL) break block3;
            int c = 0;
            while (c < length) {
                this.parts[c] = new Part(i, j + c);
                ++c;
            }
        }
    }

    public void init() {
        this.isDestroyed = false;
        int c = 0;
        while (c < this.parts.length) {
            this.parts[c].isTouched = false;
            ++c;
        }
    }

    public Part getPart(int i, int j) {
        int c = 0;
        while (c < this.parts.length) {
            Part part = this.parts[c];
            if (part != null && part.i == i && part.j == j) {
                return part;
            }
            ++c;
        }
        return null;
    }

    public boolean isDestroyed() {
        int c = 0;
        while (c < this.parts.length) {
            Part part = this.parts[c];
            if (part != null && !part.isTouched) {
                return false;
            }
            ++c;
        }
        return true;
    }

    public static enum Direction {
        HORIZONTAL,
        VERTICAL;

    }
}

