/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.game;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.ObjectMap;
import com.takyon.chess.game.Grid;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.game.ia.ChessIA;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.network.messages.game.PlacementMessage;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.PionFactory;
import com.takyon.chess.screens.ChessGameScreen;
import com.takyon.chess.screens.ScreenGame;
import com.takyon.chess.test.SaveBug;
import com.takyon.chess.test.SaveOptions;
import com.takyon.chess.test.SavePlateau;
import com.takyon.chess.utils.BattleGraphics;
import com.takyon.chess.utils.Fonts;
import com.takyon.chess.utils.Positions;
import com.takyon.chess.utils.SavePlacementState;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXGameNet;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GameScreen;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.IBrowser;
import com.takyon.gamelib.Language;
import com.takyon.gamelib.Scene2D;
import java.io.FileNotFoundException;
import java.util.HashMap;

public class ChessGame
extends ApplicationAdapter
implements InputProcessor {
    public static GDXGameNet gameNet;
    private static final String PREFS_PLACEMENTS = "placements";
    public static String KIT_DIRECTORY;
    public static ObjectMap<String, String> properties;
    public static Preferences prefs;
    public static Json json;
    public static boolean isDebug;
    public static IBrowser browser;
    public static HashMap<String, SavePlacementState> mapPlacementsPlayer;
    public static HashMap<String, SavePlateau> mapPlacements;
    public static boolean isNetwork;
    public static GDXImage pointer;
    public static boolean isIA;
    public static ChessIA ia;
    public static GameRules gameRules;
    public static Player playerRed;
    public static Player playerBlue;

    static {
        KIT_DIRECTORY = null;
        isIA = false;
    }

    public void create() {
        isDebug = true;
        Scene2D.SCREEN_WIDTH_BASE = 1920;
        Scene2D.SCREEN_HEIGHT_BASE = 1080;
        Scene2D.RATIO = (float)Gdx.app.getGraphics().getWidth() / (float)Scene2D.SCREEN_WIDTH_BASE;
        new Positions();
        GDXButton.suffix_up = "_off";
        GDXButton.suffix_down = "_on";
        GDXButton.suffix_disabled = "_disabled";
        GDXImage.batch = new SpriteBatch();
        BattleGraphics.initGraphics();
        pointer = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/pointeur.png");
        new Language(Gdx.files.internal(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/labels.fr").read());
        try {
            Fonts fonts = new Fonts(String.valueOf(GDXGame.KIT_DIRECTORY) + "/fonts/", String.valueOf(GDXGame.KIT_DIRECTORY) + "/fonts/polices.txt");
            fonts.load();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Gdx.input.setInputProcessor((InputProcessor)this);
        json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        prefs = Gdx.app.getPreferences("PREFS_DINO");
        gameRules = new GameRules();
        ChessGameScreen.initScreens();
        GameScreen.setScreen(ChessGameScreen.screenIntro);
    }

    public static void initGame() {
        mapPlacementsPlayer = new HashMap();
        mapPlacements = new HashMap();
        gameRules.init();
        if (isIA) {
            ia = new ChessIA();
            ChessGame.ia.IAPlayer = playerRed;
        }
    }

    public static Player getEnnemy(Player player) {
        if (player.color == PlayerColor.BLACK) {
            return playerBlue;
        }
        if (player.color == PlayerColor.WHITE) {
            return playerRed;
        }
        return null;
    }

    public static void loadPlacement(SavePlateau save) {
        if (GameScreen.currentScreen == ChessGameScreen.screenGame) {
            Pion newPion;
            GameRules.historiqueActions.clear();
            GameRules.grid = new Grid(save.nbCols, save.nbRows);
            GameRules.grid.init();
            ChessGame.playerBlue.pions.clear();
            for (Pion pion : save.saveWhite.pions) {
                newPion = PionFactory.createPionFrom(playerBlue, pion);
                GameRules.grid.setPion(newPion.i, newPion.j, newPion);
                ChessGame.playerBlue.pions.add((Object)newPion);
            }
            ChessGame.playerRed.pions.clear();
            for (Pion pion : save.saveBlack.pions) {
                newPion = PionFactory.createPionFrom(playerRed, pion);
                GameRules.grid.setPion(newPion.i, newPion.j, newPion);
                ChessGame.playerRed.pions.add((Object)newPion);
            }
            playerBlue.copyFrom(save.saveWhite.player);
            playerRed.copyFrom(save.saveBlack.player);
            GameRules.historiqueActions.add((Object)new PlacementMessage(ChessGame.playerBlue.color, ChessGame.playerBlue.pions));
            GameRules.historiqueActions.add((Object)new PlacementMessage(ChessGame.playerRed.color, ChessGame.playerRed.pions));
            ScreenGame.initTurn(playerBlue);
            ScreenGame.isPlacing = true;
        }
    }

    public static void loadPlacementPlayer(SavePlacementState state) {
        Player player = null;
        if (state.player.color == PlayerColor.WHITE) {
            player = playerBlue;
        } else if (state.player.color == PlayerColor.BLACK) {
            player = playerRed;
        }
        if (player != null) {
            player.pions.clear();
            player.pions.addAll(state.pions);
            for (Pion pion : state.pions) {
                pion.player = player;
                pion.grid = GameRules.grid;
                pion.setImage();
                GameRules.grid.setPion(pion.i, pion.j, pion);
            }
        }
    }

    public static void saveBug() {
        SaveBug saveBug = new SaveBug("bug_" + System.currentTimeMillis());
        saveBug.save();
    }

    public static void savePlacement(String name) {
        SavePlateau savePlateau = new SavePlateau(name);
        mapPlacements.put(name, savePlateau);
        prefs.putString(PREFS_PLACEMENTS, json.toJson(mapPlacements));
        prefs.flush();
    }

    public static void savePlacementPlayer(Player player, String fileName) {
        SavePlacementState placementState = new SavePlacementState(fileName);
        placementState.pions = player.pions;
        placementState.player = player;
        mapPlacementsPlayer.put(fileName, placementState);
        prefs.putString("placementsPlayer", json.toJson(mapPlacementsPlayer));
        prefs.flush();
    }

    public void render() {
        float dt = Gdx.graphics.getDeltaTime();
        GameScreen.checkScreenChange();
        GameScreen.currentScreen.process(dt);
        Gdx.gl.glClear(16384);
        GDXImage.batch.begin();
        GameScreen.currentScreen.display();
        if (Gdx.app.getType() == Application.ApplicationType.Desktop || Gdx.app.getType() == Application.ApplicationType.Applet) {
            pointer.display();
        }
        GDXImage.batch.end();
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        GameScreen.currentScreen.keyUp(keycode);
        return false;
    }

    public boolean keyTyped(char character) {
        if (character == 'f') {
            Gdx.graphics.setDisplayMode(Gdx.graphics.getDesktopDisplayMode().width, Gdx.graphics.getDesktopDisplayMode().height, true);
        }
        GameScreen.currentScreen.keyTyped(character);
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.onTouchDown(x, y, pointer, button);
        return true;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.onTouched(x, y, pointer, button);
        return true;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.mouseMoved(x, y);
        pointer.setPosition(x, y);
        return false;
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        Scene2D.RATIO = (float)Gdx.app.getGraphics().getHeight() / (float)Scene2D.SCREEN_HEIGHT_BASE;
        Graphics.decalageX = (int)(((float)Gdx.app.getGraphics().getWidth() - (float)Scene2D.SCREEN_WIDTH_BASE * Scene2D.RATIO) / 2.0f);
    }

    public boolean scrolled(int amount) {
        return false;
    }

    public static void setfullscreen() {
    }

    public static void createBug() {
        SaveBug saveBug = new SaveBug("bug_" + System.currentTimeMillis());
        saveBug.save();
    }

    public static void saveOptions(String name) {
        SaveOptions saveOptions = new SaveOptions(name);
        saveOptions.optionNbColumnsGrid = GameRules.optionNbColumnsGrid;
        saveOptions.optionNbRowsGrid = GameRules.optionNbRowsGrid;
        saveOptions.optionsBlack = GameRules.optionsRed;
        saveOptions.optionsWhite = GameRules.optionsBlue;
        saveOptions.save();
    }
}

