/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.game.ia;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.Cell;
import com.takyon.chess.game.ChessGame;
import com.takyon.chess.game.Coup;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.exceptions.PionNullException;
import com.takyon.chess.game.ia.CoupIA;
import com.takyon.chess.game.ia.GrapheCoups;
import com.takyon.chess.game.ia.GridState;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.PionFactory;
import com.takyon.gamelib.MathUtils;

public class ChessIA {
    public Player IAPlayer;
    public int max_depth = 5;

    private Array<Coup> getListCoups(Player player) throws PionNullException {
        Array coups = new Array();
        for (Pion pion : player.pions) {
            Coup coup;
            pion.setAvailableCellsSuper();
            for (Cell cell : pion.cellsTake) {
                coup = new Coup(pion, cell);
                Pion pionTaken = GameRules.grid.getPion(cell.i, cell.j);
                if (pionTaken == null) {
                    throw new PionNullException();
                }
                coup.setValue(pionTaken.getValue());
                if (this.isDangereux(player, coup)) {
                    coup.setValue(-1 * coup.getValue());
                }
                coups.add((Object)coup);
            }
            for (Cell cell : pion.cellsVoid) {
                coup = new Coup(pion, cell);
                coup.setValue(0);
                coups.add((Object)coup);
            }
            for (Cell cell : pion.cellsJoker) {
                coup = new Coup(pion, cell);
                coup.setValue(-1);
                coups.add((Object)coup);
            }
        }
        return coups;
    }

    private boolean isDangereux(Player player, Coup coup) {
        Pion pionVirtuel = PionFactory.createPionFrom(player, coup.pion);
        pionVirtuel.i = coup.dest.i;
        pionVirtuel.j = coup.dest.j;
        GridState gridState = GameRules.grid.getState();
        gridState.setPion(pionVirtuel.i, pionVirtuel.j, pionVirtuel);
        Player ennemy = ChessGame.getEnnemy(player);
        boolean canTake = false;
        for (Pion pion : ennemy.pions) {
            pion.setAvailableCellsSuper(gridState);
            if (!pion.canMoveAndTake(pionVirtuel)) continue;
            canTake = true;
            break;
        }
        return canTake;
    }

    public Coup coupProtection(Player player) {
        Pion pion = this.getPionEnDangerPrioritaire(player);
        if (pion != null) {
            return this.coupRandom(pion);
        }
        return null;
    }

    public Coup coupRandom(Pion pion) {
        pion.setAvailableCellsSuper();
        Array<Cell> totalCells = pion.getTotalCells();
        if (totalCells.size > 0) {
            int indexCell = MathUtils.randomInt(0, totalCells.size - 1);
            return new Coup(pion, (Cell)totalCells.get(indexCell));
        }
        return null;
    }

    public Coup coupRandom(Player player) {
        int indexPion;
        Pion pion;
        Array movablePions = new Array();
        for (Pion pion2 : player.pions) {
            pion2.setAvailableCellsSuper();
            if (pion2.getTotalCells().size <= 0) continue;
            movablePions.add((Object)pion2);
        }
        if (movablePions.size == 0) {
            System.out.println("no movable");
        }
        if ((pion = (Pion)movablePions.get(indexPion = MathUtils.randomInt(0, movablePions.size - 1))) != null) {
            return this.coupRandom(pion);
        }
        return null;
    }

    public Coup meilleurCoup(Player player) {
        try {
            Array<Coup> coups = this.getListCoups(player);
            coups.sort();
            if (coups.size > 0) {
                return (Coup)coups.get(0);
            }
        }
        catch (PionNullException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean isEnDanger(Pion pion) {
        Player ennemy = ChessGame.getEnnemy(pion.player);
        for (Pion pionEnnemy : ennemy.pions) {
            pionEnnemy.setAvailableCellsSuper();
            if (!pionEnnemy.canMoveAndTake(pion)) continue;
            return true;
        }
        return false;
    }

    private Pion getPionEnDangerPrioritaire(Player player) {
        Array pionsEnDanger = new Array();
        for (Pion pion : player.pions) {
            if (!this.isEnDanger(pion)) continue;
            pionsEnDanger.add((Object)pion);
        }
        if (pionsEnDanger.size > 0) {
            pionsEnDanger.sort();
            return (Pion)pionsEnDanger.get(0);
        }
        return null;
    }

    public Coup play() {
        GrapheCoups grapheCoups = this.createGraph();
        Coup coup = this.coupProtection(this.IAPlayer);
        if (coup == null && (coup = this.meilleurCoup(this.IAPlayer)) == null) {
            coup = this.coupRandom(this.IAPlayer);
        }
        return coup;
    }

    public GrapheCoups createGraph() {
        GrapheCoups grapheCoups = new GrapheCoups();
        this.fillGraph(grapheCoups, GameRules.grid.getState(), this.IAPlayer, 0);
        return grapheCoups;
    }

    public void fillGraph(GrapheCoups grapheCoups, GridState state, Player player, int depth) {
        if (depth < this.max_depth) {
            try {
                Array<Coup> coups = this.getListCoups(player);
                for (Coup coup : coups) {
                    CoupIA coupIA = new CoupIA();
                    coupIA.state1 = state;
                    coupIA.coup = coup;
                    coupIA.state2 = new GridState(state, coup);
                    grapheCoups.coups.add((Object)coupIA);
                    System.out.println(ChessGame.getEnnemy(player));
                    this.fillGraph(grapheCoups, coupIA.state2, ChessGame.getEnnemy(player), depth + 1);
                }
            }
            catch (PionNullException e) {
                e.printStackTrace();
            }
        }
    }
}

