/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.gui;

import com.takyon.chess.game.rules.GameParamaterInt;
import com.takyon.chess.gui.GUIComponent;
import com.takyon.chess.utils.Fonts;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXText;

public class SpinNumber
extends GUIComponent {
    private GDXButton spinLeft = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/interface/spinLeft", true, false, true);
    private GDXButton spinRight = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/interface/spinRight", true, false, true);
    private GDXText txtLabel;
    private GDXText txtNumber;
    private GameParamaterInt paramaterInt;
    private int min;
    private int max;

    public SpinNumber(String label, GameParamaterInt paramaterInt) {
        this.txtLabel = new GDXText(Fonts.TEXT_MENU, label);
        this.txtNumber = new GDXText(Fonts.TEXT_MENU_NUMBER, "" + paramaterInt.value);
        this.paramaterInt = paramaterInt;
        this.min = 1;
        this.max = 99;
    }

    public SpinNumber setMinMax(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public void setValue(int value) {
        if (value >= this.min && value <= this.max) {
            this.paramaterInt.value = value;
            this.txtNumber.setText("" + this.paramaterInt.value);
        }
    }

    public void setValue(GameParamaterInt paramaterInt) {
        if (paramaterInt.value >= this.min && paramaterInt.value <= this.max) {
            this.paramaterInt = paramaterInt;
            this.txtNumber.setText("" + paramaterInt.value);
        }
    }

    public void onSpinLeft() {
        this.setValue(this.paramaterInt.value - 1);
    }

    public void onSpinRight() {
        this.setValue(this.paramaterInt.value + 1);
    }

    @Override
    public boolean isClicked(int x, int y) {
        if (this.isEnabled) {
            if (this.spinLeft.isClicked(x, y)) {
                this.onSpinLeft();
                return true;
            }
            if (this.spinRight.isClicked(x, y)) {
                this.onSpinRight();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.spinLeft.setEnabled(isEnabled);
        this.spinRight.setEnabled(isEnabled);
    }

    @Override
    public void setPosition(float x, float y) {
        this.txtLabel.setPosition(x - 600.0f, y);
        this.spinLeft.setPosition(x - 80.0f, y - 15.0f);
        this.txtNumber.setPosition(x, y);
        this.spinRight.setPosition(x + 40.0f, y - 15.0f);
    }

    @Override
    public void draw() {
        this.txtLabel.draw();
        this.spinLeft.draw();
        this.txtNumber.draw();
        this.spinRight.draw();
    }
}

