/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.pions;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.Cell;
import com.takyon.chess.game.ChessGame;
import com.takyon.chess.game.Coup;
import com.takyon.chess.game.Grid;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.game.exceptions.CaseOccupeException;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.pions.PionFactory;
import com.takyon.chess.utils.BattleGraphics;
import com.takyon.chess.utils.Positions;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public abstract class Pion
extends DrawableObject
implements Comparable {
    public int i;
    public int j;
    public transient Grid grid;
    public transient Player player;
    public Type type;
    public transient GDXImage image;
    private transient float alpha;
    public transient Array<Cell> cellsVoid;
    public transient Array<Cell> cellsTake;
    public transient Array<Cell> cellsJoker;
    public transient Array<Cell> cellsTakeJoker;

    public Pion(Type type) {
        this.type = type;
    }

    public Pion() {
        this.cellsVoid = new Array();
        this.cellsTake = new Array();
        this.cellsJoker = new Array();
        this.cellsTakeJoker = new Array();
    }

    public Pion(Player player, Type type) {
        this();
        this.type = type;
        this.player = player;
        this.setImage();
    }

    public int getI() {
        return this.i;
    }

    public void setI(int i) {
        this.i = i;
    }

    public int getJ() {
        return this.j;
    }

    public void setJ(int j) {
        this.j = j;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setCoords(int i, int j) {
        this.i = i;
        this.j = j;
        BattleGraphics.setGridPosition(this, i, j);
    }

    public void setImage() {
        if (this.player.color == PlayerColor.WHITE) {
            this.image = PionFactory.imagesPionsBlue[this.type.ordinal()];
        } else if (this.player.color == PlayerColor.BLACK) {
            this.image = PionFactory.imagesPionsRed[this.type.ordinal()];
        }
        this.alpha = 1.0f;
    }

    @Override
    public Position getPositionScale() {
        this.positionScaled.x = this.getPosition().x * Scene2D.RATIO;
        this.positionScaled.y = ((float)Scene2D.SCREEN_HEIGHT_BASE - this.getPosition().y - this.image.getHeight() * Graphics.ratio) * Scene2D.RATIO;
        return this.positionScaled;
    }

    protected void clearCells() {
        this.cellsVoid.clear();
        this.cellsTake.clear();
        this.cellsJoker.clear();
        this.cellsTakeJoker.clear();
    }

    protected Array<Cell> getAvailableCellsDirections() {
        if (this.player.directions == Player.Directions.DIAGONALES) {
            return this.getAvailableCellsDiagonale(this.i, this.j);
        }
        if (this.player.directions == Player.Directions.LIGNES_COLONNES) {
            return this.getAvailableCellsLignesColonnes(this.i, this.j);
        }
        return null;
    }

    protected boolean canAddCell(int i, int j) {
        Pion pion = this.grid.getPion(i, j);
        return pion == null || this.isEnnemy(pion);
    }

    public Array<Cell> getAvailableCellsDiagonale(int i, int j, int nbCases) {
        Array result = new Array();
        int di = i + 1;
        int dj = j + 1;
        while (di <= this.limit_i(i + nbCases) && dj <= this.limit_j(j + nbCases) && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            ++di;
            ++dj;
        }
        di = i - 1;
        dj = j + 1;
        while (di >= this.limit(i - nbCases) && dj <= this.limit_j(j + nbCases) && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            --di;
            ++dj;
        }
        di = i - 1;
        dj = j - 1;
        while (di >= this.limit(i - nbCases) && dj >= this.limit(j - nbCases) && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            --di;
            --dj;
        }
        di = i + 1;
        dj = j - 1;
        while (di <= this.limit_i(i + nbCases) && dj >= this.limit(j - nbCases) && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            ++di;
            --dj;
        }
        return result;
    }

    public Array<Cell> getAvailableCellsLignesColonnes(int i, int j, int nbCases) {
        Array result = new Array();
        int r = j + 1;
        while (r <= this.limit_j(j + nbCases)) {
            if (!this.canAddCell(i, r)) break;
            result.add((Object)Cell.get(i, r));
            if (this.isEnnemy(i, r)) break;
            ++r;
        }
        r = j - 1;
        while (r >= this.limit(j - nbCases)) {
            if (!this.canAddCell(i, r)) break;
            result.add((Object)Cell.get(i, r));
            if (this.isEnnemy(i, r)) break;
            --r;
        }
        int c = i + 1;
        while (c <= this.limit_i(i + nbCases)) {
            if (!this.canAddCell(c, j)) break;
            result.add((Object)Cell.get(c, j));
            if (this.isEnnemy(c, j)) break;
            ++c;
        }
        c = i - 1;
        while (c >= this.limit(i - nbCases)) {
            if (!this.canAddCell(c, j)) break;
            result.add((Object)Cell.get(c, j));
            if (this.isEnnemy(c, j)) break;
            --c;
        }
        return result;
    }

    private int limit(int c) {
        if (c < 0) {
            return 0;
        }
        return c;
    }

    private int limit_i(int ci) {
        if (ci >= this.grid.rows - 1) {
            return this.grid.rows - 1;
        }
        return ci;
    }

    private int limit_j(int cj) {
        if (cj >= this.grid.cols - 1) {
            return this.grid.cols - 1;
        }
        return cj;
    }

    public Array<Cell> getAvailableCellsDiagonale(int i, int j) {
        Array result = new Array();
        int di = i + 1;
        int dj = j + 1;
        while (di < this.grid.cols && dj < this.grid.rows && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            ++di;
            ++dj;
        }
        di = i - 1;
        dj = j + 1;
        while (di >= 0 && dj < this.grid.rows && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            --di;
            ++dj;
        }
        di = i - 1;
        dj = j - 1;
        while (di >= 0 && dj >= 0 && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            --di;
            --dj;
        }
        di = i + 1;
        dj = j - 1;
        while (di < this.grid.cols && dj >= 0 && this.canAddCell(di, dj)) {
            result.add((Object)Cell.get(di, dj));
            if (this.isEnnemy(di, dj)) break;
            ++di;
            --dj;
        }
        return result;
    }

    public Array<Cell> getAvailableCellsLignesColonnes(int i, int j) {
        Array result = new Array();
        int r = j + 1;
        while (r < this.grid.rows) {
            if (!this.canAddCell(i, r)) break;
            result.add((Object)Cell.get(i, r));
            if (this.isEnnemy(i, r)) break;
            ++r;
        }
        r = j - 1;
        while (r >= 0) {
            if (!this.canAddCell(i, r)) break;
            result.add((Object)Cell.get(i, r));
            if (this.isEnnemy(i, r)) break;
            --r;
        }
        int c = i + 1;
        while (c < this.grid.cols) {
            if (!this.canAddCell(c, j)) break;
            result.add((Object)Cell.get(c, j));
            if (this.isEnnemy(c, j)) break;
            ++c;
        }
        c = i - 1;
        while (c >= 0) {
            if (!this.canAddCell(c, j)) break;
            result.add((Object)Cell.get(c, j));
            if (this.isEnnemy(c, j)) break;
            --c;
        }
        return result;
    }

    public void addCell(Array<Cell> list, Cell cell) {
        this.addCell(cell, list);
    }

    public void addCell(Cell cell, Array<Cell> list) {
        if (cell != null && !list.contains((Object)cell, true)) {
            list.add((Object)cell);
        }
    }

    public abstract boolean canTake(Pion var1);

    public boolean canBeTakenBy(Pion pion) {
        return true;
    }

    public void setAvailableCellsSuper(Grid grid) {
        this.clearCells();
        this.setAvailableCells();
        for (Cell cell : this.getTotalCells()) {
            Pion pion = grid.getPion(cell.i, cell.j);
            if (pion == null || pion.player == this.player || !this.canTake(pion)) continue;
            this.cellsTake.add((Object)cell);
        }
    }

    public void setAvailableCellsSuper() {
        this.clearCells();
        this.setAvailableCells();
        Array<Cell> totalCells = this.getTotalCells();
        for (Cell cell : totalCells) {
            Pion pion = this.grid.getPion(cell.i, cell.j);
            if (pion == null) continue;
            if (pion.player != this.player) {
                boolean condition = false;
                if (ChessGame.isDebug) {
                    condition = true;
                } else {
                    boolean bl = condition = pion.player.nbCoupsJoues > 6;
                }
                if (condition && this.canTake(pion)) {
                    if (this.cellsJoker.contains((Object)cell, true)) {
                        this.cellsTakeJoker.add((Object)cell);
                    } else {
                        this.cellsTake.add((Object)cell);
                    }
                }
                this.cellsVoid.removeValue((Object)cell, true);
                this.cellsJoker.removeValue((Object)cell, true);
                continue;
            }
            if (pion == this) continue;
            this.cellsVoid.removeValue((Object)cell, true);
            this.cellsJoker.removeValue((Object)cell, true);
        }
    }

    public Array<Cell> getTotalCells() {
        Array totalCells = new Array();
        totalCells.addAll(this.cellsVoid);
        totalCells.addAll(this.cellsTake);
        totalCells.addAll(this.cellsJoker);
        totalCells.addAll(this.cellsTakeJoker);
        return totalCells;
    }

    public void setAvailableCells() {
    }

    public int distance(int di, int dj) {
        return Math.abs(this.i - di) + Math.abs(this.j - dj);
    }

    public boolean isAllie(Pion pion) {
        return pion != null && pion.player == this.player;
    }

    public boolean isAllie(int i, int j) {
        Pion pion = this.grid.getPion(i, j);
        return this.isAllie(pion);
    }

    public boolean isEnnemy(Pion pion) {
        return pion != null && pion.player != this.player;
    }

    public boolean isEnnemy(int i, int j) {
        Pion pion = this.grid.getPion(i, j);
        return this.isEnnemy(pion);
    }

    public boolean canMoveTo(int i, int j) {
        for (Cell cell : this.getTotalCells()) {
            if (cell.i != i || cell.j != j) continue;
            return true;
        }
        return false;
    }

    public void moveTo(int i, int j) throws CaseOccupeException {
        Pion destPion = this.grid.getPion(i, j);
        if (destPion != null && destPion.player == this.player) {
            throw new CaseOccupeException(new Coup(this, Cell.get(i, j)));
        }
        this.grid.setPion(this.i, this.j, null);
        if (this.grid.getPion(i, j) != null) {
            GameRules.onEat(this, this.grid.getPion(i, j));
        }
        this.grid.setPion(i, j, this);
        Cell cell = Cell.get(i, j);
        if (this.cellsJoker.contains((Object)cell, true)) {
            this.player.perdJoker(1);
        } else if (this.cellsTakeJoker.contains((Object)cell, true)) {
            this.player.perdJoker(1);
        }
        this.player.mustNotChangeTurn = false;
        ++this.player.nbCoupsJoues;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Pion) {
            Pion pion = (Pion)obj;
            return this.i == pion.i && this.j == pion.j && this.type == pion.type && this.player.equals(pion.player);
        }
        return false;
    }

    public abstract int getValue();

    public int compareTo(Object o) {
        Pion pion = (Pion)o;
        return this.getValue() - pion.getValue();
    }

    public boolean canMoveAndTake(Pion pion) {
        for (Cell cell : this.cellsTake) {
            if (cell.i != pion.i || cell.j != pion.j) continue;
            return true;
        }
        for (Cell cell : this.cellsTakeJoker) {
            if (cell.i != pion.i || cell.j != pion.j) continue;
            return true;
        }
        return false;
    }

    public void onEatenBy(Player opponent) {
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            Position position = this.getPositionScale();
            this.player.imageFond.draw(position.x, position.y, Positions.gridSize, Positions.gridSize);
            this.image.setAlpha(this.alpha);
            this.image.draw(position.x, position.y, Positions.gridSize, Positions.gridSize);
        }
    }

    public void drawDeplacement() {
        for (Cell cell : this.cellsVoid) {
            this.grid.drawCase(BattleGraphics.tex_green, cell.i, cell.j);
        }
        for (Cell cell : this.cellsTake) {
            this.grid.drawCase(BattleGraphics.tex_red, cell.i, cell.j);
        }
        for (Cell cell : this.cellsJoker) {
            this.grid.drawCase(BattleGraphics.tex_yellow, cell.i, cell.j);
        }
        for (Cell cell : this.cellsTakeJoker) {
            this.grid.drawCase(BattleGraphics.tex_orange, cell.i, cell.j);
        }
    }

    public String toString() {
        return (Object)((Object)this.type) + " : <" + this.i + ", " + this.j + ">";
    }

    public static enum Type {
        OEUF,
        ROI,
        FEU,
        EAU,
        AIR;

    }
}

