/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.screens;

import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.ChessGame;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.gui.Checkbox;
import com.takyon.chess.gui.GUIComponent;
import com.takyon.chess.gui.SpinNumber;
import com.takyon.chess.screens.ChessGameScreen;
import com.takyon.chess.screens.ScreenGame;
import com.takyon.chess.screens.ScreenIntro;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXToggleButton;
import com.takyon.gamelib.Language;

public class ScreenOptions
extends ChessGameScreen {
    private Onglet ongletActif;
    private GDXToggleButton btnSound;
    private GDXButton btnSave;
    private GDXButton btnValider;
    private GDXImage imageFondOptionsRed;
    private GDXImage imageFondOptionsBlue;
    private GDXButton btnOngletGeneral;
    private GDXButton btnOngletGamePlay;
    private GDXButton btnOngletGamePlayMoves;
    private GDXButton btnOngletGamePlayJokers;
    private GDXButton btnOngletGamePlayVictoire;
    private OngletOptionsPlayer ongletGeneral;
    private OngletOptionsPlayer ongletGamePlayBlue;
    private OngletOptionsPlayer ongletGamePlayRed;
    private OngletOptionsPlayer ongletGamePlayMovesBlue;
    private OngletOptionsPlayer ongletGamePlayMovesRed;
    private OngletOptionsPlayer ongletJokersBlue;
    private OngletOptionsPlayer ongletJokersRed;
    private OngletOptionsPlayer ongletVictoireBlue;
    private OngletOptionsPlayer ongletVictoireRed;
    protected Array<OngletOptionsPlayer> onglets;
    public static boolean isIngame = false;
    private GDXButton btnRetour;
    private boolean isSaveOptionsConfirm;

    @Override
    public void firstInit() {
        super.firstInit();
        this.onglets = new Array();
        this.btnOngletGeneral = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/onglet_general", true, false, false);
        this.btnOngletGeneral.setPosition(250.0f, 0.0f);
        this.btnOngletGamePlay = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/onglet_jeu", true, false, false);
        this.btnOngletGamePlay.setPosition(550.0f, 0.0f);
        this.btnOngletGamePlayMoves = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/onglet_moves", true, false, false);
        this.btnOngletGamePlayMoves.setPosition(850.0f, 0.0f);
        this.btnOngletGamePlayJokers = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/onglet_jokers", true, false, false);
        this.btnOngletGamePlayJokers.setPosition(1150.0f, 0.0f);
        this.btnOngletGamePlayVictoire = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/onglet_victoire", true, false, false);
        this.btnOngletGamePlayVictoire.setPosition(1450.0f, 0.0f);
        this.imageFondOptionsBlue = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/options_white.png");
        this.imageFondOptionsBlue.setPosition(10.0f, 150.0f);
        this.imageFondOptionsRed = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/options_black.png");
        this.imageFondOptionsRed.setPosition(1000.0f, 150.0f);
        this.btnSound = new GDXToggleButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/sound", true, true, false);
        this.btnSound.setPosition(100.0f, 900.0f);
        this.btnSave = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/enregistrer", true, false, false);
        this.btnSave.setPosition(500.0f, 950.0f);
        this.btnValider = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/valider", true, false, false);
        this.btnValider.setPosition(1000.0f, 950.0f);
        this.ongletGeneral = new OngletOptionsPlayer(650);
        this.ongletGamePlayBlue = new OngletOptionsPlayer(650);
        this.ongletGamePlayRed = new OngletOptionsPlayer(1650);
        this.ongletGamePlayMovesBlue = new OngletOptionsPlayer(650);
        this.ongletGamePlayMovesRed = new OngletOptionsPlayer(1650);
        this.ongletJokersBlue = new OngletOptionsPlayer(650);
        this.ongletJokersRed = new OngletOptionsPlayer(1650);
        this.ongletVictoireBlue = new OngletOptionsPlayer(650);
        this.ongletVictoireRed = new OngletOptionsPlayer(1650);
        this.ongletGamePlayBlue.add(new SpinNumber(Language.tr("nb_oeufs_remplis_max"), GameRules.optionsBlue.nbOeufsRemplisMax));
        this.ongletGamePlayRed.add(new SpinNumber(Language.tr("nb_oeufs_remplis_max"), GameRules.optionsRed.nbOeufsRemplisMax));
        this.ongletGamePlayBlue.add(new Checkbox(Language.tr("jouer_apres_eclosion"), GameRules.optionsBlue.canPlayAfterEclosion));
        this.ongletGamePlayRed.add(new Checkbox(Language.tr("jouer_apres_eclosion"), GameRules.optionsRed.canPlayAfterEclosion));
        this.ongletGamePlayBlue.add(new Checkbox(Language.tr("change_boussole"), GameRules.optionsBlue.canChangeBoussole));
        this.ongletGamePlayRed.add(new Checkbox(Language.tr("change_boussole"), GameRules.optionsRed.canChangeBoussole));
        this.ongletGamePlayBlue.add(new Checkbox(Language.tr("change_boussole_opponent"), GameRules.optionsBlue.canChangeBoussoleOpponent));
        this.ongletGamePlayRed.add(new Checkbox(Language.tr("change_boussole_opponent"), GameRules.optionsRed.canChangeBoussoleOpponent));
        this.ongletGamePlayMovesBlue.add(new Checkbox(Language.tr("cavalerie_passe_cavalerie"), GameRules.optionsBlue.canCavaleriePassCavalerie));
        this.ongletGamePlayMovesRed.add(new Checkbox(Language.tr("cavalerie_passe_cavalerie"), GameRules.optionsRed.canCavaleriePassCavalerie));
        this.ongletGamePlayMovesBlue.add(new Checkbox(Language.tr("cavalerie_passe_deux_pions"), GameRules.optionsBlue.canCavaleriePassTwoPions));
        this.ongletGamePlayMovesRed.add(new Checkbox(Language.tr("cavalerie_passe_deux_pions"), GameRules.optionsRed.canCavaleriePassTwoPions));
        this.ongletGamePlayMovesBlue.add(new Checkbox(Language.tr("artillerie_prend_tout"), GameRules.optionsBlue.isArtillleriePrendTout));
        this.ongletGamePlayMovesRed.add(new Checkbox(Language.tr("artillerie_prend_tout"), GameRules.optionsRed.isArtillleriePrendTout));
        this.ongletGamePlayMovesBlue.add(new Checkbox(Language.tr("infanterie_realiste"), GameRules.optionsBlue.isInfanterieRealiste));
        this.ongletGamePlayMovesRed.add(new Checkbox(Language.tr("infanterie_realiste"), GameRules.optionsRed.isInfanterieRealiste));
        this.ongletGamePlayMovesBlue.add(new SpinNumber(Language.tr("move_artillerie"), GameRules.optionsBlue.moveArtillerie).setMinMax(1, 3));
        this.ongletGamePlayMovesRed.add(new SpinNumber(Language.tr("move_artillerie"), GameRules.optionsRed.moveArtillerie).setMinMax(1, 3));
        this.ongletJokersBlue.add(new SpinNumber(Language.tr("nb_jokers_eclosion"), GameRules.optionsBlue.nbJokersEclosion));
        this.ongletJokersRed.add(new SpinNumber(Language.tr("nb_jokers_eclosion"), GameRules.optionsRed.nbJokersEclosion));
        this.ongletJokersBlue.add(new SpinNumber(Language.tr("nb_jokers_boussole"), GameRules.optionsBlue.nbJokersBoussole));
        this.ongletJokersRed.add(new SpinNumber(Language.tr("nb_jokers_boussole"), GameRules.optionsRed.nbJokersBoussole));
        this.ongletJokersBlue.add(new SpinNumber(Language.tr("nb_jokers_max"), GameRules.optionsBlue.nbJokersMax).setMinMax(1, 12));
        this.ongletJokersRed.add(new SpinNumber(Language.tr("nb_jokers_max"), GameRules.optionsRed.nbJokersMax).setMinMax(1, 12));
        this.ongletJokersBlue.add(new Checkbox(Language.tr("prise_joker"), GameRules.optionsBlue.isGainPerteJoker));
        this.ongletJokersRed.add(new Checkbox(Language.tr("prise_joker"), GameRules.optionsRed.isGainPerteJoker));
        this.ongletJokersBlue.add(new SpinNumber(Language.tr("nb_gain_perte_joker"), GameRules.optionsBlue.nbGainPerteJoker));
        this.ongletJokersRed.add(new SpinNumber(Language.tr("nb_gain_perte_joker"), GameRules.optionsRed.nbGainPerteJoker));
        this.ongletVictoireBlue.add(new SpinNumber(Language.tr("nb_rois_a_prendre"), GameRules.optionsBlue.nbRoisAPrendre));
        this.ongletVictoireRed.add(new SpinNumber(Language.tr("nb_rois_a_prendre"), GameRules.optionsRed.nbRoisAPrendre));
        this.ongletVictoireBlue.add(new SpinNumber(Language.tr("nb_pions_a_prendre"), GameRules.optionsBlue.nbPionsAPrendre));
        this.ongletVictoireRed.add(new SpinNumber(Language.tr("nb_pions_a_prendre"), GameRules.optionsRed.nbPionsAPrendre));
        this.ongletVictoireBlue.add(new SpinNumber(Language.tr("nb_oeufs_a_amener_bord"), GameRules.optionsBlue.nbOeufsAamenerAuBord));
        this.ongletVictoireRed.add(new SpinNumber(Language.tr("nb_oeufs_a_amener_bord"), GameRules.optionsRed.nbOeufsAamenerAuBord));
        this.onglets.add((Object)this.ongletGeneral);
        this.onglets.add((Object)this.ongletGamePlayBlue);
        this.onglets.add((Object)this.ongletGamePlayRed);
        this.onglets.add((Object)this.ongletGamePlayMovesBlue);
        this.onglets.add((Object)this.ongletGamePlayMovesRed);
        this.onglets.add((Object)this.ongletJokersBlue);
        this.onglets.add((Object)this.ongletJokersRed);
        this.onglets.add((Object)this.ongletVictoireBlue);
        this.onglets.add((Object)this.ongletVictoireRed);
        for (OngletOptionsPlayer onglet : this.onglets) {
            onglet.init();
        }
        this.btnRetour = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/retour", true, false, false);
        this.btnRetour.setPosition(1000.0f, 900.0f);
    }

    @Override
    public void init() {
        this.ongletActif = Onglet.ONGLET_GENERAL;
        this.btnSound.isToggled = false;
        this.btnSound.release();
        if (isIngame) {
            for (OngletOptionsPlayer onglet : this.onglets) {
                onglet.setEnabled(false);
            }
        } else {
            for (OngletOptionsPlayer onglet : this.onglets) {
                onglet.setEnabled(true);
            }
        }
    }

    @Override
    public void finish() {
    }

    @Override
    public void keyTyped(char character) {
        ScreenGame.textInput.addChar(character);
    }

    @Override
    public void keyUp(int keycode) {
        if (keycode == 67) {
            textInput.removeChar();
        }
    }

    @Override
    public void onTouched(int x, int y) {
        if (isMessageAlert) {
            if (btnYes.isClicked(x, y)) {
                this.isSaveOptionsConfirm = true;
                textMessage.setText(Language.tr("saisir_un_nom"));
                isMessageAlert = false;
            } else if (btnNo.isClicked(x, y)) {
                isMessageAlert = false;
            }
        } else if (this.isSaveOptionsConfirm) {
            if (btnYes.isClicked(x, y)) {
                ChessGame.saveOptions(ScreenOptions.textMessage.text);
                this.isSaveOptionsConfirm = false;
            } else if (btnNo.isClicked(x, y)) {
                this.isSaveOptionsConfirm = false;
            }
        } else {
            if (this.btnOngletGeneral.isClicked(x, y)) {
                this.ongletActif = Onglet.ONGLET_GENERAL;
            } else if (this.btnOngletGamePlay.isClicked(x, y)) {
                this.ongletActif = Onglet.ONGLET_GAMEPLAY;
            } else if (this.btnOngletGamePlayMoves.isClicked(x, y)) {
                this.ongletActif = Onglet.ONGLET_GAMEPLAY_MOVES;
            } else if (this.btnOngletGamePlayJokers.isClicked(x, y)) {
                this.ongletActif = Onglet.ONGLET_GAMEPLAY_JOKERS;
            } else if (this.btnOngletGamePlayVictoire.isClicked(x, y)) {
                this.ongletActif = Onglet.ONGLET_GAMEPLAY_VICTOIRE;
            }
            if (isIngame) {
                if (this.btnRetour.isClicked(x, y)) {
                    currentScreen = screenGame;
                }
            } else if (!this.btnSound.isClicked(x, y)) {
                if (this.btnSave.isClicked(x, y)) {
                    isMessageAlert = true;
                    textMessage.setText(Language.tr("message_sauvegarde_options"));
                } else if (this.btnValider.isClicked(x, y)) {
                    ScreenOptions.changeScreen(screenIntro);
                }
            }
            if (this.ongletActif == Onglet.ONGLET_GENERAL) {
                this.ongletGeneral.checkClick(x, y);
            } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY) {
                this.ongletGamePlayBlue.checkClick(x, y);
                this.ongletGamePlayRed.checkClick(x, y);
            } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY_MOVES) {
                this.ongletGamePlayMovesBlue.checkClick(x, y);
                this.ongletGamePlayMovesRed.checkClick(x, y);
            } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY_JOKERS) {
                this.ongletJokersBlue.checkClick(x, y);
                this.ongletJokersRed.checkClick(x, y);
            } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY_VICTOIRE) {
                this.ongletVictoireBlue.checkClick(x, y);
                this.ongletVictoireRed.checkClick(x, y);
            }
        }
    }

    public void drawOptions() {
        ScreenIntro.imgBackground.draw();
        this.btnOngletGeneral.draw();
        this.btnOngletGamePlay.draw();
        this.btnOngletGamePlayMoves.draw();
        this.btnOngletGamePlayJokers.draw();
        this.btnOngletGamePlayVictoire.draw();
        if (this.ongletActif == Onglet.ONGLET_GENERAL) {
            this.imageFondOptionsBlue.draw();
            this.ongletGeneral.draw();
        } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY) {
            this.imageFondOptionsBlue.draw();
            this.imageFondOptionsRed.draw();
            this.ongletGamePlayBlue.draw();
            this.ongletGamePlayRed.draw();
        } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY_MOVES) {
            this.imageFondOptionsBlue.draw();
            this.imageFondOptionsRed.draw();
            this.ongletGamePlayMovesBlue.draw();
            this.ongletGamePlayMovesRed.draw();
        } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY_JOKERS) {
            this.imageFondOptionsBlue.draw();
            this.imageFondOptionsRed.draw();
            this.ongletJokersBlue.draw();
            this.ongletJokersRed.draw();
        } else if (this.ongletActif == Onglet.ONGLET_GAMEPLAY_VICTOIRE) {
            this.imageFondOptionsBlue.draw();
            this.imageFondOptionsRed.draw();
            this.ongletVictoireBlue.draw();
            this.ongletVictoireRed.draw();
        }
    }

    @Override
    public void display() {
        super.display();
        this.drawOptions();
        if (isMessageAlert) {
            imageDialogConfirm.draw();
            btnYes.draw();
            btnNo.draw();
            textMessage.draw();
        } else if (this.isSaveOptionsConfirm) {
            imageDialogConfirm.draw();
            btnOk.draw();
            btnCancel.draw();
            textMessage.draw();
            textInput.draw();
        }
        if (isIngame) {
            this.btnRetour.draw();
        } else {
            this.btnSave.draw();
            this.btnSound.draw();
            this.btnValider.draw();
        }
    }

    private static enum Onglet {
        ONGLET_GENERAL,
        ONGLET_GAMEPLAY,
        ONGLET_GAMEPLAY_MOVES,
        ONGLET_GAMEPLAY_JOKERS,
        ONGLET_GAMEPLAY_VICTOIRE;

    }

    class OngletOptionsPlayer {
        private Array<GUIComponent> options;
        private int posX;

        public OngletOptionsPlayer(int x) {
            this.posX = x;
            this.options = new Array();
        }

        public void add(GUIComponent component) {
            this.options.add((Object)component);
        }

        public void init() {
            int j = 0;
            while (j < this.options.size) {
                GUIComponent component = (GUIComponent)this.options.get(j);
                component.setPosition(this.posX, 200 + j * 100);
                ++j;
            }
        }

        public void checkClick(int x, int y) {
            int j = 0;
            while (j < this.options.size) {
                GUIComponent component = (GUIComponent)this.options.get(j);
                component.isClicked(x, y);
                ++j;
            }
        }

        public void setEnabled(boolean enabled) {
            int j = 0;
            while (j < this.options.size) {
                GUIComponent component = (GUIComponent)this.options.get(j);
                component.setEnabled(enabled);
                ++j;
            }
        }

        public void draw() {
            int j = 0;
            while (j < this.options.size) {
                GUIComponent component = (GUIComponent)this.options.get(j);
                component.draw();
                ++j;
            }
        }
    }
}

