/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.dmqhbattle;

import com.takyon.dmqhbattle.GridDmqh;
import com.takyon.dmqhbattle.dalles.DalleBattle;
import com.takyon.dmqhbattle.dalles.GridObject;

public class GridBattleDmqh
extends GridDmqh {
    public GridBattleDmqh(int cols, int rows) {
        super(cols, rows);
    }

    @Override
    public void init() {
        int i = 0;
        while (i < this.cols * this.rows) {
            this.casesPossibles.add(i);
            ++i;
        }
        this.update();
    }

    @Override
    public void move(GridObject dalle, int i1, int j1, int i2, int j2) {
        if (i1 == i2 && j1 == j2) {
            return;
        }
        if (this.values[i1][j1].isObstacle()) {
            return;
        }
        if (dalle != null) {
            dalle.move(i1, j1, i2, j2);
            this.hasMoved = true;
        }
        int value1 = this.getValue(i1, j1);
        int value2 = this.getValue(i2, j2);
        this.setValue(i1, j1, 0);
        if (value1 == value2) {
            this.values[i2][j2].player.color = DalleBattle.getDominantPlayer(i1, j1, i2, j2, this);
            this.values[i1][j1].player.color = null;
            this.setValue(i2, j2, value1 * 2);
            if (value1 * 2 > this.highestValue) {
                this.highestValue = value1 * 2;
                this.setStep();
                this.hasSteped = true;
            }
            this.i_fusion = i2;
            this.j_fusion = j2;
            this.hasFusion = true;
        } else {
            this.values[i2][j2].player.color = this.values[i1][j1].player.color;
            this.values[i1][j1].player.color = null;
            this.setValue(i2, j2, value1);
        }
    }

    @Override
    public void moveLeft() {
        int j = 0;
        while (j < this.rows) {
            int i = 1;
            while (i < this.cols) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int c = i;
                    while (c >= 0 && this.getValue(c - 1, j) == 0) {
                        --c;
                    }
                    if (c == -1) {
                        this.move(dalle, i, j, 0, j);
                    } else if (this.getValue(c - 1, j) > 0) {
                        if (this.getValue(c - 1, j) == value) {
                            if (!this.isFusion(c - 1, j)) {
                                this.move(dalle, i, j, c - 1, j);
                            } else {
                                this.move(dalle, i, j, c, j);
                            }
                        } else if (c < i) {
                            this.move(dalle, i, j, c, j);
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        this.direction = GridDmqh.Direction.LEFT;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }

    @Override
    public void moveRight() {
        int j = 0;
        while (j < this.rows) {
            int i = this.cols - 2;
            while (i >= 0) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int c = i;
                    while (c < this.cols && this.getValue(c + 1, j) == 0) {
                        ++c;
                    }
                    if (c == this.cols) {
                        this.move(dalle, i, j, this.cols - 1, j);
                    } else if (this.getValue(c + 1, j) > 0) {
                        if (this.getValue(c + 1, j) == value) {
                            if (!this.isFusion(c + 1, j)) {
                                this.move(dalle, i, j, c + 1, j);
                            } else {
                                this.move(dalle, i, j, c, j);
                            }
                        } else if (c > i) {
                            this.move(dalle, i, j, c, j);
                        }
                    }
                }
                --i;
            }
            ++j;
        }
        this.direction = GridDmqh.Direction.RIGHT;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }

    @Override
    public void moveUp() {
        int i = 0;
        while (i < this.cols) {
            int j = 1;
            while (j < this.rows) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int r = j;
                    while (r >= 0 && this.getValue(i, r - 1) == 0) {
                        --r;
                    }
                    if (r == -1) {
                        this.move(dalle, i, j, i, 0);
                    } else if (this.getValue(i, r - 1) > 0) {
                        if (this.getValue(i, r - 1) == value) {
                            if (!this.isFusion(i, r - 1)) {
                                this.move(dalle, i, j, i, r - 1);
                            } else {
                                this.move(dalle, i, j, i, r);
                            }
                        } else if (r < j) {
                            this.move(dalle, i, j, i, r);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.direction = GridDmqh.Direction.UP;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }

    @Override
    public void moveDown() {
        int i = 0;
        while (i < this.cols) {
            int j = this.rows - 2;
            while (j >= 0) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int r = j;
                    while (r < this.rows && this.getValue(i, r + 1) == 0) {
                        ++r;
                    }
                    if (r == this.rows) {
                        this.move(dalle, i, j, i, this.rows - 1);
                    } else if (this.getValue(i, r + 1) > 0) {
                        if (this.getValue(i, r + 1) == value) {
                            if (!this.isFusion(i, r + 1)) {
                                this.move(dalle, i, j, i, r + 1);
                            } else {
                                this.move(dalle, i, j, i, r);
                            }
                        } else if (r > j) {
                            this.move(dalle, i, j, i, r);
                        }
                    }
                }
                --j;
            }
            ++i;
        }
        this.direction = GridDmqh.Direction.DOWN;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }
}

