/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.dmqhbattle;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.takyon.chess.utils.Positions;
import com.takyon.dmqhbattle.dalles.Dalle;
import com.takyon.dmqhbattle.dalles.DalleFactory;
import com.takyon.dmqhbattle.dalles.GridObject;
import com.takyon.dmqhbattle.dalles.GridValue;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.MathUtils;
import com.takyon.gamelib.Scene2D;
import java.util.ArrayList;

public class GridDmqh {
    public float ratio = 1.0f;
    public GridValue[][] values;
    public GridObject[][] objectsToDraw;
    public int rows;
    public int cols;
    public ArrayList<Integer> casesPossibles = new ArrayList();
    public boolean hasMoved = false;
    public boolean hasFusion = false;
    public boolean hasSteped = false;
    public boolean has2048 = false;
    public int sizePlusGap = 0;
    public int positionX = 0;
    public int positionY = 0;
    protected Texture dalleFond;
    public Direction direction;
    protected int i_fusion = -1;
    protected int j_fusion = -1;
    public int highestValue = 0;

    public GridDmqh(int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        this.values = new GridValue[cols][rows];
        this.objectsToDraw = new GridObject[cols][rows];
        this.dalleFond = new Texture(Gdx.files.internal("kit/game/grille/dalle.png"));
        int i = 0;
        while (i < cols) {
            int j = 0;
            while (j < rows) {
                this.values[i][j] = new GridValue();
                ++j;
            }
            ++i;
        }
    }

    public void init() {
        int i = 0;
        while (i < this.cols * this.rows) {
            this.casesPossibles.add(i);
            ++i;
        }
        this.pop();
        this.pop();
        this.update();
    }

    public void pop(int i, int j, int value) {
        Dalle dalle = DalleFactory.create(this, i, j, value);
        dalle.pop();
        if (value > this.highestValue) {
            this.highestValue = value;
            this.setStep();
        }
    }

    public void pop(int number) {
        if (this.casesPossibles.size() > 0) {
            int randIndex = MathUtils.randomInt(0, this.casesPossibles.size() - 1);
            int rand = this.casesPossibles.get(randIndex);
            this.casesPossibles.remove(randIndex);
            this.pop(rand % this.cols, rand / this.rows, number);
        }
    }

    public void pop() {
        if (this.casesPossibles.size() > 0) {
            int randIndex = MathUtils.randomInt(0, this.casesPossibles.size() - 1);
            int rand = this.casesPossibles.get(randIndex);
            this.casesPossibles.remove(randIndex);
            int randNumber = MathUtils.randomInt(0, 100);
            if (randNumber > 50) {
                this.pop(rand % this.cols, rand / this.rows, 2);
            } else {
                this.pop(rand % this.cols, rand / this.rows, 4);
            }
        }
    }

    public int getValue(int i, int j) {
        if (i < 0 || i > this.cols - 1 || j < 0 || j > this.rows - 1) {
            return 0;
        }
        return this.values[i][j].getValue();
    }

    public void setValue(int i, int j, int value) {
        if (i < 0 || i > this.cols - 1 || j < 0 || j > this.rows - 1) {
            return;
        }
        this.values[i][j].setValue(value);
    }

    public GridObject getDalle(int i, int j) {
        if (i < 0 || i > this.cols - 1 || j < 0 || j > this.rows - 1) {
            return null;
        }
        return this.objectsToDraw[i][j];
    }

    public void setDalle(int i, int j, GridObject dalle) {
        if (i < 0 || i > this.cols - 1 || j < 0 || j > this.rows - 1) {
            return;
        }
        this.objectsToDraw[i][j] = dalle;
    }

    public void move(GridObject dalle, int i1, int j1, int i2, int j2) {
        if (dalle != null) {
            dalle.move(i1, j1, i2, j2);
            this.hasMoved = true;
        }
        int value1 = this.getValue(i1, j1);
        int value2 = this.getValue(i2, j2);
        this.setValue(i1, j1, 0);
        if (value1 == value2) {
            this.setValue(i2, j2, value1 * 2);
            if (value1 * 2 > this.highestValue) {
                this.highestValue = value1 * 2;
                this.setStep();
                this.hasSteped = true;
            }
            this.i_fusion = i2;
            this.j_fusion = j2;
            this.hasFusion = true;
            this.onFusion();
        } else {
            this.setValue(i2, j2, value1);
        }
    }

    public void onFusion() {
    }

    public void setStep() {
    }

    public void moveLeft() {
        int j = 0;
        while (j < this.rows) {
            int i = 1;
            while (i < this.cols) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int c = i;
                    while (c >= 0 && this.getValue(c - 1, j) == 0) {
                        --c;
                    }
                    if (c == -1) {
                        this.move(dalle, i, j, 0, j);
                    } else if (this.getValue(c - 1, j) > 0) {
                        if (this.getValue(c - 1, j) == value) {
                            if (!this.isFusion(c - 1, j)) {
                                this.move(dalle, i, j, c - 1, j);
                            } else {
                                this.move(dalle, i, j, c, j);
                            }
                        } else if (c < i) {
                            this.move(dalle, i, j, c, j);
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        this.direction = Direction.LEFT;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }

    public void moveRight() {
        int j = 0;
        while (j < this.rows) {
            int i = this.cols - 2;
            while (i >= 0) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int c = i;
                    while (c < this.cols && this.getValue(c + 1, j) == 0) {
                        ++c;
                    }
                    if (c == this.cols) {
                        this.move(dalle, i, j, this.cols - 1, j);
                    } else if (this.getValue(c + 1, j) > 0) {
                        if (this.getValue(c + 1, j) == value) {
                            if (!this.isFusion(c + 1, j)) {
                                this.move(dalle, i, j, c + 1, j);
                            } else {
                                this.move(dalle, i, j, c, j);
                            }
                        } else if (c > i) {
                            this.move(dalle, i, j, c, j);
                        }
                    }
                }
                --i;
            }
            ++j;
        }
        this.direction = Direction.RIGHT;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }

    protected boolean isFusion(int i, int j) {
        return this.i_fusion != -1 && this.j_fusion != -1 && i == this.i_fusion && j == this.j_fusion;
    }

    public void moveUp() {
        int i = 0;
        while (i < this.cols) {
            int j = 1;
            while (j < this.rows) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int r = j;
                    while (r >= 0 && this.getValue(i, r - 1) == 0) {
                        --r;
                    }
                    if (r == -1) {
                        this.move(dalle, i, j, i, 0);
                    } else if (this.getValue(i, r - 1) > 0) {
                        if (this.getValue(i, r - 1) == value) {
                            if (!this.isFusion(i, r - 1)) {
                                this.move(dalle, i, j, i, r - 1);
                            } else {
                                this.move(dalle, i, j, i, r);
                            }
                        } else if (r < j) {
                            this.move(dalle, i, j, i, r);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        this.direction = Direction.UP;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }

    public void moveDown() {
        int i = 0;
        while (i < this.cols) {
            int j = this.rows - 2;
            while (j >= 0) {
                int value = this.getValue(i, j);
                if (value > 0) {
                    GridObject dalle = this.getDalle(i, j);
                    int r = j;
                    while (r < this.rows && this.getValue(i, r + 1) == 0) {
                        ++r;
                    }
                    if (r == this.rows) {
                        this.move(dalle, i, j, i, this.rows - 1);
                    } else if (this.getValue(i, r + 1) > 0) {
                        if (this.getValue(i, r + 1) == value) {
                            if (!this.isFusion(i, r + 1)) {
                                this.move(dalle, i, j, i, r + 1);
                            } else {
                                this.move(dalle, i, j, i, r);
                            }
                        } else if (r > j) {
                            this.move(dalle, i, j, i, r);
                        }
                    }
                }
                --j;
            }
            ++i;
        }
        this.direction = Direction.DOWN;
        this.i_fusion = -1;
        this.j_fusion = -1;
    }

    public void logic(float dt) {
        int j = 0;
        while (j < this.rows) {
            int i = 0;
            while (i < this.cols) {
                GridObject dalle = this.getDalle(i, j);
                if (dalle != null) {
                    dalle.logic(dt);
                }
                ++i;
            }
            ++j;
        }
    }

    public void print() {
        int j = 0;
        while (j < this.rows) {
            int i = 0;
            while (i < this.cols) {
                System.out.print(String.valueOf(this.getValue(i, j)) + ",");
                ++i;
            }
            System.out.println();
            ++j;
        }
        System.out.println("------------------");
    }

    public void updateAfterMove() {
        if (this.hasMoved) {
            this.update();
        }
    }

    public void update() {
        this.casesPossibles.clear();
        int i = 0;
        while (i < this.cols) {
            int j = 0;
            while (j < this.rows) {
                if (this.getValue(i, j) == 0) {
                    this.casesPossibles.add(j * this.cols + i);
                }
                ++j;
            }
            ++i;
        }
        this.hasMoved = false;
    }

    public void draw() {
        int j;
        int i = 0;
        while (i < this.cols) {
            j = 0;
            while (j < this.rows) {
                GDXImage.draw(this.dalleFond, ((float)this.positionX + Positions.gridSizePlusGap * (float)i) * this.ratio * Scene2D.RATIO, ((float)Scene2D.SCREEN_HEIGHT_BASE - ((float)(j + 1) * Positions.gridSizePlusGap + (float)this.positionY) * this.ratio) * Scene2D.RATIO, Positions.gridSizePlusGap * this.ratio * Scene2D.RATIO, Positions.gridSizePlusGap * this.ratio * Scene2D.RATIO);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.cols) {
            j = 0;
            while (j < this.rows) {
                GridObject gridObject = this.objectsToDraw[i][j];
                if (gridObject != null) {
                    gridObject.draw();
                }
                ++j;
            }
            ++i;
        }
    }

    public void reset() {
        this.highestValue = 0;
        this.hasMoved = false;
        this.hasFusion = false;
        this.hasSteped = false;
        this.has2048 = false;
        this.i_fusion = -1;
        this.j_fusion = -1;
        int i = 0;
        while (i < this.cols) {
            int j = 0;
            while (j < this.rows) {
                this.values[i][j].setValue(0);
                ++j;
            }
            ++i;
        }
    }

    public void onStep() {
    }

    public boolean isClickInGrid(int x, int y) {
        return (float)x >= (float)this.positionX * this.ratio && (float)x <= (float)this.positionX * this.ratio + (float)(this.sizePlusGap * this.cols) && (float)y >= (float)this.positionY * this.ratio && (float)y <= (float)this.positionY * this.ratio + (float)(this.sizePlusGap * this.rows);
    }

    public void onTouched(int i, int j) {
    }

    public int getclickI(int x, int y) {
        return (int)(((float)x - (float)this.positionX * this.ratio) / (float)this.sizePlusGap);
    }

    public int getclickJ(int x, int y) {
        return (int)(((float)y - (float)this.positionY * this.ratio) / (float)this.sizePlusGap);
    }

    public static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

