/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.dmqhbattle.dalles;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.PlayerColor;
import com.takyon.dmqhbattle.GridDmqh;
import com.takyon.dmqhbattle.dalles.Dalle;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public class DalleBattle
extends Dalle {
    public static Texture texWhite;
    public static Texture texBlack;
    public Texture texture;
    public Player player;

    static {
        Pixmap white_map = new Pixmap(1, 1, Pixmap.Format.RGB888);
        white_map.setColor(0.8627451f, 0.19607843f, 0.0f, 1.0f);
        white_map.drawPixel(0, 0);
        texWhite = new Texture(white_map);
        Pixmap black_map = new Pixmap(1, 1, Pixmap.Format.RGB888);
        black_map.setColor(0.0f, 0.19607843f, 0.8627451f, 1.0f);
        black_map.drawPixel(0, 0);
        texBlack = new Texture(black_map);
    }

    public DalleBattle(GridDmqh grid, GDXImage image, int i, int j, int value) {
        super(grid, image, i, j, value);
        this.setImage();
    }

    public DalleBattle(GridDmqh grid, PlayerColor playerColor, GDXImage image, int i, int j, int value) {
        super(grid, image, i, j, value);
        this.player.color = playerColor;
        this.setImage();
    }

    public static PlayerColor getDominantPlayer(int i1, int j1, int i2, int j2, GridDmqh grid) {
        if (grid.values[i1][j1].player.color != null || grid.values[i2][j2].player.color != null) {
            if (grid.values[i1][j1].player.color != null && grid.values[i2][j2].player.color == null) {
                return grid.values[i1][j1].player.color;
            }
            if (grid.values[i2][j2].player.color != null && grid.values[i1][j1].player.color == null) {
                return grid.values[i2][j2].player.color;
            }
        }
        return null;
    }

    @Override
    public void stop() {
        this.dx = 0;
        this.dy = 0;
        this.state = Dalle.State.STATIC;
        this.grid.setDalle(this.end_i, this.end_j, this);
        this.grid.setDalle(this.start_i, this.start_j, null);
        this.player.color = this.grid.values[this.end_i][this.end_j].player.color;
        this.setCoords(this.end_i, this.end_j);
        this.setImage();
    }

    @Override
    public void setImage() {
        if (this.player.color == PlayerColor.WHITE) {
            this.texture = texWhite;
        } else if (this.player.color == PlayerColor.BLACK) {
            this.texture = texBlack;
        }
    }

    @Override
    public void draw() {
        if (this.isVisible) {
            Position position = this.getPositionScale();
            if (this.texture != null) {
                GDXImage.batch.draw(this.texture, (float)Graphics.decalageX + position.x, position.y, this.image.getWidth() * this.grid.ratio * Scene2D.RATIO, this.image.getHeight() * this.grid.ratio * Scene2D.RATIO);
            }
            GDXImage.draw(this.image.texture, position.x, position.y, this.image.getWidth() * Scene2D.RATIO * this.grid.ratio, this.image.getHeight() * Scene2D.RATIO * this.grid.ratio);
        }
    }
}

