/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.AbstractMessage;
import com.takyon.gamelib.GDXGameNet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;

public class AbstractClient
extends Thread {
    public int id = -1;
    public static int nbSend;
    public String hostName;
    public InetAddress address;
    public int portNum;
    public Socket socket;
    public ObjectInputStream in;
    public ObjectOutputStream out;
    public boolean accepted = false;
    private boolean isConnected = false;
    public ArrayList<AbstractMessage> abstractMessages;
    protected boolean finished = false;
    public AbstractMessage recMessage = null;

    protected AbstractClient() {
    }

    public AbstractClient(InetAddress address, int port) throws IOException {
        this.socket = new Socket(address, port);
        this.init(this.socket, port);
    }

    public AbstractClient(Socket socket, int port) throws IOException {
        this.init(socket, port);
    }

    public AbstractClient(String ip, int port) throws IOException {
        this.hostName = ip;
        this.socket = new Socket(this.hostName, port);
        this.init(this.socket, port);
    }

    public void init(Socket socket, int port) throws IOException {
        socket.setTcpNoDelay(true);
        this.abstractMessages = new ArrayList();
        this.out = new ObjectOutputStream(socket.getOutputStream());
        this.in = new ObjectInputStream(socket.getInputStream());
        this.address = socket.getInetAddress();
        this.portNum = port;
    }

    @Override
    public void run() {
        while (!this.finished) {
            this.receiveMessage();
        }
    }

    public void receiveMessage() {
        try {
            this.recMessage = (AbstractMessage)this.in.readObject();
            GDXGameNet.messages.add((Object)this.recMessage);
            System.out.println("Client receives Message from " + this.recMessage.senderID + "; " + this.recMessage.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.onConnectionError();
            this.finished = true;
        }
    }

    public void sendMessage(int destID, AbstractMessage msg) {
        msg.destID = destID;
        this.sendMessage(msg);
    }

    public void sendMessage(AbstractMessage msg) {
        try {
            msg.senderID = this.id;
            this.out.writeObject(msg);
            this.out.flush();
            this.out.reset();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.onConnectionError();
            this.finished = true;
        }
    }

    public void onConnectionError() {
    }

    public boolean isClientConencted() {
        return this.isConnected;
    }
}

