/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Point;
import com.takyon.gamelib.Rectangle;
import com.takyon.gamelib.Segment;

public class CollisionRectangle
extends Rectangle {
    public float radius;
    public Point center = new Point();
    public Segment[] segments = new Segment[4];

    public CollisionRectangle(Rectangle rectangle) {
        this(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public CollisionRectangle(float x, float y, float width, float height) {
        super(x, y, width, height);
        this.segments[0] = new Segment();
        this.segments[1] = new Segment();
        this.segments[2] = new Segment();
        this.segments[3] = new Segment();
        this.setCenter();
        this.setRadius();
        this.setSegments();
    }

    public void setWidth(float width) {
        this.width = width;
        this.setRadius();
        this.setSegments();
    }

    public void setHeight(float height) {
        this.height = height;
        this.setRadius();
        this.setSegments();
    }

    public void setDimensions(float width, float height) {
        this.width = width;
        this.height = height;
        this.setRadius();
        this.setCenter();
        this.setSegments();
    }

    public void setSegments() {
        Segment segment1 = this.segments[0];
        segment1.p1.x = this.x;
        segment1.p1.y = this.y;
        segment1.p2.x = this.x;
        segment1.p2.y = this.y - this.height;
        Segment segment2 = this.segments[1];
        segment2.p1.x = this.x;
        segment2.p1.y = this.y - this.height;
        segment2.p2.x = this.x + this.width;
        segment2.p2.y = this.y - this.height;
        Segment segment3 = this.segments[2];
        segment3.p1.x = this.x + this.width;
        segment3.p1.y = this.y - this.height;
        segment3.p2.x = this.x + this.width;
        segment3.p2.y = this.y;
        Segment segment4 = this.segments[3];
        segment4.p1.x = this.x + this.width;
        segment4.p1.y = this.y;
        segment4.p2.x = this.x;
        segment4.p2.y = this.y;
    }

    public void update(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.setRadius();
        this.setCenter();
        this.setSegments();
    }

    public void update() {
        this.setRadius();
        this.setCenter();
        this.setSegments();
    }

    public void setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        this.setCenter();
        this.setSegments();
    }

    public void setRadius() {
        this.radius = (float)Math.sqrt(this.width * this.width + this.height * this.height) / 2.0f;
    }

    public void setCenter() {
        this.center.set(this.x + this.width / 2.0f, this.y - this.height / 2.0f);
    }

    public void moveX(float dx) {
        this.x += dx;
        this.setCenter();
        this.setSegments();
    }

    public void moveY(float dy) {
        this.y += dy;
        this.setCenter();
        this.setSegments();
    }
}

