/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.graphics.Texture;
import com.takyon.chess.gui.GUIComponent;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Geometry;
import com.takyon.gamelib.Input;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Rectangle;
import com.takyon.gamelib.Scene2D;

public class GDXButton
extends GUIComponent {
    public static String suffix_up = "";
    public static String suffix_down = "";
    public static String suffix_disabled = "";
    public Texture imgUp;
    public Texture imgDown;
    public Texture imgDisabled;
    public Texture img;
    public String label;
    public Enum buttonEnum;
    public Rectangle rectangle;

    public GDXButton() {
        this.rectangle = new Rectangle();
    }

    public GDXButton(String imgName) {
        this();
        this.imgUp = new Texture(String.valueOf(imgName) + suffix_up + ".png");
        this.imgDown = new Texture(String.valueOf(imgName) + suffix_down + ".png");
        this.imgDisabled = new Texture(String.valueOf(imgName) + suffix_disabled + ".png");
        this.img = this.imgUp;
    }

    public GDXButton(String imgName, boolean hasUp, boolean hasDown, boolean hasDisabled) {
        this();
        if (hasUp) {
            this.imgUp = new Texture(String.valueOf(imgName) + suffix_up + ".png");
        }
        if (hasDown) {
            this.imgDown = new Texture(String.valueOf(imgName) + suffix_down + ".png");
        }
        if (hasDisabled) {
            this.imgDisabled = new Texture(String.valueOf(imgName) + suffix_disabled + ".png");
        }
        this.img = this.imgUp;
    }

    public GDXButton(GDXImage imageUp, GDXImage imageDown, GDXImage imageDisabled) {
        this.imgUp = imageUp.texture;
        this.imgDown = imageDown.texture;
        if (imageDisabled != null) {
            this.imgDisabled = imageDisabled.texture;
        }
        this.img = this.imgUp;
    }

    public GDXButton(String imgName, int w, int h) {
        this.imgUp = new Texture(String.valueOf(imgName) + suffix_up + ".png");
        this.imgDown = new Texture(String.valueOf(imgName) + suffix_down + ".png");
        this.imgDisabled = new Texture(String.valueOf(imgName) + suffix_disabled + ".png");
        this.img = this.imgUp;
    }

    public GDXButton(String imgName, String label) {
        this(imgName);
        this.label = label;
    }

    public GDXButton(String imgName, String label, int w, int h) {
        this(imgName, w, h);
        this.label = label;
    }

    public boolean isPressed() {
        if (Input.iControllers.getMouseConfiguration().isButtonDown(this.buttonEnum)) {
            return Geometry.isPointInRectangle(Input.iControllers.getMouse().pos, this.getRectangle());
        }
        return false;
    }

    public boolean isPointed(int x, int y) {
        return (float)x > this.getPosition().x && (float)y > this.getPosition().y && (float)x < this.getPosition().x + (float)this.img.getTextureData().getWidth() && (float)y < this.getPosition().y + (float)this.img.getTextureData().getHeight();
    }

    public boolean isTouchDown(int x, int y) {
        if (this.isEnabled() && this.isVisible()) {
            if (this.isPointed(x, y)) {
                this.img = this.imgDown;
                return true;
            }
            this.img = this.imgUp;
            return false;
        }
        return false;
    }

    @Override
    public boolean isClicked(int x, int y) {
        if (this.isEnabled() && this.isVisible() && this.isPointed(x, y)) {
            this.img = this.imgUp;
            return true;
        }
        this.img = this.isEnabled() ? this.imgUp : this.imgDisabled;
        return false;
    }

    @Override
    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            GDXImage.draw(this.img, this.getPositionScale().x, this.getPositionScale().y, (float)this.img.getWidth() * Scene2D.RATIO, (float)this.img.getHeight() * Scene2D.RATIO);
        }
    }

    @Override
    public Position getPositionScale() {
        this.positionScaled.x = this.getPosition().x * Scene2D.RATIO;
        this.positionScaled.y = ((float)Scene2D.SCREEN_HEIGHT_BASE - this.getPosition().y - (float)this.img.getHeight()) * Scene2D.RATIO;
        return this.positionScaled;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.img = enabled ? this.imgUp : this.imgDisabled;
    }

    public Rectangle getRectangle() {
        this.rectangle.x = this.getPositionScale().x;
        this.rectangle.y = this.getPositionScale().y + (float)this.img.getTextureData().getHeight();
        this.rectangle.width = this.img.getTextureData().getWidth();
        this.rectangle.height = this.img.getTextureData().getHeight();
        return this.rectangle;
    }

    public void release() {
        this.img = this.imgUp;
    }
}

