/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Disposable;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Rectangle;
import com.takyon.gamelib.Scene2D;
import java.util.ArrayList;

public class GDXImageRegion
extends DrawableObject {
    public TextureRegion textureRegion;
    public static SpriteBatch batch;
    public boolean isBlending = false;
    public Rectangle rectangle;
    public Color batchColor = new Color();
    public static ArrayList<Disposable> textures;

    public GDXImageRegion() {
        this.batchColor.set(1.0f, 1.0f, 1.0f, 1.0f);
        textures = new ArrayList();
    }

    public GDXImageRegion(TextureRegion textureRegion) {
        this();
        this.textureRegion = textureRegion;
    }

    @Override
    public float getAlpha() {
        return this.batchColor.a;
    }

    @Override
    public void setAlpha(float alpha) {
        this.batchColor.a = alpha;
    }

    @Override
    public Position getPositionScale() {
        this.positionScaled.x = this.getPosition().x * Scene2D.RATIO;
        this.positionScaled.y = ((float)Scene2D.SCREEN_HEIGHT_BASE - this.getPosition().y - this.getHeight()) * Scene2D.RATIO;
        return this.positionScaled;
    }

    public boolean isPointed(int x, int y) {
        return (float)x > this.getPosition().x && (float)y > this.getPosition().y && (float)x < this.getPosition().x + this.getWidth() && (float)y < this.getPosition().y + this.getHeight();
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            this.draw(this.getPositionScale().x, this.getPositionScale().y, this.getAlpha());
        }
    }

    public float getWidth() {
        return this.textureRegion.getRegionWidth();
    }

    public float getHeight() {
        return this.textureRegion.getRegionHeight();
    }

    public void draw(Position position) {
        this.draw(position.x, position.y);
    }

    public void draw(float x, float y) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, this.batchColor.a);
        batch.draw(this.textureRegion, (float)Graphics.decalageX + x, y, this.getWidth() * Scene2D.RATIO, this.getHeight() * Scene2D.RATIO);
    }

    public void draw(float x, float y, float w, float h) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, this.batchColor.a);
        batch.draw(this.textureRegion, (float)Graphics.decalageX + x, y, w * Scene2D.RATIO, h * Scene2D.RATIO);
    }

    public void drawRotation(float x, float y, float w, float h, float angle) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, this.batchColor.a);
        batch.draw(this.textureRegion, (float)Graphics.decalageX + x, y, 0.0f, 0.0f, w * Scene2D.RATIO, h * Scene2D.RATIO, 1.0f, 1.0f, angle);
    }

    public void draw(float x, float y, float w, float h, float alpha) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, alpha);
        batch.draw(this.textureRegion, (float)Graphics.decalageX + x, y, w * Scene2D.RATIO, h * Scene2D.RATIO);
    }

    public void draw(float x, float y, float alpha) {
        batch.setColor(this.batchColor.r, this.batchColor.g, this.batchColor.b, alpha);
        batch.draw(this.textureRegion, (float)Graphics.decalageX + x, y, this.getWidth() * Scene2D.RATIO, this.getHeight() * Scene2D.RATIO);
    }

    public static void draw(TextureRegion textureRegion, float x, float y) {
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        batch.draw(textureRegion, (float)Graphics.decalageX + x, y, (float)textureRegion.getRegionWidth() * Scene2D.RATIO, (float)textureRegion.getRegionHeight() * Scene2D.RATIO);
    }

    public static void draw(TextureRegion textureRegion, float x, float y, float alpha) {
        batch.setColor(1.0f, 1.0f, 1.0f, alpha);
        batch.draw(textureRegion, (float)Graphics.decalageX + x, y, (float)textureRegion.getRegionWidth() * Scene2D.RATIO, (float)textureRegion.getRegionHeight() * Scene2D.RATIO);
    }

    public static void draw(TextureRegion textureRegion, float x, float y, float width, float height) {
        batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        batch.draw(textureRegion, (float)Graphics.decalageX + x, y, width, height);
    }

    public static void draw(TextureRegion textureRegion, float x, float y, float width, float height, float alpha) {
        batch.setColor(1.0f, 1.0f, 1.0f, alpha);
        batch.draw(textureRegion, (float)Graphics.decalageX + x, y, width, height);
    }
}

