/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;

public class GDXSprite
extends DrawableObject {
    private int nbCols;
    private int nbRows;
    private Texture spriteSheet;
    private float stateTime;
    private int frameRate;
    private Animation animation;
    public TextureRegion currentFrame;

    public GDXSprite(Texture spriteSheet, int nbCols, int nbRows, int frameRate) {
        this.spriteSheet = spriteSheet;
        this.nbCols = nbCols;
        this.nbRows = nbRows;
        this.frameRate = frameRate;
        this.init();
    }

    private void init() {
        this.stateTime = 0.0f;
        TextureRegion[][] tmp = TextureRegion.split((Texture)this.spriteSheet, (int)256, (int)256);
        TextureRegion[] frames = new TextureRegion[this.nbCols * this.nbRows];
        int index = 0;
        int i = 0;
        while (i < this.nbRows) {
            int j = 0;
            while (j < this.nbCols) {
                frames[index++] = tmp[i][j];
                ++j;
            }
            ++i;
        }
        this.animation = new Animation(1.0f / (float)this.frameRate, frames);
        this.animation.setPlayMode(Animation.PlayMode.LOOP);
    }

    public void logic(float dt) {
        this.stateTime += dt;
        this.currentFrame = this.animation.getKeyFrame(this.stateTime, false);
    }

    public void startAnimation() {
        this.stateTime = 0.0f;
    }

    public boolean isAnimationFinished() {
        return this.animation.isAnimationFinished(this.stateTime);
    }

    @Override
    public void draw() {
        Position pos = this.getPositionScale();
        Graphics.drawCentered(this.currentFrame, (float)Graphics.decalageX + pos.x, pos.y, (float)this.currentFrame.getRegionWidth(), (float)this.currentFrame.getRegionHeight());
    }
}

