/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.PropertiesUtils;
import com.takyon.gamelib.GDXTextStyle;
import com.takyon.gamelib.Scene2D;
import com.takyon.gamelib.TextStyle;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import sun.font.TrueTypeFont;

public abstract class GameFonts {
    public ObjectMap<String, String> properties;
    protected ArrayList<TextStyle> textStyles;
    public String fileDir = "";
    protected HashMap<String, TrueTypeFont> trueTypeFonts;
    protected static HashMap<String, FreeTypeFontGenerator> freeTypeFontGenerators;
    public String fontDrectory;
    public String FONT_CHARACTERS;

    protected GameFonts() {
        this.properties = new ObjectMap();
    }

    protected GameFonts(String fileName) throws FileNotFoundException {
        this.textStyles = new ArrayList();
        try {
            PropertiesUtils.load(this.properties, (Reader)Gdx.files.internal(fileName).reader());
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.trueTypeFonts = new HashMap();
    }

    public GameFonts(String fileDir, String fileName) throws FileNotFoundException {
        this(fileName);
        this.fileDir = fileDir;
    }

    public abstract void load();

    protected GDXTextStyle generateFont(String textStyleName) {
        FreeTypeFontGenerator generator;
        String[] params = ((String)this.properties.get((Object)textStyleName)).split(";");
        String fontNameParam = params[0].trim();
        String styleParam = params[1].trim();
        String sizeParam = params[2].trim();
        String alignParam = params[3].trim();
        String colorParam = params[4].trim();
        String fontName = fontNameParam.split(":")[1].trim();
        String style = styleParam.split(":")[1].trim();
        String size = sizeParam.split(":")[1].trim();
        String align = alignParam.split(":")[1].trim();
        String color = colorParam.split(":")[1].trim();
        String wrapParam = "";
        String wrap = "0";
        if (params.length == 6) {
            wrapParam = params[5].trim();
            wrap = wrapParam.split(":")[1].trim();
        }
        int fontStyle = 0;
        int fontSize = (int)(Scene2D.RATIO * (float)Integer.parseInt(size));
        int fontAlign = 0;
        int wrapWidth = Integer.parseInt(wrap);
        if (style.equals("NORMAL")) {
            fontStyle = 0;
        } else if (style.equals("GRAS")) {
            fontStyle = 1;
        } else if (style.equals("ITALIC")) {
            fontStyle = 2;
        }
        if (align.equals("GAUCHE")) {
            fontAlign = 0;
        } else if (align.equals("DROITE")) {
            fontAlign = 1;
        } else if (align.equals("CENTRE")) {
            fontAlign = 2;
        }
        String[] rgb = color.split(",");
        float red = Integer.parseInt(rgb[0].trim());
        float green = Integer.parseInt(rgb[1].trim());
        float blue = Integer.parseInt(rgb[2].trim());
        if (freeTypeFontGenerators.get(fontName) == null) {
            generator = new FreeTypeFontGenerator(Gdx.files.internal(String.valueOf(this.fontDrectory) + "/" + fontName + ".ttf"));
            freeTypeFontGenerators.put(fontName, generator);
        } else {
            generator = freeTypeFontGenerators.get(fontName);
        }
        FreeTypeFontGenerator.FreeTypeFontParameter parameters = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameters.characters = this.FONT_CHARACTERS;
        parameters.size = fontSize;
        GDXTextStyle textStyle = new GDXTextStyle();
        textStyle.align = fontAlign;
        textStyle.font = generator.generateFont(parameters);
        textStyle.font.setColor(red / 255.0f, green / 255.0f, blue / 255.0f, 1.0f);
        textStyle.wrapWidth = wrapWidth;
        return textStyle;
    }

    protected int getTextLimit(String textLimit) {
        return Integer.parseInt(((String)this.properties.get((Object)textLimit)).trim());
    }
}

