/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.CollisionRectangle;
import com.takyon.gamelib.Point;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Ray;
import com.takyon.gamelib.Rectangle;
import com.takyon.gamelib.Segment;
import com.takyon.gamelib.SegmentAffine;
import com.takyon.gamelib.Vector2d;
import com.takyon.gamelib.Vector3d;

public class Geometry {
    public static int DIRECTION_LEFT = -1;
    public static int DIRECTION_RIGHT = 1;

    public static float norm(Point p1, Point p2) {
        return (float)Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y));
    }

    public static float norm(Vector2d v) {
        return (float)Math.sqrt(v.x * v.x + v.y * v.y);
    }

    public static float length(Segment s) {
        return (float)Math.sqrt((s.p2.x - s.p1.x) * (s.p2.x - s.p1.x) + (s.p2.y - s.p1.y) * (s.p2.y - s.p1.y));
    }

    public static float distance(Point point, Segment segment) {
        Vector3d AB = segment.toVector();
        Vector3d AC = new Vector3d(segment.p1, point);
        return AB.crossProd(AC).length() / AB.length();
    }

    public static Point getPointProjectionInSegment(Point point, Segment segment) {
        Vector3d v = segment.toVector();
        Vector3d w = new Vector3d(segment.p1, point);
        float c1 = w.dotProd(v);
        float c2 = v.dotProd(v);
        float b = c1 / c2;
        Point proj = segment.p1.getTranslatedPoint(v.scalev(b));
        return proj;
    }

    public static boolean isPointProjectionInSegment(Point point, Segment segment) {
        Vector3d AB = segment.toVector();
        Vector3d AC = new Vector3d(segment.p1, point);
        float len = AB.length();
        float prodScal = AC.dotProd(AB);
        return prodScal > 0.0f && prodScal < len * len;
    }

    public static boolean isPointInSegment(Point point, Segment segment) {
        Vector3d PA = new Vector3d(point, segment.p1);
        Vector3d PB = new Vector3d(point, segment.p2);
        return PA.dotProd(PB) < 0.0f && PA.length() + PB.length() == segment.toVector().length();
    }

    public static boolean hasIntersection(SegmentAffine segment1, SegmentAffine segment2) {
        float denom = (segment2.p2.y - segment2.p1.y) * (segment1.p2.x - segment1.p1.x) - (segment2.p2.x - segment2.p1.x) * (segment1.p2.y - segment1.p1.y);
        float nume_a = (segment2.p2.x - segment2.p1.x) * (segment1.p1.y - segment2.p1.y) - (segment2.p2.y - segment2.p1.y) * (segment1.p1.x - segment2.p1.x);
        float nume_b = (segment1.p2.x - segment1.p1.x) * (segment1.p1.y - segment2.p1.y) - (segment1.p2.y - segment1.p1.y) * (segment1.p1.x - segment2.p1.x);
        if (denom == 0.0f) {
            return nume_a == 0.0f && nume_b == 0.0f;
        }
        float ua = nume_a / denom;
        float ub = nume_b / denom;
        return ua >= 0.0f && ua <= 1.0f && ub >= 0.0f && ub <= 1.0f;
    }

    public static Point getIntersectionPoint(Segment segment1, Segment segment2) {
        double Sy;
        double Sx;
        float Ax = segment1.p1.x;
        float Ay = segment1.p1.y;
        float Bx = segment1.p2.x;
        float By = segment1.p2.y;
        float Cx = segment2.p1.x;
        float Cy = segment2.p1.y;
        float Dx = segment2.p2.x;
        float Dy = segment2.p2.y;
        if (Ax == Bx) {
            if (Cx == Dx) {
                return null;
            }
            double pCD = (Cy - Dy) / (Cx - Dx);
            Sx = Ax;
            Sy = pCD * (double)(Ax - Cx) + (double)Cy;
        } else if (Cx == Dx) {
            double pAB = (Ay - By) / (Ax - Bx);
            Sx = Cx;
            Sy = pAB * (double)(Cx - Ax) + (double)Ay;
        } else {
            double pCD = (Cy - Dy) / (Cx - Dx);
            double pAB = (Ay - By) / (Ax - Bx);
            double oCD = (double)Cy - pCD * (double)Cx;
            double oAB = (double)Ay - pAB * (double)Ax;
            Sx = (oAB - oCD) / (pCD - pAB);
            Sy = pCD * Sx + oCD;
        }
        if ((Sx < (double)Ax && Sx < (double)Bx) | (Sx > (double)Ax && Sx > (double)Bx) | (Sx < (double)Cx && Sx < (double)Dx) | (Sx > (double)Cx && Sx > (double)Dx) | (Sy < (double)Ay && Sy < (double)By) | (Sy > (double)Ay && Sy > (double)By) | (Sy < (double)Cy && Sy < (double)Dy) | (Sy > (double)Cy && Sy > (double)Dy)) {
            return null;
        }
        return new Point((float)Sx, (float)Sy);
    }

    public static boolean isPointInRectangle(Point point, Rectangle r) {
        return point.x > r.x && point.x < r.x + r.width && point.y < r.y && point.y > r.y - r.height;
    }

    public static boolean isPositionInRectangle(Position position, Rectangle r) {
        return position.x > r.x && position.x < r.x + r.width && position.y < r.y && position.y > r.y - r.height;
    }

    public static boolean hasIntersection(Rectangle r1, Rectangle r2) {
        return Geometry.isPointInRectangle(new Point(r1.x, r1.y), r2) || Geometry.isPointInRectangle(new Point(r1.x, r1.y - r1.height), r2) || Geometry.isPointInRectangle(new Point(r1.x + r1.width, r1.y - r1.height), r2) || Geometry.isPointInRectangle(new Point(r1.x + r1.width, r1.y), r2) || Geometry.isPointInRectangle(new Point(r2.x, r2.y), r1) || Geometry.isPointInRectangle(new Point(r2.x, r2.y - r2.height), r1) || Geometry.isPointInRectangle(new Point(r2.x + r2.width, r2.y - r2.height), r1) || Geometry.isPointInRectangle(new Point(r2.x + r2.width, r2.y), r1);
    }

    public static boolean hasIntersection(SegmentAffine s, Rectangle r) {
        return Geometry.hasIntersection(s, new SegmentAffine(new Point(r.x, r.y), new Point(r.x, r.y - r.height))) || Geometry.hasIntersection(s, new SegmentAffine(new Point(r.x, r.y - r.height), new Point(r.x + r.width, r.y - r.height))) || Geometry.hasIntersection(s, new SegmentAffine(new Point(r.x + r.width, r.y - r.height), new Point(r.x + r.width, r.y))) || Geometry.hasIntersection(s, new SegmentAffine(new Point(r.x + r.width, r.y), new Point(r.x, r.y)));
    }

    public static boolean hasIntersection(CollisionRectangle r1, CollisionRectangle r2) {
        return Geometry.hasCircleIntersection(r1, r2) && Geometry.hasIntersection((Rectangle)r1, (Rectangle)r2);
    }

    public static boolean hasCircleIntersection(CollisionRectangle r1, CollisionRectangle r2) {
        return Geometry.distance(r1.center, r2.center) < r1.radius + r2.radius;
    }

    public static float distance(Point p1, Point p2) {
        return (float)Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y));
    }

    public static float distance(Position p1, Position p2) {
        return (float)Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y));
    }

    private static float sign(Point p1, Point p2, Point p3) {
        return (p1.x - p3.x) * (p2.y - p3.y) - (p2.x - p3.x) * (p1.y - p3.y);
    }

    public static boolean isPointInTriangle(Point p, Point p1, Point p2, Point p3) {
        boolean b3;
        boolean b1 = Geometry.sign(p, p1, p2) < 0.0f;
        boolean b2 = Geometry.sign(p, p2, p3) < 0.0f;
        boolean bl = b3 = Geometry.sign(p, p3, p1) < 0.0f;
        return b1 == b2 && b2 == b3;
    }

    public static boolean isPointInQuad(Point p, Point p1, Point p2, Point p3, Point p4) {
        return Geometry.isPointInTriangle(p, p1, p2, p3) || Geometry.isPointInTriangle(p, p2, p3, p4) || Geometry.isPointInTriangle(p, p3, p4, p1) || Geometry.isPointInTriangle(p, p1, p2, p4);
    }

    public static Point getIntersectRayTriangle(Ray ray, Point p1, Point p2, Point p3) {
        Point point = new Point();
        Vector3d u = new Vector3d(p1, p2);
        Vector3d v = new Vector3d(p1, p3);
        Vector3d n = u.crossProd(v);
        if (n.length() == 0.0f) {
            return null;
        }
        Vector3d dir = new Vector3d(ray.direction);
        Vector3d w0 = new Vector3d(p1, ray.point);
        float a = -new Vector3d(n).dotProd(w0);
        float b = new Vector3d(n).dotProd(dir);
        float SMALL_NUM = 0.1f;
        if (Math.abs(b) < SMALL_NUM) {
            return null;
        }
        float r = a / b;
        if ((double)r < 0.0) {
            return null;
        }
        point = new Point(ray.point);
        point.x += r * dir.x;
        point.y += r * dir.y;
        point.z += r * dir.z;
        return point;
    }

    public static boolean isPointInCircle(Point point, Point center, float radius) {
        return new Vector2d(point, center).length() <= radius;
    }

    public static float getAngle(Vector3d v1, Vector3d v2, Vector3d axis) {
        return v1.signedAngle(v2, axis);
    }
}

