/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.BattleGame;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXImageRegion;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public class Graphics {
    public static int decalageX = 0;
    public static float ratio;
    public static GDXText version;
    public static ShapeRenderer shapeRenderer;
    public static FrameBuffer particleBuffer;
    public static TextureRegion particleRegion;

    public static void drawCentered(GDXImageRegion image, float x, float y, float w, float h) {
        GDXImageRegion.batch.setColor(image.batchColor.r, image.batchColor.g, image.batchColor.b, image.batchColor.a);
        image.draw(x - w / 2.0f * Scene2D.RATIO, y - h / 2.0f * Scene2D.RATIO, w, h);
    }

    public static void drawFlippedY(GDXImageRegion image, float x, float y, float w, float h, float angle) {
        GDXImageRegion.batch.setColor(image.batchColor.r, image.batchColor.g, image.batchColor.b, image.batchColor.a);
        GDXImageRegion.batch.draw(image.textureRegion, (float)decalageX + x - w / 2.0f * Scene2D.RATIO, y + h / 2.0f * Scene2D.RATIO, 0.0f, 0.0f, w * Scene2D.RATIO, h * Scene2D.RATIO, 1.0f, -1.0f, angle);
    }

    public static void drawCentered(TextureRegion region, float x, float y, float w, float h) {
        GDXImage.batch.draw(region, (float)decalageX + x - w / 2.0f * Scene2D.RATIO, y - h / 2.0f * Scene2D.RATIO, w * Scene2D.RATIO, h * Scene2D.RATIO);
    }

    public static void drawFlippedY(TextureRegion region, float x, float y, float w, float h, float angle) {
        GDXImage.batch.draw(region, (float)decalageX + x - w / 2.0f * Scene2D.RATIO, y + h / 2.0f * Scene2D.RATIO, 0.0f, 0.0f, w * Scene2D.RATIO, h * Scene2D.RATIO, 1.0f, -1.0f, angle);
    }

    public static void drawWithRatio(GDXImage image, float width, float height) {
        if (image.isVisible()) {
            image.positionScaled.x = image.getPosition().x * Scene2D.RATIO;
            image.positionScaled.y = ((float)Scene2D.SCREEN_HEIGHT_BASE - image.getPosition().y - (float)image.texture.getHeight() * ratio) * Scene2D.RATIO;
            image.draw(image.positionScaled.x, image.positionScaled.y, width, height);
        }
    }

    public static float getPositionScaleX(float x) {
        return x * Scene2D.RATIO;
    }

    public static float getPositionScaleX(Vector2 position) {
        return Graphics.getPositionScaleX(position.x);
    }

    public static float getPositionScaleY(float y) {
        return ((float)Scene2D.SCREEN_HEIGHT_BASE - y) * Scene2D.RATIO;
    }

    public static float getPositionScaleY(Vector2 position) {
        return Graphics.getPositionScaleY(position.y);
    }

    public static void setInitialPosition(DrawableObject drawable, float x, float y) {
        if (BattleGame.isPCWebGL()) {
            drawable.setPosition(x, y);
        } else {
            drawable.setPosition(y, x);
        }
    }

    public static void setPosition(DrawableObject drawable, float x, float y) {
        if (BattleGame.isPCWebGL()) {
            drawable.setPosition(x, y);
        } else {
            drawable.setPosition(y, x);
        }
    }

    public static GDXImage getImage(TextureAtlas atlas, String name) {
        return new GDXImage(atlas.findRegion(name).getTexture());
    }

    public static void drawCircle(Position pos, float r, int angleStart, int angleEnd) {
        double angle = 0.0;
        double step = 10.0;
        int i = angleStart;
        while (i < angleEnd) {
            double da = Math.toRadians(step);
            float cx1 = (float)(Math.cos(angle) * (double)r);
            float cy1 = (float)(Math.sin(angle) * (double)r);
            float cx2 = (float)(Math.cos(angle + da) * (double)r);
            float cy2 = (float)(Math.sin(angle + da) * (double)r);
            angle += da;
            shapeRenderer.line(pos.x + cx1, pos.y + cy1, pos.x + cx2, pos.y + cy2);
            i = (int)((double)i + step);
        }
    }
}

