/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib.network;

import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import com.takyon.gamelib.AbstractMessage;
import com.takyon.gamelib.network.Client;
import com.takyon.gamelib.network.Server;
import com.takyon.gamelib.network.server.DisconenctedMessage;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class ClientThread
extends Thread {
    public Client client;
    private boolean finished = false;
    private Json json;
    private BufferedReader reader;

    public ClientThread(Client client) {
        this.client = client;
        this.reader = new BufferedReader(new InputStreamReader(client.in));
        this.json = new Json();
        this.json.setOutputType(JsonWriter.OutputType.json);
    }

    @Override
    public void run() {
        while (!this.finished) {
            this.receiveMessage();
        }
    }

    private void receiveMessage() {
        try {
            AbstractMessage recMessage = null;
            recMessage = (AbstractMessage)this.client.in.readObject();
            if (recMessage.destID == 0) {
                recMessage.execute();
            } else if (recMessage.destID == -1) {
                Server.sendAll(recMessage);
            } else {
                Server.send(recMessage, recMessage.destID);
            }
            System.out.println("server receives message from " + recMessage.senderID + "; " + recMessage.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            Server.deleteClient(this.client.id);
            Server.deleteJoueur(this.client.id);
            if (this.client.pairID > 0) {
                DisconenctedMessage msg = new DisconenctedMessage(this.client.id);
                msg.destID = this.client.pairID;
                Server.send(msg);
            }
            this.finished = true;
        }
    }
}

