/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.squares;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonWriter;
import com.badlogic.gdx.utils.ObjectMap;
import com.takyon.battle.screens.BattleScreenGame;
import com.takyon.chess.test.SaveBug;
import com.takyon.chess.utils.Positions;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GameScreen;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.IBrowser;
import com.takyon.gamelib.Language;
import com.takyon.gamelib.Scene2D;
import com.takyon.squares.Fonts;
import com.takyon.squares.screens.SquareGameScreen;
import java.io.FileNotFoundException;

public class SquaresMain
extends ApplicationAdapter
implements InputProcessor {
    private static final String PREFS_PLACEMENTS = "placements";
    public static String KIT_DIRECTORY = null;
    public static ObjectMap<String, String> properties;
    public static Preferences prefs;
    public static Json json;
    public static boolean isDebug;
    public static IBrowser browser;
    public static boolean isNetwork;
    public static GDXImage pointer;
    public static boolean isIA;
    public static FrameBuffer particleBuffer;
    public static TextureRegion particleRegion;
    public static int currentPlayer;

    public static boolean isPCWebGL() {
        return true;
    }

    public void create() {
        isDebug = true;
        if (SquaresMain.isPCWebGL()) {
            Scene2D.SCREEN_HEIGHT_BASE = 1080;
            Scene2D.SCREEN_WIDTH_BASE = 1920;
            Scene2D.RATIO = (float)Gdx.app.getGraphics().getWidth() / (float)Scene2D.SCREEN_WIDTH_BASE;
            particleBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.app.getGraphics().getWidth(), Gdx.app.getGraphics().getHeight(), false);
        } else {
            Scene2D.SCREEN_HEIGHT_BASE = 1920;
            Scene2D.SCREEN_WIDTH_BASE = 1080;
            Scene2D.RATIO = (float)Gdx.app.getGraphics().getHeight() / (float)Scene2D.SCREEN_HEIGHT_BASE;
            Graphics.decalageX = (int)(((float)Gdx.app.getGraphics().getWidth() - (float)Scene2D.SCREEN_WIDTH_BASE * Scene2D.RATIO) / 2.0f);
            particleBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.app.getGraphics().getWidth(), Gdx.app.getGraphics().getHeight(), false);
        }
        particleRegion = new TextureRegion();
        new Positions();
        GDXButton.suffix_up = "_off";
        GDXButton.suffix_down = "_on";
        GDXButton.suffix_disabled = "_disabled";
        GDXImage.batch = new SpriteBatch();
        pointer = new GDXImage("kit_square/interface/pointeur.png");
        new Language(Gdx.files.internal("kit_square/interface/labels.fr").read());
        try {
            Fonts fonts = new Fonts("kit_square/fonts/", "kit_square/fonts/polices.txt");
            fonts.load();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        Gdx.input.setInputProcessor((InputProcessor)this);
        json = new Json();
        json.setOutputType(JsonWriter.OutputType.json);
        prefs = Gdx.app.getPreferences("PREFS_DINO");
        currentPlayer = 1;
        Graphics.ratio = 1.0f;
        SquareGameScreen.initScreens();
        GameScreen.setScreen(SquareGameScreen.screenGame);
    }

    public static void initGame() {
    }

    public static int getEnnemy(int player) {
        if (player == 1) {
            return 2;
        }
        if (player == 2) {
            return 1;
        }
        return 0;
    }

    public boolean keyDown(int keycode) {
        return false;
    }

    public boolean keyUp(int keycode) {
        GameScreen.currentScreen.keyUp(keycode);
        return false;
    }

    public boolean keyTyped(char character) {
        if (character == 'f') {
            Gdx.graphics.setDisplayMode(Gdx.graphics.getDesktopDisplayMode().width, Gdx.graphics.getDesktopDisplayMode().height, true);
        }
        GameScreen.currentScreen.keyTyped(character);
        return false;
    }

    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.onTouchDown(x, y, pointer, button);
        return true;
    }

    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.onTouched(x, y, pointer, button);
        return true;
    }

    public boolean touchDragged(int screenX, int screenY, int pointer) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.mouseDragged(x, y, pointer);
        return false;
    }

    public boolean mouseMoved(int screenX, int screenY) {
        int x = (int)((float)(screenX - Graphics.decalageX) / Scene2D.RATIO);
        int y = (int)((float)screenY / Scene2D.RATIO);
        GameScreen.currentScreen.mouseMoved(x, y);
        pointer.setPosition(x, y);
        return false;
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        Scene2D.RATIO = (float)Gdx.app.getGraphics().getHeight() / (float)Scene2D.SCREEN_HEIGHT_BASE;
        Graphics.decalageX = (int)(((float)Gdx.app.getGraphics().getWidth() - (float)Scene2D.SCREEN_WIDTH_BASE * Scene2D.RATIO) / 2.0f);
        BattleScreenGame.camera = new OrthographicCamera((float)width, (float)height);
    }

    public boolean scrolled(int amount) {
        return false;
    }

    public static void setfullscreen() {
    }

    public static void createBug() {
        SaveBug saveBug = new SaveBug("bug_" + System.currentTimeMillis());
        saveBug.save();
    }

    public void render() {
        float dt = Gdx.graphics.getDeltaTime();
        GameScreen.checkScreenChange();
        GameScreen.currentScreen.process(dt);
        GDXImage.batch.begin();
        GameScreen.currentScreen.display();
        GDXImage.batch.end();
    }

    public void dispose() {
        super.dispose();
        particleBuffer.dispose();
    }

    public static void switchPlayer() {
        currentPlayer = SquaresMain.getEnnemy(currentPlayer);
    }
}

