/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.input.GestureDetector;
import com.takyon.battle.game.Arena;
import com.takyon.battle.game.BattleGameRules;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.input.BattleGesture;
import com.takyon.battle.game.input.BattleInputProcessor;
import com.takyon.battle.screens.BattleGameScreen;
import com.takyon.battle.screens.BattleScreenGame;
import com.takyon.battle.screens.BattleScreenParties;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.test.SaveBug;
import com.takyon.chess.utils.Fonts;
import com.takyon.chess.utils.Positions;
import com.takyon.chess.utils.SavePlacementState;
import com.takyon.gamelib.AbstractMessage;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXGameNet;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXImageRegion;
import com.takyon.gamelib.GameScreen;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Language;
import com.takyon.gamelib.Scene2D;
import com.takyon.gamelib.network.INetworkGamesHandler;
import com.takyon.gamelib.network.PlayerNet;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;

public class BattleGame
extends GDXGame {
    public static HashMap<String, SavePlacementState> mapPlacements;
    public static boolean isIA;
    public static BattleGameRules gameRules;
    public static PlayerBattle playerRed;
    public static PlayerBattle playerBlue;
    public static Arena arena;

    public static boolean isPCWebGL() {
        return false;
    }

    public void create() {
        isDebug = true;
        KIT_DIRECTORY = "kit_battle";
        if (BattleGame.isPCWebGL()) {
            Scene2D.SCREEN_HEIGHT_BASE = 1080;
            Scene2D.SCREEN_WIDTH_BASE = 1920;
            Scene2D.RATIO = (float)Gdx.app.getGraphics().getWidth() / (float)Scene2D.SCREEN_WIDTH_BASE;
            Graphics.particleBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.app.getGraphics().getWidth(), Gdx.app.getGraphics().getHeight(), false);
        } else {
            Scene2D.SCREEN_HEIGHT_BASE = 1920;
            Scene2D.SCREEN_WIDTH_BASE = 1080;
            Scene2D.RATIO = (float)Gdx.app.getGraphics().getHeight() / (float)Scene2D.SCREEN_HEIGHT_BASE;
            Graphics.decalageX = (int)(((float)Gdx.app.getGraphics().getWidth() - (float)Scene2D.SCREEN_WIDTH_BASE * Scene2D.RATIO) / 2.0f);
            Graphics.particleBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, Gdx.app.getGraphics().getWidth(), Gdx.app.getGraphics().getHeight(), false);
        }
        Graphics.particleRegion = new TextureRegion();
        new Positions();
        GDXButton.suffix_up = "_off";
        GDXButton.suffix_down = "_on";
        GDXButton.suffix_disabled = "_disabled";
        GDXImageRegion.batch = GDXImage.batch = new SpriteBatch();
        pointer = new GDXImage("kit_battle/images/interface/pointeur.png");
        prefs = Gdx.app.getPreferences("PREFS_DINO");
        new Language(Gdx.files.internal("kit_battle/labels.en").read());
        try {
            Fonts fonts = new Fonts("kit_battle/fonts/", "kit_battle/fonts/polices.txt");
            fonts.load();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        InputMultiplexer im = new InputMultiplexer();
        GestureDetector gd = new GestureDetector((GestureDetector.GestureListener)new BattleGesture());
        im.addProcessor((InputProcessor)gd);
        im.addProcessor((InputProcessor)new BattleInputProcessor());
        Gdx.input.setInputProcessor((InputProcessor)im);
        arena = BattleGame.isPCWebGL() ? new Arena(150.0f, 0.0f, 1620.0f, 1080.0f) : new Arena(0.0f, 150.0f, 1080.0f, 1620.0f);
        GDXGameNet.iNetworkGamesHandler = new INetworkGamesHandler(){

            @Override
            public void refreshJoueurs(ArrayList<PlayerNet> joueurs) {
                BattleScreenParties.joueurs = joueurs;
            }

            @Override
            public void beginBattle() {
                GameScreen.setScreen(BattleGameScreen.screenGame);
                if (GDXGameNet.playerNet.isHote) {
                    BattleGameRules.initTurn(playerBlue);
                } else {
                    BattleGameRules.initTurn(playerRed);
                }
            }
        };
        Graphics.ratio = 1.0f;
        BattleGameScreen.initScreens();
        GameScreen.setScreen(BattleGameScreen.screenIntro);
    }

    public static void initGame() {
        mapPlacements = new HashMap();
    }

    public static PlayerBattle getPlayer(PlayerColor color) {
        if (color == PlayerColor.WHITE) {
            return playerBlue;
        }
        if (color == PlayerColor.BLACK) {
            return playerRed;
        }
        return null;
    }

    public static PlayerBattle getEnnemy(PlayerBattle player) {
        if (player.color == PlayerColor.BLACK) {
            return playerBlue;
        }
        if (player.color == PlayerColor.WHITE) {
            return playerRed;
        }
        return null;
    }

    public static void load(SavePlacementState state) {
    }

    public static void save(PlayerBattle player, String fileName) {
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        Scene2D.RATIO = (float)Gdx.app.getGraphics().getHeight() / (float)Scene2D.SCREEN_HEIGHT_BASE;
        Graphics.decalageX = (int)(((float)Gdx.app.getGraphics().getWidth() - (float)Scene2D.SCREEN_WIDTH_BASE * Scene2D.RATIO) / 2.0f);
        BattleScreenGame.camera = new OrthographicCamera((float)width, (float)height);
    }

    public static void setfullscreen() {
    }

    public static void createBug() {
        SaveBug saveBug = new SaveBug("bug_" + System.currentTimeMillis());
        saveBug.save();
    }

    public void render() {
        float dt = 0.02f;
        GameScreen.checkScreenChange();
        GameScreen.currentScreen.process(dt);
        if (isNetwork && GDXGameNet.messages.size > 0) {
            ((AbstractMessage)GDXGameNet.messages.get(0)).execute();
            GDXGameNet.messages.removeIndex(0);
        }
        if (GameScreen.currentScreen == BattleScreenGame.screenGame || GameScreen.currentScreen == BattleScreenGame.screenTutorialLiveScreenGame) {
            Graphics.particleBuffer.bind();
            Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gdx.gl.glClear(16384);
            GDXImage.batch.begin();
            BattleScreenGame.drawParticles();
            Graphics.particleRegion.setRegion(Graphics.particleBuffer.getColorBufferTexture());
            Graphics.particleRegion.flip(false, true);
            GDXImage.batch.end();
            FrameBuffer.unbind();
        }
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        GameScreen.currentScreen.display();
        GDXImage.batch.begin();
        if (Gdx.app.getType() == Application.ApplicationType.Desktop || Gdx.app.getType() == Application.ApplicationType.Applet) {
            pointer.display();
        }
        GDXImage.batch.end();
        GameScreen.currentScreen.displayOSD();
    }

    public void dispose() {
        super.dispose();
        Graphics.particleBuffer.dispose();
    }
}

