/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.pions;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.physics.BallPhysics;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.pions.PionBattleFactory;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public class EauBattle
extends PionBattle {
    public EauBattle() {
    }

    public EauBattle(PlayerBattle player, PionBattle.Type type) {
        super(player, type);
    }

    @Override
    public void onCollisionAmis(PionBattle ami) {
        super.onCollisionAmis(ami);
        if (this.isThrown) {
            ami.setBurning(false);
            ami.gagneVie(10);
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        if (this.isFury) {
            this.fury();
            this.isFury = false;
        }
    }

    @Override
    public void fury() {
        super.fury();
        if (this.state.pionStateEnum == PionBattle.PionStateEnum.ATTACKING) {
            int i = 0;
            while (i < this.player.pions.size) {
                PionBattle pion = (PionBattle)this.player.pions.get(i);
                Vector2 vec = BallPhysics.vector(this.ball, pion.ball);
                if (vec.len() < 5.0f * this.ball.radius) {
                    pion.gagneVie(25);
                    pion.setBurning(false);
                }
                ++i;
            }
        }
    }

    @Override
    public void onHit(PionBattle ennemy) {
        super.onHit(ennemy);
        ennemy.swordCut = PionBattleFactory.swordcutEau;
        ennemy.swordCut.startAnimation();
        if (this.nbHit > 2) {
            return;
        }
        if (ennemy.type == PionBattle.Type.ROI) {
            if (this.isEvolue) {
                ennemy.perdVie(this.getDamage(25));
            } else {
                ennemy.perdVie(this.getDamage(10));
            }
        } else if (ennemy.type == PionBattle.Type.TERRE) {
            ennemy.perdVie(this.getDamage(25));
        } else if (ennemy.type == PionBattle.Type.FEU) {
            ennemy.perdVie(this.getDamage(50));
            if (ennemy.isDead) {
                this.isEvolue = true;
            }
        } else if (ennemy.type == PionBattle.Type.EAU) {
            ennemy.perdVie(this.getDamage(25));
        } else if (ennemy.type == PionBattle.Type.AIR) {
            ennemy.perdVie(this.getDamage(10));
        }
    }

    @Override
    public void enableCapacity() {
        this.setAlpha(0.5f);
    }

    @Override
    public void disableCapacity() {
        this.setAlpha(1.0f);
    }

    @Override
    public void logic(float dt) {
        super.logic(dt);
    }

    @Override
    public void drawHud(Position pos, float r) {
        super.drawHud(pos, r);
        if (this.isFury) {
            Gdx.gl20.glLineWidth(5.0f);
            Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            Graphics.shapeRenderer.setColor(0.0f, 0.3f, 0.8f, 1.0f);
            Graphics.drawCircle(pos, this.ball.radius * 5.0f * Scene2D.RATIO, 0, 360);
            Graphics.shapeRenderer.end();
            Gdx.gl20.glLineWidth(1.0f);
        }
    }

    @Override
    public int getHierarchy() {
        return 2;
    }

    @Override
    public int getValue() {
        return 3;
    }
}

