/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.pions;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.game.Item;
import com.takyon.battle.game.PionController;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.actions.MoveAction;
import com.takyon.battle.game.physics.Ball;
import com.takyon.battle.game.physics.BallPhysics;
import com.takyon.battle.game.pions.PionBattleFactory;
import com.takyon.battle.game.pions.states.StateAttacking;
import com.takyon.battle.game.pions.states.StateHeal;
import com.takyon.battle.game.pions.states.StateHit;
import com.takyon.battle.game.pions.states.StateMoving;
import com.takyon.battle.game.pions.states.StateStand;
import com.takyon.battle.game.statemachine.PionAction;
import com.takyon.battle.game.statemachine.PionState;
import com.takyon.battle.screens.BattleScreenGame;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.utils.Fonts;
import com.takyon.gamelib.DrawableObject;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXImageRegion;
import com.takyon.gamelib.GDXSprite;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.Geometry;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Input;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;
import java.io.Serializable;
import java.util.HashMap;

public class PionBattle
extends DrawableObject
implements Serializable {
    private static final Color LIFE_BLUE = new Color(0.0f, 0.5f, 0.8f, 1.0f);
    private static final Color LIFE_RED = new Color(0.9f, 0.02f, 0.22f, 1.0f);
    private static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    private static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    private static final Color YELLOW = new Color(1.0f, 1.0f, 0.0f, 1.0f);
    private static final Color ORANGE = new Color(1.0f, 0.5f, 0.0f, 1.0f);
    public transient Ball ball;
    public transient PionState state;
    public transient StateMoving stateMoving;
    public transient StateAttacking stateAttacking;
    public transient StateHit stateHit;
    public transient StateHeal stateHeal;
    public transient StateStand stateStand;
    public transient HashMap<PionStateEnum, PionState> states;
    public transient HashMap<PionActionEnum, PionAction> pionActions;
    public transient boolean isHumanOpponent;
    public transient boolean isIA;
    public transient PionController controller;
    public Type type;
    public transient PlayerBattle player;
    public GDXImageRegion image;
    protected float furyCircleSize;
    public Vector2 vecMove;
    public int id;
    public int life;
    public int lifeMax;
    public int radiusInitial;
    public transient GDXText textLife;
    public transient GDXText textLifeChange;
    public transient boolean isHit;
    public transient boolean isStun;
    public transient float distance_parcourue;
    public transient float speed_max;
    public boolean isEvolue;
    public boolean isFury;
    public boolean isDead;
    public transient boolean isThrower;
    public boolean isThrown;
    public boolean isInFire;
    public boolean isBurning;
    public boolean isHealed;
    public int nbBounce;
    public transient ParticleEffect particles;
    private transient float lifeAlpha = 0.0f;
    public transient boolean isFlipped;
    public boolean canFury;
    private boolean hasUseFury;
    public int nbHit;
    private float sensFireAlpha = 1.0f;
    public GDXSprite swordCut;
    private boolean isHitAnimStarted;
    private Vector2 frottements = new Vector2();
    private float time;
    private float fireAlpha;

    public PionBattle() {
    }

    public PionBattle(PlayerBattle player, Type type) {
        this.player = player;
        this.type = type;
        this.vecMove = new Vector2();
        this.setImage();
        this.initStates();
        this.initActions();
        this.ball = new Ball(this);
        this.textLife = new GDXText(Fonts.TEXT);
        this.textLifeChange = new GDXText(Fonts.TEXT_DEGAT);
        this.reset();
        this.updateLife();
        this.particles = new ParticleEffect();
    }

    private void updateLife() {
        this.textLife.setText("" + this.life);
    }

    public int getLife() {
        return this.life;
    }

    public void setLife(int life) {
        this.life = life;
        if (life <= 0) {
            life = 0;
            this.die();
        }
    }

    public void setRadiusInitial(int radius) {
        this.radiusInitial = radius;
        this.ball.setRadius(radius);
    }

    public void perdVie(int vie) {
        this.setLife(this.life - vie);
        if (this.life <= 25) {
            this.canFury = true;
        }
        this.textLifeChange.textStyle = Fonts.TEXT_DEGAT;
        this.textLifeChange.setText("-" + vie);
        this.updateLife();
    }

    public void die() {
        this.isDead = true;
        BattleScreenGame.pionsDie.add((Object)this);
    }

    public int getDamage(int damage) {
        return damage;
    }

    public void gagneVie(int vie) {
        this.life += vie;
        this.isHealed = true;
        this.textLifeChange.textStyle = Fonts.TEXT_GAGNE_VIE;
        this.textLifeChange.setText("+" + vie);
        if (this.life > this.lifeMax) {
            this.life = this.lifeMax;
        }
        this.updateLife();
    }

    public void setImage() {
        this.image = PionBattleFactory.imagesPions[this.type.ordinal()];
    }

    public void addAction(PionAction pionAction) {
        pionAction.pion = this;
        if (this.controller != null) {
            pionAction.input = this.controller.inputConfiguration;
            pionAction.mouseConfig = Input.iControllers.getMouseConfiguration();
        }
        this.pionActions.put(pionAction.getEnum(), pionAction);
    }

    public void addState(PionState state) {
        this.states.put(state.pionStateEnum, state);
    }

    public void initStates() {
        this.states = new HashMap();
        this.stateStand = new StateStand(this, PionStateEnum.STAND);
        this.stateMoving = new StateMoving(this, PionStateEnum.MOVING);
        this.stateAttacking = new StateAttacking(this, PionStateEnum.ATTACKING);
        this.stateHit = new StateHit(this, PionStateEnum.HIT);
        this.stateHeal = new StateHeal(this, PionStateEnum.HEAL);
        this.state = this.stateStand;
    }

    public void initActions() {
        this.pionActions = new HashMap();
        this.addAction(new MoveAction());
    }

    public PionAction getAction(PionActionEnum pionActionEnum) {
        return this.pionActions.get((Object)pionActionEnum);
    }

    public void setState(PionState state) {
        this.state = state;
        state.init();
    }

    public int getHierarchy() {
        return 0;
    }

    public int getValue() {
        return 0;
    }

    public void bounce() {
        ++this.nbBounce;
        if (this.nbBounce > 3) {
            this.nbBounce = 3;
        }
        this.startParticle();
    }

    public void onCollision(PionBattle pion) {
        BallPhysics.Collide(this.ball, pion.ball);
        pion.setState(pion.stateMoving);
    }

    public void onThrow(PionBattle ami) {
        ami.isThrown = true;
        ami.setState(ami.stateAttacking);
    }

    public void onCollisionAmis(PionBattle ami) {
        this.onCollision(ami);
    }

    public void onCollisionEnnemy(PionBattle ennemy) {
        this.onCollision(ennemy);
        if (this.isThrown) {
            this.onHit(ennemy);
        }
    }

    public void onHit(PionBattle ennemy) {
        ennemy.isHit = true;
        ++ennemy.nbHit;
        ennemy.setState(ennemy.stateHit);
        ennemy.isHitAnimStarted = true;
    }

    public void setBurning(boolean isBurning) {
        this.isBurning = isBurning;
    }

    @Override
    public void moveX(float dx) {
        this.ball.position.x += dx;
        this.updateParticles();
        this.textLife.moveX(dx);
    }

    @Override
    public void moveY(float dy) {
        this.ball.position.y += dy;
        this.updateParticles();
        this.textLife.moveY(dy);
    }

    public void logic(float dt) {
        if (this.isBurning) {
            this.fireAlpha += this.sensFireAlpha * dt;
            if (this.fireAlpha > 1.0f) {
                this.fireAlpha = 1.0f;
                this.sensFireAlpha *= -1.0f;
            }
            if (this.fireAlpha < 0.0f) {
                this.fireAlpha = 0.0f;
                this.sensFireAlpha *= -1.0f;
            }
        }
        if (this.isHitAnimStarted) {
            this.swordCut.logic(dt);
            if (this.swordCut.isAnimationFinished()) {
                this.isHitAnimStarted = false;
            }
        }
        if (this.isHit || this.isHealed) {
            this.textLifeChange.setPosition(this.getPosition().x, this.getPosition().y + 140.0f * Scene2D.RATIO);
        }
        if (this.state.pionStateEnum == PionStateEnum.ATTACKING) {
            this.particles.update(dt);
            if (this.particles.isComplete()) {
                this.particles.reset();
            }
        }
        if (this.canFury) {
            this.furyCircleSize += 500.0f * dt;
            if (this.furyCircleSize > 500.0f) {
                this.furyCircleSize = 0.0f;
            }
        }
    }

    @Override
    public Position getPosition() {
        return this.ball.getPosition();
    }

    @Override
    public void setInitialPosition(float x, float y) {
        this.ball.setPosition(x, y);
        this.textLife.setPosition(x, y + 140.0f * Scene2D.RATIO);
    }

    @Override
    public void setPosition(Position position) {
        this.setPosition(position.x, position.y);
    }

    @Override
    public void setPosition(float x, float y) {
        this.ball.setPosition(x, y);
        this.updateParticles();
        this.textLife.setPosition(x, y + 140.0f * Scene2D.RATIO);
    }

    private void updateParticles() {
        Position pos = this.getPositionScale();
        ParticleEmitter emitter = (ParticleEmitter)this.particles.getEmitters().first();
        emitter.setPosition((float)Graphics.decalageX + pos.x, pos.y);
    }

    @Override
    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.player.imageFond.setAlpha(alpha);
        this.image.setAlpha(alpha);
    }

    public void startParticle() {
        if (this.isThrown) {
            Vector2 vAim = new Vector2(this.ball.velocity.x, this.ball.velocity.y);
            vAim.x *= -1.0f;
            float deg = vAim.angle();
            float amp = 30.0f;
            ((ParticleEmitter)this.particles.getEmitters().first()).getAngle().setHigh(deg + amp, deg - amp);
            ((ParticleEmitter)this.particles.getEmitters().first()).getAngle().setLow(deg);
            this.particles.reset();
            this.particles.start();
        }
    }

    public void setVelocity(Vector2 vec) {
        this.ball.velocity.x = vec.x;
        this.ball.velocity.y = vec.y;
        this.startParticle();
    }

    public void setVelocity0(Vector2 vec) {
        this.setVelocity0(vec.x, vec.y);
    }

    public void setVelocity0(float x, float y) {
        this.ball.velocity0.x = x;
        this.ball.velocity0.y = y;
        this.ball.V0 = this.ball.velocity0.len();
        this.startParticle();
    }

    public void reset() {
        this.sensFireAlpha = 1.0f;
        this.fireAlpha = 0.0f;
        this.furyCircleSize = 0.0f;
        this.lifeMax = 100;
        this.nbBounce = 0;
        this.distance_parcourue = 0.0f;
        this.life = this.lifeMax;
        this.isHealed = false;
        this.isHit = false;
        this.isHitAnimStarted = false;
        this.nbHit = 0;
        this.isInFire = false;
        this.isBurning = false;
        this.isThrower = false;
        this.isThrown = false;
        this.canFury = false;
        this.hasUseFury = false;
        this.isDead = false;
        this.isStun = false;
        this.isEvolue = false;
    }

    public void enableCapacity() {
    }

    public void disableCapacity() {
    }

    public void fury() {
        this.hasUseFury = true;
    }

    public void onChangeTurn() {
        this.isInFire = false;
        if (this.isBurning) {
            this.perdVie(10);
            this.isHit = true;
        }
    }

    public void frottements(float dt) {
        Vector2 uv = this.ball.UnitVelocity();
        this.frottements.x = -uv.x * 200.0f;
        this.frottements.y = -uv.y * 200.0f;
        this.ball.addVelocity(this.frottements.x * dt, this.frottements.y * dt);
    }

    public void move(float dt) {
        this.time += dt;
        this.ball.V = this.ball.V0 - 200.0f * this.time;
        Vector2 uv = this.ball.UnitVelocity0();
        this.ball.velocity.x = uv.x * this.ball.V;
        this.ball.velocity.y = uv.y * this.ball.V;
        if (this.ball.V < 0.0f) {
            this.onStop();
            this.setState(this.stateStand);
            return;
        }
    }

    public void onStop() {
        this.time = 0.0f;
        this.ball.velocity.set(0.0f, 0.0f);
        ParticleEmitter emitter = (ParticleEmitter)this.particles.getEmitters().first();
        emitter.setPosition(-2000.0f, -2000.0f);
    }

    public void drawParticles() {
        if (this.isThrown && this.state.pionStateEnum == PionStateEnum.ATTACKING) {
            this.updateParticles();
            this.particles.draw((Batch)GDXImage.batch);
        }
    }

    public boolean hasCollision(Item item) {
        return Geometry.distance(this.getPosition(), item.getPosition()) < this.ball.radius + item.radius;
    }

    public String toString() {
        return this.player + " - " + (Object)((Object)this.type) + " : <" + this.getPosition().x + ", " + this.getPosition().y + ">";
    }

    private void drawLifeCircle(Position pos, float radius, int angleStart, int angleEnd, Color color) {
        double angle = 90.0;
        double step = 10.0;
        float ratio = 0.0f;
        int i = angleStart;
        while (i < angleEnd) {
            double ra = Math.toRadians(angle);
            double ra2 = Math.toRadians(angle + step);
            float cx1 = (float)(Math.cos(ra) * (double)radius);
            float cy1 = (float)(Math.sin(ra) * (double)radius);
            float cx2 = (float)(Math.cos(ra2) * (double)radius);
            float cy2 = (float)(Math.sin(ra2) * (double)radius);
            angle += step;
            Graphics.shapeRenderer.setColor(color.r, color.g, color.b, 1.0f);
            Graphics.shapeRenderer.triangle(pos.x + cx1, pos.y + cy1, pos.x + cx2, pos.y + cy2, pos.x, pos.y);
            i = (int)((double)i + step);
        }
    }

    public void drawLife(Position pos, float radius) {
        float lifeRatio = (float)this.life / (float)this.lifeMax;
        float rad = radius;
        if (this.player.lifeDisplayCircle) {
            int angleEnd = (int)(lifeRatio * 360.0f);
            Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            if (this.player.color == PlayerColor.WHITE) {
                this.drawLifeCircle(pos, rad, 0, angleEnd, LIFE_BLUE);
            } else if (this.player.color == PlayerColor.BLACK) {
                this.drawLifeCircle(pos, rad, 0, angleEnd, LIFE_RED);
            }
            Graphics.shapeRenderer.end();
            if (this.player.color == PlayerColor.WHITE) {
                Graphics.shapeRenderer.setColor(0.09f, 0.27f, 0.41f, 1.0f);
            } else if (this.player.color == PlayerColor.BLACK) {
                Graphics.shapeRenderer.setColor(0.41f, 0.09f, 0.15f, 1.0f);
            }
            Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            Graphics.shapeRenderer.circle(pos.x, pos.y, rad);
            if (this.life < this.lifeMax) {
                float cx = (float)(Math.cos(Math.toRadians(angleEnd + 90)) * (double)rad);
                float cy = (float)(Math.sin(Math.toRadians(angleEnd + 90)) * (double)rad);
                Graphics.shapeRenderer.line(pos.x, pos.y, pos.x, pos.y + rad);
                Graphics.shapeRenderer.line(pos.x, pos.y, pos.x + cx, pos.y + cy);
            }
            Graphics.shapeRenderer.end();
        } else {
            float paddingX = -80.0f * Scene2D.RATIO;
            float paddingY = -100.0f * Scene2D.RATIO;
            float width = 140.0f * Scene2D.RATIO;
            float height = 25.0f * Scene2D.RATIO;
            this.updateLifeColor(lifeRatio);
            Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
            Graphics.shapeRenderer.rect(pos.x + paddingX, pos.y + paddingY, lifeRatio * width, height);
            Graphics.shapeRenderer.end();
            Gdx.gl.glLineWidth(2.0f);
            Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Line);
            Graphics.shapeRenderer.setColor(0.0f, 0.0f, 0.0f, 1.0f);
            Graphics.shapeRenderer.rect(pos.x + paddingX, pos.y + paddingY, width, height);
            Graphics.shapeRenderer.end();
            Gdx.gl.glLineWidth(1.0f);
        }
    }

    private Color updateLifeColor(float lifeRatio) {
        Color color = null;
        this.lifeAlpha = 1.0f;
        color = lifeRatio > 0.75f ? GREEN : (lifeRatio > 0.5f ? YELLOW : (lifeRatio > 0.25f ? ORANGE : RED));
        Graphics.shapeRenderer.setColor(color);
        return color;
    }

    @Override
    public void draw() {
        if (this.isVisible()) {
            Position position = this.getPositionScale();
            float radius = this.ball.radius * Scene2D.RATIO;
            if (this.isFlipped) {
                Graphics.drawFlippedY(this.player.imageFond, position.x, position.y, (this.ball.radius - 10.0f) * 2.0f, (this.ball.radius - 10.0f) * 2.0f, 0.0f);
            } else {
                Graphics.drawCentered(this.player.imageFond, position.x, position.y, (this.ball.radius - 10.0f) * 2.0f, (this.ball.radius - 10.0f) * 2.0f);
            }
            if (this.isFlipped) {
                Graphics.drawFlippedY(this.image, position.x, position.y, (this.ball.radius - 10.0f) * 2.0f, (this.ball.radius - 10.0f) * 2.0f, 0.0f);
            } else {
                Graphics.drawCentered(this.image, position.x, position.y, (this.ball.radius - 10.0f) * 2.0f, (this.ball.radius - 10.0f) * 2.0f);
            }
            if (this.isBurning) {
                PionBattleFactory.imageBurning.setAlpha(this.fireAlpha);
                if (this.isFlipped) {
                    Graphics.drawFlippedY(PionBattleFactory.imageBurning, position.x, position.y, this.ball.radius * 2.0f, this.ball.radius * 2.0f, 0.0f);
                } else {
                    Graphics.drawCentered(PionBattleFactory.imageBurning, position.x, position.y, this.ball.radius * 2.0f, this.ball.radius * 2.0f);
                }
            }
            if (this.isEvolue) {
                PionBattleFactory.imageEtoile.draw(position.x - radius, position.y - radius, this.ball.radius * 2.0f, this.ball.radius * 2.0f);
            }
            if (this.canFury && !this.hasUseFury) {
                Graphics.drawCentered(PionBattleFactory.effectFury, this.positionScaled.x, this.positionScaled.y, this.furyCircleSize, this.furyCircleSize);
            }
        }
    }

    public void drawHud(Position pos, float radius) {
        GDXImage.batch.begin();
        if (this.isHitAnimStarted && this.swordCut.currentFrame != null) {
            Position position = this.getPositionScale();
            if (this.isFlipped) {
                Graphics.drawFlippedY(this.swordCut.currentFrame, position.x, position.y, this.ball.radius * 4.0f, this.ball.radius * 4.0f, 0.0f);
            } else {
                Graphics.drawCentered(this.swordCut.currentFrame, position.x, position.y, this.ball.radius * 4.0f, this.ball.radius * 4.0f);
            }
        }
        if (this.isHit || this.isHealed) {
            this.textLifeChange.draw();
        }
        GDXImage.batch.end();
    }

    public void attack(Vector2 aim) {
        aim.limit(this.speed_max);
        float fac = aim.len() / (this.ball.radius * 6.0f);
        if (fac > 1.0f) {
            fac = 1.0f;
        }
        aim.nor();
        aim.scl(this.speed_max * fac);
        this.setVelocity0(aim);
        this.setState(this.stateAttacking);
    }

    public boolean canThrow(PionBattle ami) {
        return this.getHierarchy() >= ami.getHierarchy();
    }

    public boolean canUseFury() {
        return this.canFury && !this.hasUseFury;
    }

    public static enum PionActionEnum {
        COOLIDE,
        ATTACK;

    }

    public static enum PionStateEnum {
        STAND,
        MOVING,
        ATTACKING,
        HIT,
        HEAL;

    }

    public static enum Type {
        OEUF,
        ROI,
        FEU,
        EAU,
        AIR,
        TERRE;

    }
}

