/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.game.pions.states;

import com.badlogic.gdx.math.Vector2;
import com.takyon.battle.BattleGame;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.physics.BallPhysics;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.statemachine.PionState;

public class StateMoving
extends PionState {
    public StateMoving(PionBattle pion, PionBattle.PionStateEnum pionStateEnum) {
        super(pion, pionStateEnum);
    }

    @Override
    public void init() {
    }

    @Override
    public void initActions() {
    }

    @Override
    public void logic(float dt) {
        super.logic(dt);
        this.pion.move(dt);
        float dx = this.pion.ball.velocity.x * dt;
        float dy = this.pion.ball.velocity.y * dt;
        this.checkMove(dx, dy);
        BattleGame.arena.CheckWallBounce(this.pion.ball, dx, dy);
    }

    public void checkMove(float dx, float dy) {
        if (this.pion.isFury && this.pion.type == PionBattle.Type.FEU) {
            this.checkCollisionPionsEnnemy(dx, dy);
            this.pion.moveX(dx);
            this.pion.moveY(dy);
        } else if (!this.checkCollision(dx, dy)) {
            this.pion.moveX(dx);
            this.pion.moveY(dy);
        }
    }

    private void chekAttraction(float dt, float dx, float dy) {
        PlayerBattle player = this.pion.player;
        Vector2 vec = new Vector2();
        float speed = 150.0f;
        int i = 0;
        while (i < player.pions.size) {
            PionBattle otherPion = (PionBattle)player.pions.get(i);
            if (otherPion.type == PionBattle.Type.TERRE && this.pion.id != otherPion.id && BallPhysics.distance(this.pion.ball, otherPion.ball) < (double)(otherPion.ball.radius * 5.0f)) {
                vec.set(otherPion.getPosition().x - this.pion.getPosition().x, otherPion.getPosition().y - this.pion.getPosition().y);
                vec.set(vec.x / vec.len(), vec.y / vec.len());
                this.pion.ball.addVelocity(vec.x * speed * dt, vec.y * speed * dt);
            }
            ++i;
        }
        PlayerBattle ennemy = BattleGame.getEnnemy(player);
        int i2 = 0;
        while (i2 < ennemy.pions.size) {
            PionBattle otherPion = (PionBattle)ennemy.pions.get(i2);
            if (otherPion.type == PionBattle.Type.TERRE && BallPhysics.distance(this.pion.ball, otherPion.ball) < (double)(otherPion.ball.radius * 5.0f)) {
                vec.set(otherPion.getPosition().x - this.pion.getPosition().x, otherPion.getPosition().y - this.pion.getPosition().y);
                vec.set(vec.x / vec.len(), vec.y / vec.len());
                this.pion.ball.addVelocity(vec.x * speed * dt, vec.y * speed * dt);
            }
            ++i2;
        }
    }

    public void onCollision(PionBattle pion) {
        this.pion.onCollision(pion);
    }

    public void onCollisionAmis(PionBattle pion) {
        this.onCollision(pion);
    }

    public void onCollisionEnnemy(PionBattle pion) {
        this.onCollision(pion);
    }

    public boolean checkCollision(float dx, float dy) {
        boolean hasCollisionAmis = this.checkCollisionPionsAmis(dx, dy);
        boolean hasCollisionEnnemis = this.checkCollisionPionsEnnemy(dx, dy);
        return hasCollisionAmis || hasCollisionEnnemis;
    }

    public boolean checkCollisionPionsAmis(float dx, float dy) {
        PlayerBattle player = this.pion.player;
        int i = 0;
        while (i < player.pions.size) {
            PionBattle otherPion = (PionBattle)player.pions.get(i);
            if (this.pion.id != otherPion.id && BallPhysics.isCollision(this.pion.ball, otherPion.ball, dx, dy)) {
                this.onCollisionAmis(otherPion);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean checkCollisionPionsEnnemy(float dx, float dy) {
        PlayerBattle ennemy = BattleGame.getEnnemy(this.pion.player);
        int i = 0;
        while (i < ennemy.pions.size) {
            PionBattle otherPion = (PionBattle)ennemy.pions.get(i);
            if (BallPhysics.isCollision(this.pion.ball, otherPion.ball, dx, dy)) {
                this.onCollisionEnnemy(otherPion);
                return true;
            }
            ++i;
        }
        return false;
    }
}

