/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.screens;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import com.takyon.battle.BattleGame;
import com.takyon.battle.game.Item;
import com.takyon.battle.game.PlayerBattle;
import com.takyon.battle.game.TestPlacements;
import com.takyon.battle.game.ia.BattleIA;
import com.takyon.battle.game.physics.BallPhysics;
import com.takyon.battle.game.pions.FeuBattle;
import com.takyon.battle.game.pions.PionBattle;
import com.takyon.battle.game.pions.PionBattleFactory;
import com.takyon.battle.network.messages.game.CoupMessage;
import com.takyon.battle.network.messages.game.RefreshStateMessage;
import com.takyon.battle.screens.BattleGameScreen;
import com.takyon.chess.game.PlayerColor;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXDialog;
import com.takyon.gamelib.GDXGameNet;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXImageRegion;
import com.takyon.gamelib.GDXToggleButton;
import com.takyon.gamelib.GameScreen;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Language;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;
import java.util.ArrayList;

public class BattleScreenGame
extends BattleGameScreen {
    protected GDXImage decor;
    protected GDXImage fond_menu_1;
    protected static GDXToggleButton btnCombo_1;
    protected static GDXToggleButton btnInvertAim_1;
    protected static GDXButton btnReplay_1;
    protected static GDXToggleButton btnUseCapacity_1;
    protected static GDXToggleButton btnUseFury_1;
    protected GDXImage fond_menu_2;
    protected static GDXToggleButton btnCombo_2;
    protected static GDXToggleButton btnInvertAim_2;
    protected static GDXToggleButton btnUseCapacity_2;
    protected static GDXButton btnReplay_2;
    protected static GDXToggleButton btnUseFury_2;
    protected static GDXImage imagePlacing;
    public static PionBattle lastPion;
    public static Selection[] selections;
    public static int currentIndex;
    public static PlayerBattle currentPlayer;
    public static Array<PionBattle> pionsDie;
    protected static boolean isPlacing;
    public PionBattle.Type currentType;
    protected boolean isActionDelete;
    public static boolean isPlaying;
    public static boolean isDisplayLife;
    protected Array<PionBattle> allPions;
    public static Array<Item> golds;
    public static OrthographicCamera camera;
    protected static boolean isWin;
    protected static PlayerColor winnerColor;
    private static boolean isMovePossible;
    protected GDXImage imageWinBlue;
    protected GDXImage imageWinRed;
    protected static boolean isAimForward;
    protected GDXImage[] images_blocs_1;
    protected GDXImage[] images_blocs_2;
    private GDXDialog quitDialog;
    private float textDisplayTimer;
    private static boolean hasDisplayedTexts;
    protected static TextureRegion[] arrows;
    public static ParticleEffect volcano;
    public static RefreshStateMessage lastRefreshState;
    public static ArrayList<CoupMessage> lastCoups;
    public static Music bgm_main;

    @Override
    public void firstInit() {
        this.decor = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/decors/decor_terre.png");
        arrows = new TextureRegion[3];
        int i = 0;
        while (i < 3) {
            BattleScreenGame.arrows[i] = new TextureRegion(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/interface/fleche" + i + ".png"));
            ++i;
        }
        bgm_main = Gdx.audio.newMusic(Gdx.files.internal(String.valueOf(BattleGame.KIT_DIRECTORY) + "/sons/main_theme.mp3"));
        this.fond_menu_1 = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/interface/fond_menu_blue.png");
        Graphics.setPosition(this.fond_menu_1, 1770.0f, 0.0f);
        btnCombo_1 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/combo_off.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/combo_on.png"));
        Graphics.setPosition(btnCombo_1, 1781.0f, 50.0f);
        btnInvertAim_1 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/invert_aim_up.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/invert_aim_down.png"));
        Graphics.setPosition(btnInvertAim_1, 1781.0f, 250.0f);
        btnReplay_1 = new GDXButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/replay", true, false, false);
        Graphics.setPosition(btnReplay_1, 1781.0f, 450.0f);
        btnUseCapacity_1 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_capacity_off.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_capacity_on.png"));
        Graphics.setPosition(btnUseCapacity_1, 1781.0f, 700.0f);
        btnUseFury_1 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_fury_off.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_fury_on.png"));
        Graphics.setPosition(btnUseFury_1, 1781.0f, 898.0f);
        this.fond_menu_2 = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/interface/fond_menu_red.png");
        Graphics.setPosition(this.fond_menu_2, 0.0f, 0.0f);
        btnReplay_2 = new GDXButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/replay", true, false, false);
        Graphics.setPosition(btnReplay_2, 11.0f, 450.0f);
        btnCombo_2 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/combo_off.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/combo_on.png"));
        Graphics.setPosition(btnCombo_2, 11.0f, 50.0f);
        btnInvertAim_2 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/invert_aim_down.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/invert_aim_up.png"));
        Graphics.setPosition(btnInvertAim_2, 11.0f, 250.0f);
        btnUseCapacity_2 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_capacity_off.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_capacity_on.png"));
        Graphics.setPosition(btnUseCapacity_2, 11.0f, 700.0f);
        btnUseFury_2 = new GDXToggleButton(new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_fury_off.png"), new Texture(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/use_fury_on.png"));
        Graphics.setPosition(btnUseFury_2, 11.0f, 898.0f);
        this.imageWinBlue = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/interface/win_blue.png");
        Graphics.setPosition(this.imageWinBlue, 644.0f, 142.0f);
        this.imageWinRed = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/interface/win_red.png");
        Graphics.setPosition(this.imageWinRed, 644.0f, 142.0f);
        PionBattleFactory.initImages();
        PionBattleFactory.initSounds();
        imagePlacing = new GDXImage();
        BattleGame.playerRed = new PlayerBattle(PlayerColor.BLACK);
        BattleGame.playerBlue = new PlayerBattle(PlayerColor.WHITE);
        BattleGame.playerRed.imageFond = new GDXImageRegion((TextureRegion)PionBattleFactory.atlasPions.findRegion("fond_pion_black2"));
        BattleGame.playerBlue.imageFond = new GDXImageRegion((TextureRegion)PionBattleFactory.atlasPions.findRegion("fond_pion_white2"));
        pionsDie = new Array();
        selections = new Selection[3];
        i = 0;
        while (i < selections.length) {
            BattleScreenGame.selections[i] = new Selection();
            ++i;
        }
        camera = new OrthographicCamera();
        Graphics.shapeRenderer = new ShapeRenderer();
        this.quitDialog = new GDXDialog(){

            @Override
            public void onYes() {
                BattleScreenGame.changeScreen(screenIntro);
            }
        };
        volcano = new ParticleEffect();
        volcano.load(Gdx.files.internal("kit_battle/images/particles/volcano.fx"), Gdx.files.internal("kit_battle/images/particles"));
        ((ParticleEmitter)volcano.getEmitters().first()).setPosition((float)(Graphics.decalageX + 50), 150.0f);
        volcano.reset();
        volcano.start();
        lastCoups = new ArrayList();
    }

    @Override
    public void init() {
        hasDisplayedTexts = false;
        this.textDisplayTimer = 0.0f;
        isPlacing = true;
        isWin = false;
        isDisplayLife = true;
        currentIndex = 0;
        isAimForward = true;
        currentPlayer = BattleGame.playerBlue;
        BattleGame.playerRed.init();
        BattleGame.playerBlue.init();
        BattleGame.playerRed.pions.clear();
        BattleGame.playerBlue.pions.clear();
        this.allPions = new Array();
        TestPlacements.initTest3Terres();
        for (PionBattle pion : BattleGame.playerBlue.pions) {
            this.allPions.add((Object)pion);
        }
        for (PionBattle pion : BattleGame.playerRed.pions) {
            this.allPions.add((Object)pion);
        }
        isPlacing = false;
        BattleIA.IAPlayer = BattleGame.playerRed;
        BattleIA.HumanPlayer = BattleGame.playerBlue;
    }

    protected void setCurrentType(PionBattle.Type type) {
        this.currentType = type;
        this.isActionDelete = false;
    }

    @Override
    public void onBackPressed() {
        super.onBackPressed();
        this.quitDialog.show(Language.tr("quit.game"), Language.tr(""));
    }

    @Override
    public void onTouchDown(int x, int y, int pointer, int button) {
        if (BattleGame.isNetwork && GDXGameNet.playerNet.isWaiting) {
            return;
        }
        super.onTouchDown(x, y, pointer, button);
        if (!isPlacing && !isPlaying) {
            for (PionBattle pion : BattleScreenGame.currentPlayer.pions) {
                if (!this.isClicked(pion, x, y) || pion.isStun) continue;
                if (!BattleScreenGame.currentPlayer.isUsingCombo) {
                    BattleScreenGame.selections[0].pion = pion;
                    break;
                }
                if (BattleScreenGame.selections[0].pion != null) {
                    BattleScreenGame.selections[1].pion = pion;
                    break;
                }
                BattleScreenGame.selections[0].pion = pion;
                break;
            }
        }
    }

    private void checkAim(Selection selection, int x, int y) {
        if (!isPlaying && selection.pion != null) {
            selection.endPoint.set((float)x, (float)y);
            selection.startPoint.set(selection.pion.getPosition().x, selection.pion.getPosition().y);
            selection.aim.x = selection.endPoint.x - selection.startPoint.x;
            selection.aim.y = selection.endPoint.y - selection.startPoint.y;
            isMovePossible = !this.hasCollisionPionsAmis(selection.pion, selection.endPoint);
        }
    }

    @Override
    public void mouseDragged(int x, int y, int pointer) {
        if (BattleGame.isNetwork && GDXGameNet.playerNet.isWaiting) {
            return;
        }
        if (y > 150 && y < 1770) {
            if (isPlacing) {
                imagePlacing.setVisible(true);
                imagePlacing.setPosition(x - 64, y - 64);
            } else if (!BattleScreenGame.currentPlayer.isUsingCombo) {
                Selection selection = selections[0];
                if (selection.pion != null) {
                    this.checkAim(selection, x, y);
                }
            } else if (BattleScreenGame.selections[0].isAimed) {
                this.checkAim(selections[1], x, y);
            } else {
                this.checkAim(selections[0], x, y);
            }
        }
    }

    @Override
    public void fling(float velocityX, float velocityY, int button) {
    }

    private void onPlace(int x, int y) {
        if (this.isActionDelete) {
            this.deletePion(x, y);
        } else if (this.currentType != null) {
            this.placePion(x, y);
        }
    }

    private void saveState() {
        if (BattleGame.isDebug) {
            lastRefreshState = new RefreshStateMessage();
        }
    }

    @Override
    public void onTouched(int x, int y, int pointer, int button) {
        if (this.quitDialog.isVisible()) {
            this.quitDialog.onTouchDown(x, y);
        } else {
            if (BattleGame.isNetwork && GDXGameNet.playerNet.isWaiting) {
                return;
            }
            if (isPlacing) {
                this.onPlace(x, y);
            } else if (isWin) {
                this.reset();
            } else if (!isPlaying) {
                if (y < 150 || y > 1770) {
                    this.onMenuClick(x, y);
                } else {
                    try {
                        if (!BattleScreenGame.currentPlayer.isUsingCombo) {
                            this.attack(selections[0]);
                        } else {
                            if (BattleScreenGame.selections[0].pion != null && BattleScreenGame.selections[0].aim.len() > BattleScreenGame.selections[0].pion.ball.radius) {
                                BattleScreenGame.selections[0].isAimed = true;
                            }
                            if (BattleScreenGame.selections[1].pion != null && BattleScreenGame.selections[1].aim.len() > BattleScreenGame.selections[1].pion.ball.radius) {
                                BattleScreenGame.selections[1].isAimed = true;
                            }
                            if (BattleScreenGame.selections[0].pion != null && BattleScreenGame.selections[1].pion != null && BattleScreenGame.selections[0].isAimed && BattleScreenGame.selections[1].isAimed) {
                                this.attack(selections[0]);
                                this.attack(selections[1]);
                            }
                        }
                    }
                    catch (NullPointerException e) {
                        e.printStackTrace();
                    }
                    if (BattleScreenGame.selections[0].pion != null) {
                        BattleScreenGame.selections[0].pion.isThrower = true;
                    }
                    if (BattleScreenGame.selections[1].pion != null) {
                        BattleScreenGame.selections[1].pion.isThrower = true;
                    }
                    if (BattleGame.isDebug) {
                        if (BattleScreenGame.selections[0].pion != null) {
                            lastCoups.add(new CoupMessage(BattleScreenGame.selections[0].pion.player.color, BattleScreenGame.selections[0].pion.id, BattleScreenGame.selections[0].aim));
                        } else {
                            lastCoups.add(null);
                        }
                        if (BattleScreenGame.selections[1].pion != null) {
                            lastCoups.add(new CoupMessage(BattleScreenGame.selections[1].pion.player.color, BattleScreenGame.selections[1].pion.id, BattleScreenGame.selections[1].aim));
                        } else {
                            lastCoups.add(null);
                        }
                    }
                }
            }
        }
    }

    private void onMenuClick(int x, int y) {
        if (currentPlayer == BattleGame.playerBlue) {
            if (btnInvertAim_1.isClicked(x, y)) {
                isAimForward = !isAimForward;
                return;
            }
            if (btnCombo_1.isClicked(x, y)) {
                BattleScreenGame.currentPlayer.isUsingCombo = !BattleScreenGame.currentPlayer.isUsingCombo;
                return;
            }
            if (btnUseFury_1.isClicked(x, y)) {
                int i = 0;
                while (i < selections.length) {
                    Selection selection = selections[i];
                    if (selection.pion != null && selection.pion.canUseFury()) {
                        selection.pion.isFury = BattleScreenGame.btnUseFury_1.isToggled;
                    }
                    ++i;
                }
                return;
            }
        } else if (currentPlayer == BattleGame.playerRed) {
            if (btnInvertAim_2.isClicked(x, y)) {
                isAimForward = !isAimForward;
                return;
            }
            if (btnCombo_2.isClicked(x, y)) {
                BattleScreenGame.currentPlayer.isUsingCombo = !BattleScreenGame.currentPlayer.isUsingCombo;
                return;
            }
            if (btnUseFury_2.isClicked(x, y)) {
                int i = 0;
                while (i < selections.length) {
                    Selection selection = selections[i];
                    if (selection.pion != null && selection.pion.canUseFury()) {
                        selection.pion.isFury = BattleScreenGame.btnUseFury_2.isToggled;
                    }
                    ++i;
                }
                return;
            }
        }
    }

    private int getNbSelectedPions() {
        int result = 0;
        int i = 0;
        while (i < selections.length) {
            Selection selection = selections[i];
            if (selection.pion != null) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private void attack(Selection selection) {
        if (selection.pion != null) {
            selection.aim.x = selection.endPoint.x - selection.startPoint.x;
            selection.aim.y = selection.endPoint.y - selection.startPoint.y;
            if (!BattleScreenGame.isAimForward()) {
                selection.aim.scl(-1.0f);
            }
            selection.isAimed = false;
            if (BattleGame.isNetwork) {
                GDXGameNet.clientToServer.sendToOpponent(new CoupMessage(selection.pion.player.color, selection.pion.id, selection.aim));
            }
            this.attack(selection.pion, selection.aim);
        }
    }

    private boolean hasCollisionPionsAmis(PionBattle selectedPion, Vector2 endPoint) {
        PlayerBattle player = selectedPion.player;
        for (PionBattle pion : player.pions) {
            if (!BallPhysics.isCollision(endPoint.x, endPoint.y, selectedPion.ball.radius, pion.ball)) continue;
            return true;
        }
        return false;
    }

    public void attack(PionBattle pion, Vector2 aim) {
        if (aim.len() > pion.ball.radius) {
            pion.attack(aim);
            isPlaying = true;
            this.saveState();
        }
    }

    private void reset() {
        BattleGame.playerRed.reset();
        BattleGame.playerBlue.reset();
        this.init();
    }

    private void deletePion(int x, int y) {
    }

    public static void checkTurn() {
        BattleScreenGame.currentPlayer.isUsingCombo = false;
        btnCombo_1.setToggled(false);
        btnCombo_2.setToggled(false);
        isAimForward = true;
        btnInvertAim_1.setToggled(false);
        btnInvertAim_2.setToggled(false);
        btnUseCapacity_1.setToggled(false);
        btnUseCapacity_2.setToggled(false);
        btnUseFury_1.setToggled(false);
        btnUseFury_2.setToggled(false);
        hasDisplayedTexts = false;
        int i = 0;
        while (i < BattleScreenGame.currentPlayer.pions.size) {
            PionBattle pion = (PionBattle)BattleScreenGame.currentPlayer.pions.get(i);
            pion.isFury = false;
            pion.isHit = false;
            pion.nbHit = 0;
            pion.isHealed = false;
            ++i;
        }
        BattleScreenGame.checkDies();
        BattleScreenGame.changeTurn();
        i = 0;
        while (i < selections.length) {
            selections[i].reset();
            ++i;
        }
        if (BattleGame.isNetwork) {
            if (!GDXGameNet.playerNet.isWaiting) {
                GDXGameNet.clientToServer.sendToOpponent(new RefreshStateMessage());
            }
            GDXGameNet.playerNet.isWaiting = false;
        }
    }

    private static void checkDies() {
        if (BattleScreenGame.pionsDie.size > 0) {
            int i = 0;
            while (i < BattleScreenGame.pionsDie.size) {
                PionBattle pion = (PionBattle)pionsDie.get(i);
                if (pion.type == PionBattle.Type.ROI) {
                    isWin = true;
                    winnerColor = BattleGame.getEnnemy((PlayerBattle)pion.player).color;
                    return;
                }
                pion.player.pions.removeValue((Object)pion, true);
                ++i;
            }
        }
        pionsDie.clear();
        if (BattleGame.playerBlue.pions.size == 1) {
            PionBattle pion = (PionBattle)BattleGame.playerBlue.pions.get(0);
            if (pion.type == PionBattle.Type.ROI) {
                isWin = true;
                winnerColor = BattleGame.playerRed.color;
                return;
            }
        }
        if (BattleGame.playerRed.pions.size == 1) {
            PionBattle pion = (PionBattle)BattleGame.playerRed.pions.get(0);
            if (pion.type == PionBattle.Type.ROI) {
                isWin = true;
                winnerColor = BattleGame.playerBlue.color;
                return;
            }
        }
    }

    private static void switchPlayer() {
        int i = 0;
        while (i < BattleScreenGame.currentPlayer.pions.size) {
            PionBattle pion = (PionBattle)BattleScreenGame.currentPlayer.pions.get(i);
            pion.isStun = false;
            pion.onChangeTurn();
            ++i;
        }
        if (BattleScreenGame.currentPlayer.color == PlayerColor.WHITE) {
            currentPlayer = BattleGame.playerRed;
        } else if (BattleScreenGame.currentPlayer.color == PlayerColor.BLACK) {
            currentPlayer = BattleGame.playerBlue;
        }
    }

    private static void resetPlayerTurn(PlayerBattle player) {
        int i = 0;
        while (i < player.pions.size) {
            PionBattle pion = (PionBattle)player.pions.get(i);
            pion.isThrown = false;
            pion.isThrower = false;
            if (Gdx.app.getType() == Application.ApplicationType.Android && !BattleGame.isNetwork && !BattleGame.isIA) {
                pion.isFlipped = !pion.isFlipped;
            }
            ++i;
        }
    }

    public void replay() {
        CoupMessage coup2;
        CoupMessage coup1;
        currentPlayer = BattleGame.getEnnemy(currentPlayer);
        if (lastRefreshState != null) {
            lastRefreshState.execute();
        }
        if ((coup1 = lastCoups.get(lastCoups.size() - 1)) != null) {
            coup1.execute();
        }
        if ((coup2 = lastCoups.get(lastCoups.size() - 2)) != null) {
            coup2.execute();
        }
    }

    public static void changeTurn() {
        BattleScreenGame.resetPlayerTurn(BattleGame.playerBlue);
        BattleScreenGame.resetPlayerTurn(BattleGame.playerRed);
        BattleScreenGame.switchPlayer();
        if (!isPlacing && BattleGame.isIA && BattleScreenGame.currentPlayer.color == PlayerColor.BLACK) {
            BattleIA.playIA();
        }
    }

    protected void placePion(int x, int y) {
        boolean canPlacePion = false;
    }

    private boolean isClicked(PionBattle pion, int x, int y) {
        Vector2 vec = new Vector2((float)x - pion.getPosition().x, (float)y - pion.getPosition().y);
        return vec.len() < pion.ball.radius;
    }

    @Override
    public void finish() {
    }

    @Override
    public void process(float dt) {
        PionBattle pion;
        int i = 0;
        while (i < BattleGame.playerBlue.pions.size) {
            pion = (PionBattle)BattleGame.playerBlue.pions.get(i);
            pion.logic(dt);
            ++i;
        }
        i = 0;
        while (i < BattleGame.playerRed.pions.size) {
            pion = (PionBattle)BattleGame.playerRed.pions.get(i);
            pion.logic(dt);
            ++i;
        }
        if (!isPlacing) {
            if (isPlaying) {
                PionBattle pion2;
                BattleGame.playerRed.logic(dt);
                BattleGame.playerBlue.logic(dt);
                boolean isAllMoved = true;
                int i2 = 0;
                while (i2 < BattleGame.playerBlue.pions.size) {
                    pion2 = (PionBattle)BattleGame.playerBlue.pions.get(i2);
                    if (pion2.state.pionStateEnum != PionBattle.PionStateEnum.STAND) {
                        isAllMoved = false;
                        break;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < BattleGame.playerRed.pions.size) {
                    pion2 = (PionBattle)BattleGame.playerRed.pions.get(i2);
                    if (pion2.state.pionStateEnum != PionBattle.PionStateEnum.STAND) {
                        isAllMoved = false;
                        break;
                    }
                    ++i2;
                }
                if (BattleScreenGame.selections[0].pion != null && BattleScreenGame.selections[0].pion.isFury) {
                    return;
                }
                if (isAllMoved) {
                    isPlaying = false;
                    BattleScreenGame.checkTurn();
                }
            } else if (!hasDisplayedTexts) {
                this.textDisplayTimer += dt;
                if (this.textDisplayTimer > 2.0f) {
                    this.textDisplayTimer = 0.0f;
                    hasDisplayedTexts = true;
                    i = 0;
                    while (i < BattleGame.playerBlue.pions.size) {
                        pion = (PionBattle)BattleGame.playerBlue.pions.get(i);
                        pion.isFury = false;
                        pion.isHit = false;
                        pion.nbHit = 0;
                        pion.isHealed = false;
                        ++i;
                    }
                    i = 0;
                    while (i < BattleGame.playerRed.pions.size) {
                        pion = (PionBattle)BattleGame.playerRed.pions.get(i);
                        pion.isFury = false;
                        pion.isHit = false;
                        pion.nbHit = 0;
                        pion.isHealed = false;
                        ++i;
                    }
                }
            }
        }
        if (Gdx.app.getType() == Application.ApplicationType.Desktop && Gdx.input.isKeyPressed(131)) {
            this.onBackPressed();
        }
    }

    public static void drawParticles() {
        PionBattle pion;
        int i = 0;
        while (i < BattleGame.playerBlue.pions.size) {
            pion = (PionBattle)BattleGame.playerBlue.pions.get(i);
            pion.drawParticles();
            ++i;
        }
        i = 0;
        while (i < BattleGame.playerRed.pions.size) {
            pion = (PionBattle)BattleGame.playerRed.pions.get(i);
            pion.drawParticles();
            ++i;
        }
    }

    @Override
    public void display() {
        PionBattle pion;
        int i;
        GDXImage.batch.begin();
        this.decor.draw();
        GDXImage.batch.end();
        BattleGame.playerRed.drawHudBack();
        BattleGame.playerBlue.drawHudBack();
        if (!isPlaying) {
            i = 0;
            while (i < selections.length) {
                Selection selection = selections[i];
                if (selection.pion != null) {
                    this.drawSelection(selection);
                }
                ++i;
            }
        }
        GDXImage.batch.begin();
        if (GameScreen.currentScreen == screenGame || GameScreen.currentScreen == screenTutorialLiveScreenGame) {
            GDXImage.batch.draw(Graphics.particleRegion, 0.0f, 0.0f, 0.0f, 0.0f, (float)Gdx.app.getGraphics().getWidth(), (float)Gdx.app.getGraphics().getHeight(), 1.0f, 1.0f, 0.0f);
        }
        if (isPlacing && BattleScreenGame.imagePlacing.texture != null && imagePlacing.isVisible()) {
            imagePlacing.draw();
        }
        if (BattleGame.isNetwork) {
            if (GDXGameNet.playerNet.isHote && currentPlayer == BattleGame.playerBlue) {
                this.drawMenu();
            } else if (!GDXGameNet.playerNet.isHote && currentPlayer == BattleGame.playerRed) {
                this.drawMenu();
            }
        } else {
            this.drawMenu();
        }
        i = 0;
        while (i < BattleGame.playerBlue.pions.size) {
            pion = (PionBattle)BattleGame.playerBlue.pions.get(i);
            pion.draw();
            ++i;
        }
        i = 0;
        while (i < BattleGame.playerRed.pions.size) {
            pion = (PionBattle)BattleGame.playerRed.pions.get(i);
            pion.draw();
            ++i;
        }
        if (isWin) {
            if (winnerColor == PlayerColor.BLACK) {
                this.imageWinRed.draw();
            } else if (winnerColor == PlayerColor.WHITE) {
                this.imageWinBlue.draw();
            }
        }
        this.quitDialog.display();
        GDXImage.batch.end();
    }

    private void drawMenu() {
        if (currentPlayer == BattleGame.playerBlue) {
            GDXImage.draw(this.fond_menu_1.texture, 0.0f, 0.0f, 1080.0f * Scene2D.RATIO, 150.0f * Scene2D.RATIO);
            BattleScreenGame.currentPlayer.imageFond.draw(BattleScreenGame.btnInvertAim_1.positionScaled.x, BattleScreenGame.btnInvertAim_1.positionScaled.y, 128.0f, 128.0f);
            btnInvertAim_1.draw();
            BattleScreenGame.currentPlayer.imageFond.draw(BattleScreenGame.btnCombo_1.positionScaled.x, BattleScreenGame.btnCombo_1.positionScaled.y, 128.0f, 128.0f);
            btnCombo_1.draw();
            BattleScreenGame.currentPlayer.imageFond.draw(BattleScreenGame.btnUseFury_1.positionScaled.x, BattleScreenGame.btnUseFury_1.positionScaled.y, 128.0f, 128.0f);
            btnUseFury_1.draw();
        } else if (currentPlayer == BattleGame.playerRed) {
            GDXImage.draw(this.fond_menu_2.texture, 0.0f, 1770.0f * Scene2D.RATIO, 1080.0f * Scene2D.RATIO, 150.0f * Scene2D.RATIO);
            BattleScreenGame.currentPlayer.imageFond.draw(BattleScreenGame.btnInvertAim_2.positionScaled.x, BattleScreenGame.btnInvertAim_2.positionScaled.y, 128.0f, 128.0f);
            btnInvertAim_2.draw();
            BattleScreenGame.currentPlayer.imageFond.draw(BattleScreenGame.btnCombo_2.positionScaled.x, BattleScreenGame.btnCombo_2.positionScaled.y, 128.0f, 128.0f);
            btnCombo_2.draw();
            BattleScreenGame.currentPlayer.imageFond.draw(BattleScreenGame.btnUseFury_2.positionScaled.x, BattleScreenGame.btnUseFury_2.positionScaled.y, 128.0f, 128.0f);
            btnUseFury_2.draw();
        }
    }

    public void drawSelection(Selection selection) {
        Position pos = selection.pion.getPositionScale();
        pos.x += (float)Graphics.decalageX;
        Graphics.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        Graphics.shapeRenderer.setColor(1.0f, 1.0f, 0.0f, 1.0f);
        Graphics.shapeRenderer.circle(pos.x, pos.y, (selection.pion.ball.radius + 10.0f) * Scene2D.RATIO);
        Graphics.shapeRenderer.end();
    }

    public static void drawAim(Selection selection) {
        if (selection.pion != null && selection.aim.len() > selection.pion.ball.radius) {
            float angleArrow = -selection.aim.angle() - 90.0f;
            TextureRegion arrow = selection.aim.len() < selection.pion.ball.radius * 3.0f ? arrows[0] : (selection.aim.len() < selection.pion.ball.radius * 6.0f ? arrows[1] : arrows[2]);
            float scale = selection.aim.len() / (float)arrow.getRegionHeight();
            GDXImage.batch.begin();
            GDXImage.batch.setColor(1.0f, 1.0f, 1.0f, 0.8f);
            if (BattleScreenGame.isAimForward()) {
                GDXImage.batch.draw(arrow, selection.pion.positionScaled.x - 32.0f * Scene2D.RATIO, selection.pion.positionScaled.y, 32.0f * Scene2D.RATIO, 0.0f, (float)arrow.getRegionWidth() * Scene2D.RATIO, (float)arrow.getRegionHeight() * Scene2D.RATIO, scale, scale, angleArrow);
            } else {
                float x = (float)Graphics.decalageX + Graphics.getPositionScaleX(selection.endPoint.x);
                float y = Graphics.getPositionScaleY(selection.endPoint.y);
                GDXImage.batch.draw(arrow, x - 32.0f * Scene2D.RATIO, y, 32.0f * Scene2D.RATIO, 0.0f, (float)arrow.getRegionWidth() * Scene2D.RATIO, (float)arrow.getRegionHeight() * Scene2D.RATIO, scale, -scale, angleArrow);
            }
            if (selection.pion.type == PionBattle.Type.FEU && selection.pion.isFury) {
                FeuBattle feu = (FeuBattle)selection.pion;
                feu.drawFuryAim(selection.aim);
            }
            GDXImage.batch.end();
        }
    }

    private static boolean isAimForward() {
        return isAimForward;
    }

    @Override
    public void displayOSD() {
        if (isDisplayLife) {
            BattleGame.playerRed.drawHudFront();
            BattleGame.playerBlue.drawHudFront();
        }
        if (!isPlaying) {
            BattleScreenGame.drawAims();
        }
    }

    public static void drawAims() {
        int i = 0;
        while (i < selections.length) {
            Selection selection = selections[i];
            BattleScreenGame.drawAim(selection);
            ++i;
        }
    }

    class Selection {
        public PionBattle pion;
        public Vector2 aim = new Vector2();
        public Vector2 startPoint = new Vector2();
        public Vector2 endPoint = new Vector2();
        public boolean isAimed = false;

        public void reset() {
            this.isAimed = false;
            this.pion = null;
            this.aim.set(0.0f, 0.0f);
            this.startPoint.set(0.0f, 0.0f);
            this.endPoint.set(0.0f, 0.0f);
        }
    }
}

