/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.battle.screens;

import com.badlogic.gdx.utils.Array;
import com.takyon.battle.BattleGame;
import com.takyon.battle.screens.BattleGameScreen;
import com.takyon.battle.screens.BattleScreenIntro;
import com.takyon.chess.gui.GUIComponent;
import com.takyon.chess.utils.Fonts;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GDXTextButton;
import com.takyon.gamelib.GDXToggleButton;
import com.takyon.gamelib.Language;

public class BattleScreenOptions
extends BattleGameScreen {
    private int ongletActif;
    private static final int ONGLET_GENERAL = 0;
    private static final int ONGLET_GAMEPLAY = 1;
    private static final int ONGLET_GAMEPLAY_JOKERS = 2;
    private static final int ONGLET_GAMEPLAY_VICTOIRE = 3;
    private GDXToggleButton btnSound;
    private GDXTextButton btnValider;
    private GDXImage imageFondOptionsBlack;
    private GDXImage imageFondOptionsWhite;
    private GDXButton btnOngletGeneral;
    private GDXButton btnOngletGamePlay;
    private GDXButton btnOngletGamePlayJokers;
    private GDXButton btnOngletGamePlayVictoire;
    private OngletOptionsPlayer ongletGeneral;
    private OngletOptionsPlayer ongletGamePlayWhite;
    private OngletOptionsPlayer ongletGamePlayBlack;
    private OngletOptionsPlayer ongletJokersWhite;
    private OngletOptionsPlayer ongletJokersBlack;
    private OngletOptionsPlayer ongletVictoireWhite;
    private OngletOptionsPlayer ongletVictoireBlack;

    @Override
    public void firstInit() {
        super.firstInit();
        this.imageFondOptionsWhite = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/interface/options_white.png");
        this.imageFondOptionsWhite.setPosition(10.0f, 150.0f);
        this.imageFondOptionsBlack = new GDXImage(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/interface/options_black.png");
        this.imageFondOptionsBlack.setPosition(1000.0f, 150.0f);
        this.btnSound = new GDXToggleButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/sound", true, true, false);
        this.btnSound.setPosition(100.0f, 900.0f);
        this.btnValider = new GDXTextButton(String.valueOf(BattleGame.KIT_DIRECTORY) + "/images/boutons/void", true, false, false);
        this.btnValider.label = new GDXText(Fonts.BUTTON, Language.tr("menu.validate"));
        this.btnValider.setPosition(100.0f, 1200.0f);
        this.ongletGeneral = new OngletOptionsPlayer(650);
        this.ongletGeneral.init();
    }

    @Override
    public void init() {
        this.ongletActif = 0;
        this.btnSound.isToggled = false;
        this.btnSound.release();
    }

    @Override
    public void finish() {
    }

    @Override
    public void onTouched(int x, int y, int pointer, int button) {
        if (this.btnOngletGeneral.isClicked(x, y)) {
            this.ongletActif = 0;
        } else if (this.btnOngletGamePlay.isClicked(x, y)) {
            this.ongletActif = 1;
        } else if (this.btnOngletGamePlayJokers.isClicked(x, y)) {
            this.ongletActif = 2;
        } else if (this.btnOngletGamePlayVictoire.isClicked(x, y)) {
            this.ongletActif = 3;
        }
        if (!this.btnSound.isClicked(x, y) && this.btnValider.isClicked(x, y)) {
            BattleScreenOptions.changeScreen(screenIntro);
        }
        if (this.ongletActif == 0) {
            this.ongletGeneral.checkClick(x, y);
        } else if (this.ongletActif == 1) {
            this.ongletGamePlayWhite.checkClick(x, y);
            this.ongletGamePlayBlack.checkClick(x, y);
        } else if (this.ongletActif == 2) {
            this.ongletJokersWhite.checkClick(x, y);
            this.ongletJokersBlack.checkClick(x, y);
        } else if (this.ongletActif == 3) {
            this.ongletVictoireWhite.checkClick(x, y);
            this.ongletVictoireBlack.checkClick(x, y);
        }
    }

    @Override
    public void display() {
        GDXImage.batch.begin();
        BattleScreenIntro.imgBackground.draw();
        super.display();
        this.btnSound.draw();
        this.btnValider.draw();
        if (this.ongletActif == 0) {
            this.imageFondOptionsWhite.draw();
            this.ongletGeneral.draw();
        } else if (this.ongletActif == 1) {
            this.imageFondOptionsWhite.draw();
            this.imageFondOptionsBlack.draw();
            this.ongletGamePlayWhite.draw();
            this.ongletGamePlayBlack.draw();
        } else if (this.ongletActif == 2) {
            this.imageFondOptionsWhite.draw();
            this.imageFondOptionsBlack.draw();
            this.ongletJokersWhite.draw();
            this.ongletJokersBlack.draw();
        } else if (this.ongletActif == 3) {
            this.imageFondOptionsWhite.draw();
            this.imageFondOptionsBlack.draw();
            this.ongletVictoireWhite.draw();
            this.ongletVictoireBlack.draw();
        }
        GDXImage.batch.end();
    }

    class OngletOptionsPlayer {
        private Array<GUIComponent> options;
        private int posX;

        public OngletOptionsPlayer(int x) {
            this.posX = x;
            this.options = new Array();
        }

        public void add(GUIComponent component) {
            this.options.add((Object)component);
        }

        public void init() {
            int j = 0;
            while (j < this.options.size) {
                GUIComponent component = (GUIComponent)this.options.get(j);
                component.setPosition(this.posX, 200 + j * 100);
                ++j;
            }
        }

        public void checkClick(int x, int y) {
            int j = 0;
            while (j < this.options.size) {
                GUIComponent component = (GUIComponent)this.options.get(j);
                component.isClicked(x, y);
                ++j;
            }
        }

        public void draw() {
            int j = 0;
            while (j < this.options.size) {
                GUIComponent component = (GUIComponent)this.options.get(j);
                component.draw();
                ++j;
            }
        }
    }
}

