/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.game;

import com.badlogic.gdx.utils.Array;

public class Cell {
    public int i;
    public int j;
    private static int nbCols;
    private static int nbRows;
    private static Cell[][] cells;

    public Cell(int i, int j) {
        this.i = i;
        this.j = j;
    }

    public static void initCells(int cols, int rows) {
        nbCols = cols;
        nbRows = rows;
        cells = new Cell[cols][rows];
        int i = 0;
        while (i < cols) {
            int j = 0;
            while (j < rows) {
                Cell.cells[i][j] = new Cell(i, j);
                ++j;
            }
            ++i;
        }
    }

    private void addCell(Array<Cell> cells, Cell cell) {
        if (cell != null && !cells.contains((Object)cell, true)) {
            cells.add((Object)cell);
        }
    }

    public Array<Cell> getCellsAround() {
        Array cells = new Array();
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 1, this.j));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 1, this.j - 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i, this.j - 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 1, this.j - 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 1, this.j));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 1, this.j + 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i, this.j + 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 1, this.j + 1));
        return cells;
    }

    public Array<Cell> getCellsAroundRayon2() {
        Array cells = new Array();
        this.addCell((Array<Cell>)cells, Cell.get(this.i, this.j + 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 1, this.j + 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 2, this.j + 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 2, this.j + 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 2, this.j));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 2, this.j - 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 2, this.j - 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i + 1, this.j - 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i, this.j - 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 1, this.j - 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 2, this.j - 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 2, this.j - 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 2, this.j));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 2, this.j + 1));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 2, this.j + 2));
        this.addCell((Array<Cell>)cells, Cell.get(this.i - 1, this.j + 2));
        return cells;
    }

    public static Cell get(int i, int j) {
        if (i >= 0 && i < nbCols && j >= 0 && j < nbRows) {
            return cells[i][j];
        }
        return null;
    }

    public boolean equals(Cell cell) {
        return this.i == cell.i && this.j == cell.j;
    }

    public String toString() {
        return "<" + this.i + "," + this.j + ">";
    }
}

