/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.gui;

import com.badlogic.gdx.graphics.Texture;
import com.takyon.chess.game.rules.GameParamaterBoolean;
import com.takyon.chess.utils.Fonts;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GDXToggleButton;
import com.takyon.gamelib.ICLickable;

public class Checkbox
extends GDXToggleButton
implements ICLickable {
    private GDXText txtLabel;
    public Texture imgCheckedDisabled;
    public Texture imgUncheckedDisabled;
    private GameParamaterBoolean paramaterBoolean;

    public Checkbox(String label, GameParamaterBoolean paramater) {
        super(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/check", true, true, false);
        this.txtLabel = new GDXText(Fonts.TEXT_MENU, label);
        this.paramaterBoolean = paramater;
        this.isToggled = paramater.value;
        this.update();
        this.imgCheckedDisabled = new Texture(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/check_on_disabled.png");
        this.imgUncheckedDisabled = new Texture(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/check_off_disabled.png");
    }

    @Override
    public boolean isClicked(int x, int y) {
        if (this.isEnabled()) {
            super.isClicked(x, y);
            this.paramaterBoolean.value = this.isToggled;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
        this.img = enabled ? (this.isToggled ? this.imgDown : this.imgUp) : (this.isToggled ? this.imgCheckedDisabled : this.imgUncheckedDisabled);
    }

    @Override
    public void setPosition(float x, float y) {
        this.txtLabel.setPosition(x - 600.0f, y);
        super.setPosition(x, y);
    }

    @Override
    public void draw() {
        this.txtLabel.draw();
        super.draw();
    }
}

