/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.pions;

import com.takyon.chess.game.Player;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.pions.Air;
import com.takyon.chess.pions.Eau;
import com.takyon.chess.pions.Feu;
import com.takyon.chess.pions.Oeuf;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.Roi;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXImage;

public class PionFactory {
    public static transient GDXImage[] imagesPionsBlue;
    public static transient GDXImage[] imagesPionsRed;

    public static void initImages() {
        imagesPionsBlue = new GDXImage[Pion.Type.values().length];
        imagesPionsRed = new GDXImage[Pion.Type.values().length];
        int i = 0;
        while (i < Pion.Type.values().length) {
            Pion.Type type = Pion.Type.values()[i];
            String stringType = type.toString().toLowerCase();
            PionFactory.imagesPionsBlue[type.ordinal()] = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/pions/blue/" + stringType + ".png");
            PionFactory.imagesPionsRed[type.ordinal()] = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/pions/red/" + stringType + ".png");
            ++i;
        }
    }

    public static Pion createPion(Player player, Pion.Type type) {
        Pion pion = null;
        switch (type) {
            case ROI: {
                pion = new Roi(player, type);
                break;
            }
            case AIR: {
                pion = new Air(player, type);
                break;
            }
            case FEU: {
                pion = new Feu(player, type);
                break;
            }
            case EAU: {
                pion = new Eau(player, type);
                break;
            }
            case OEUF: {
                pion = new Oeuf(player, type);
                break;
            }
        }
        pion.grid = GameRules.grid;
        return pion;
    }

    public static Pion createPionFrom(Player player, Pion pion) {
        if (pion.type == Pion.Type.OEUF) {
            Oeuf oeuf = (Oeuf)pion;
            Oeuf newOeuf = new Oeuf(player, pion.type);
            newOeuf.setCoords(pion.i, pion.j);
            newOeuf.content = oeuf.content;
            newOeuf.grid = GameRules.grid;
            return newOeuf;
        }
        return PionFactory.createPion(player, pion.type, pion.i, pion.j);
    }

    public static Pion createPion(Player player, Pion.Type type, int i, int j) {
        Pion pion = PionFactory.createPion(player, type);
        pion.setCoords(i, j);
        return pion;
    }
}

