/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.screens;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.ChessGame;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.network.messages.game.ChangeBoussoleMessage;
import com.takyon.chess.network.messages.game.PassMessage;
import com.takyon.chess.network.messages.game.PlacementMessage;
import com.takyon.chess.pions.Oeuf;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.PionFactory;
import com.takyon.chess.screens.ChessGameScreen;
import com.takyon.chess.screens.ScreenOptions;
import com.takyon.chess.test.SavePlateau;
import com.takyon.chess.utils.BattleGraphics;
import com.takyon.chess.utils.Fonts;
import com.takyon.chess.utils.Positions;
import com.takyon.chess.utils.SavePlacementState;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GDXTextButton;
import com.takyon.gamelib.Graphics;
import com.takyon.gamelib.Language;

public class ScreenGame
extends ChessGameScreen {
    private static GDXImage imageTurnBlack;
    private static GDXImage imageTurnWhite;
    private static GDXImage imageTurn;
    private static GDXImage imageSelect;
    private static GDXImage imageStartMovementWhite;
    private static GDXImage imageEndMovementWhite;
    private static GDXImage imageStartMovementBlack;
    private static GDXImage imageEndMovementBlack;
    private GDXButton btnRoiRed;
    private GDXButton btnFeuRed;
    private GDXButton btnEauRed;
    private GDXButton btnAirRed;
    private GDXButton btnOeufRed;
    private GDXButton btnRoiBlue;
    private GDXButton btnFeuBlue;
    private GDXButton btnEauBlue;
    private GDXButton btnAirBlue;
    private GDXButton btnOeufBlue;
    private GDXButton btnSupprPion;
    private GDXButton btnSeePionsPris;
    private GDXButton btnDeselect;
    private GDXButton btnPass;
    private GDXButton btnArmistice;
    private GDXButton btnSeeJokers;
    private GDXButton btnSeeOptions;
    private GDXButton btnSeeHelp;
    private GDXButton btnFinishPlacement;
    private GDXButton btnSavePlacementPlayer;
    private GDXButton btnSavePlacement;
    private GDXButton btnBlueTurn;
    private GDXButton btnRedTurn;
    private static GDXImage imgFondBoussoleWhiteDisabled;
    private static GDXImage imgFondBoussoleBlackDisabled;
    private static GDXImage imgFondBoussoleWhite;
    private static GDXImage imgFondBoussoleBlack;
    private static GDXButton btnBoussolePlayerWhite;
    private static GDXButton btnBoussolePlayerWhiteDiag;
    private static GDXButton btnBoussolePlayerWhiteLines;
    private static GDXButton btnBoussolePlayerBlack;
    private static GDXButton btnBoussolePlayerBlackDiag;
    private static GDXButton btnBoussolePlayerBlackLines;
    private GDXImage[] btnJokersWhite;
    private GDXImage[] btnJokersBlack;
    private GDXTextButton[] btnPlacements;
    private GDXTextButton[] btnPlacementsPlayer;
    public static boolean isPlacing;
    private static GDXImage imagePlacing;
    private boolean isSavePlacingConfirm;
    private boolean isSavePlacingPlayerConfirm;
    private boolean isTurnConfirm;
    private boolean isActionDelete = false;
    private boolean isHelpDisplayed = false;
    private boolean isJailDisplayed = false;
    private static GDXImage decor;
    private static GDXImage imagePrisonBlack;
    private static GDXImage imagePrisonwWhite;
    private static GDXImage imageAideReglesBlack;
    private static GDXImage imageAideReglesWhite;
    public static GDXImage imageWinRed;
    public static GDXImage imageWinBlue;
    public static GDXImage imageWinNull;
    public static GDXImage imageWin;
    public static boolean isRecupPion;
    public static boolean isEnd;

    static {
        isPlacing = true;
    }

    @Override
    public void firstInit() {
        imagePlacing = new GDXImage();
        imageTurnBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/turn_black.png");
        imageTurnBlack.setPosition(1650.0f, 600.0f);
        imageTurnWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/turn_white.png");
        imageTurnWhite.setPosition(imageTurnBlack.getPosition());
        this.btnRoiBlue = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/blue/roi", true, false, false);
        this.btnRoiBlue.setPosition(1500.0f, 256.0f);
        this.btnFeuBlue = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/blue/feu", true, false, false);
        this.btnFeuBlue.setPosition(1500.0f, 386.0f);
        this.btnEauBlue = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/blue/eau", true, false, false);
        this.btnEauBlue.setPosition(1500.0f, 514.0f);
        this.btnAirBlue = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/blue/air", true, false, false);
        this.btnAirBlue.setPosition(1500.0f, 642.0f);
        this.btnOeufBlue = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/blue/oeuf", true, false, false);
        this.btnOeufBlue.setPosition(1500.0f, 770.0f);
        this.btnRoiRed = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/red/roi", true, false, false);
        this.btnRoiRed.setPosition(1500.0f, 256.0f);
        this.btnFeuRed = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/red/feu", true, false, false);
        this.btnFeuRed.setPosition(1500.0f, 386.0f);
        this.btnEauRed = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/red/eau", true, false, false);
        this.btnEauRed.setPosition(1500.0f, 514.0f);
        this.btnAirRed = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/red/air", true, false, false);
        this.btnAirRed.setPosition(1500.0f, 642.0f);
        this.btnOeufRed = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/red/oeuf", true, false, false);
        this.btnOeufRed.setPosition(1500.0f, 770.0f);
        this.btnSupprPion = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/suppr_pion", true, false, false);
        this.btnSupprPion.setPosition(1500.0f, 898.0f);
        this.btnSeeHelp = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/voir_aide", true, false, false);
        this.btnSeeHelp.setPosition(10.0f, 50.0f);
        this.btnSeeOptions = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/voir_options", true, false, false);
        this.btnSeeOptions.setPosition(110.0f, 50.0f);
        this.btnSeePionsPris = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/voir_pions_pris", true, false, false);
        this.btnSeePionsPris.setPosition(210.0f, 50.0f);
        this.btnDeselect = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/deselect", true, false, false);
        this.btnDeselect.setPosition(310.0f, 50.0f);
        this.btnPass = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/pass", true, false, false);
        this.btnPass.setPosition(1650.0f, 450.0f);
        this.btnArmistice = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/armistice", true, false, false);
        this.btnArmistice.setPosition(1650.0f, 450.0f);
        this.btnSeeJokers = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/voir_jokers", true, false, false);
        this.btnSeeJokers.setPosition(1500.0f, 500.0f);
        this.btnFinishPlacement = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/placement_fini", true, false, false);
        this.btnFinishPlacement.setPosition(1650.0f, 500.0f);
        this.btnSavePlacement = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/save_placement", true, false, false);
        this.btnSavePlacement.setPosition(1650.0f, 400.0f);
        this.btnSavePlacementPlayer = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/save_placement_joueur", true, false, false);
        this.btnSavePlacementPlayer.setPosition(1650.0f, 400.0f);
        this.btnBlueTurn = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/blue", true, false, false);
        this.btnBlueTurn.setPosition(ScreenGame.imageDialogConfirm.getPosition().x + 50.0f, ScreenGame.imageDialogConfirm.getPosition().y + 350.0f);
        this.btnRedTurn = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/red", true, false, false);
        this.btnRedTurn.setPosition(ScreenGame.imageDialogConfirm.getPosition().x + 450.0f, ScreenGame.imageDialogConfirm.getPosition().y + 350.0f);
        imgFondBoussoleBlackDisabled = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_disabled.png");
        imgFondBoussoleBlackDisabled.setPosition(1650.0f, 100.0f);
        imgFondBoussoleBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_black.png");
        imgFondBoussoleBlack.setPosition(1650.0f, 100.0f);
        btnBoussolePlayerBlackDiag = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_diagonales", true, false, false);
        btnBoussolePlayerBlackDiag.setPosition(1650.0f, 100.0f);
        btnBoussolePlayerBlackLines = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_horizontal_vertical", true, false, false);
        btnBoussolePlayerBlackLines.setPosition(1650.0f, 100.0f);
        imgFondBoussoleWhiteDisabled = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_disabled.png");
        imgFondBoussoleWhiteDisabled.setPosition(1650.0f, 724.0f);
        imgFondBoussoleWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_white.png");
        imgFondBoussoleWhite.setPosition(1650.0f, 724.0f);
        btnBoussolePlayerWhiteDiag = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_diagonales", true, false, false);
        btnBoussolePlayerWhiteDiag.setPosition(1650.0f, 724.0f);
        btnBoussolePlayerWhiteLines = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_horizontal_vertical", true, false, false);
        btnBoussolePlayerWhiteLines.setPosition(1650.0f, 724.0f);
        imageSelect = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/selection.png");
        imageStartMovementWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/start_move_white.png");
        imageEndMovementWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/end_move_white.png");
        imageStartMovementBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/start_move_black.png");
        imageEndMovementBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/end_move_black.png");
        this.btnJokersWhite = new GDXImage[12];
        this.btnJokersBlack = new GDXImage[12];
        int i = 0;
        while (i < 12) {
            this.btnJokersBlack[i] = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/joker_black.png");
            if (i < 6) {
                this.btnJokersBlack[i].setPosition(1500.0f, Positions.gridPos.y + (float)(i * 64));
            } else {
                this.btnJokersBlack[i].setPosition(1568.0f, Positions.gridPos.y + (float)((i - 6) * 64));
            }
            ++i;
        }
        i = 0;
        while (i < 12) {
            this.btnJokersWhite[i] = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/joker_white.png");
            if (i < 6) {
                this.btnJokersWhite[i].setPosition(1500.0f, Positions.gridPos.y + 1024.0f - 64.0f - (float)(i * 64));
            } else {
                this.btnJokersWhite[i].setPosition(1568.0f, Positions.gridPos.y + 1024.0f - 64.0f - (float)((i - 6) * 64));
            }
            ++i;
        }
        decor = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/decor.png");
        imageAideReglesBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/aide_regles_rouges.png");
        imageAideReglesWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/aide_regles_bleus.png");
        imageAideReglesBlack.setPosition(5.0f, 500.0f);
        imageAideReglesWhite.setPosition(5.0f, 500.0f);
        imagePrisonBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/prison_red.png");
        imagePrisonwWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/prison_blue.png");
        imagePrisonBlack.setPosition(5.0f, 500.0f);
        imagePrisonwWhite.setPosition(5.0f, 500.0f);
        imageWinRed = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/red_victory.png");
        imageWinRed.setPosition(562.0f, 224.0f);
        imageWinBlue = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/blue_victory.png");
        imageWinBlue.setPosition(562.0f, 224.0f);
        imageWinNull = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/partie_nulle.png");
        imageWinNull.setPosition(562.0f, 224.0f);
        PionFactory.initImages();
    }

    @Override
    public void init() {
        ChessGame.initGame();
        this.btnPlacements = new GDXTextButton[ChessGame.mapPlacements.entrySet().size()];
        this.btnPlacementsPlayer = new GDXTextButton[ChessGame.mapPlacementsPlayer.entrySet().size()];
        int b = 0;
        for (String namePlacement : ChessGame.mapPlacements.keySet()) {
            this.btnPlacements[b] = new GDXTextButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/void", true, false, false);
            this.btnPlacements[b].label = new GDXText(Fonts.TEXT, namePlacement);
            this.btnPlacements[b].setPosition(0.0f, 250 + b * 50);
            ++b;
        }
        b = 0;
        for (String namePlacementPlayer : ChessGame.mapPlacementsPlayer.keySet()) {
            this.btnPlacementsPlayer[b] = new GDXTextButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/void", true, false, false);
            this.btnPlacementsPlayer[b].label = new GDXText(Fonts.TEXT, namePlacementPlayer);
            this.btnPlacementsPlayer[b].setPosition(0.0f, 250 + b * 50);
            ++b;
        }
        this.isTurnConfirm = false;
        this.isSavePlacingConfirm = false;
        this.isSavePlacingPlayerConfirm = false;
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            imageTurn = imageTurnWhite;
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            imageTurn = imageTurnBlack;
        }
        imageStartMovementWhite.setVisible(false);
        imageEndMovementWhite.setVisible(false);
        imageStartMovementBlack.setVisible(false);
        imageEndMovementBlack.setVisible(false);
        ScreenGame.updateDirections();
        if (ChessGame.isDebug) {
            GameRules.historiqueActions = new Array();
        }
        this.reset();
    }

    public void reset() {
        isPlacing = true;
        isRecupPion = false;
        isEnd = false;
        GameRules.reset();
    }

    @Override
    public void finish() {
    }

    @Override
    public void mouseMoved(int screenX, int screenY) {
        if (isPlacing) {
            int j;
            int i = ScreenGame.getGridX(screenX);
            if (GameRules.isInGrid(i, j = ScreenGame.getGridY(screenY))) {
                imagePlacing.setVisible(true);
                imagePlacing.setPosition(screenX - 64, screenY - 64);
            } else {
                imagePlacing.setVisible(false);
            }
        }
    }

    @Override
    public void keyTyped(char character) {
        textInput.addChar(character);
    }

    @Override
    public void keyUp(int keycode) {
        if (keycode == 67) {
            textInput.removeChar();
        }
    }

    @Override
    public void onTouched(int x, int y) {
        try {
            if (this.isTurnConfirm) {
                if (this.btnBlueTurn.isClicked(x, y)) {
                    ScreenGame.initTurn(ChessGame.playerBlue);
                    this.isTurnConfirm = false;
                } else if (this.btnRedTurn.isClicked(x, y)) {
                    ScreenGame.initTurn(ChessGame.playerRed);
                    this.isTurnConfirm = false;
                }
            } else if (isRecupPion) {
                if (this.btnRoiRed.isClicked(x, y)) {
                    GameRules.recupPion(Pion.Type.ROI);
                    isRecupPion = false;
                    return;
                }
                if (this.btnFeuRed.isClicked(x, y)) {
                    GameRules.recupPion(Pion.Type.FEU);
                    isRecupPion = false;
                    return;
                }
                if (this.btnEauRed.isClicked(x, y)) {
                    GameRules.recupPion(Pion.Type.EAU);
                    isRecupPion = false;
                    return;
                }
                if (this.btnAirRed.isClicked(x, y)) {
                    GameRules.recupPion(Pion.Type.AIR);
                    isRecupPion = false;
                    return;
                }
                if (this.btnOeufRed.isClicked(x, y)) {
                    GameRules.recupPion(Pion.Type.OEUF);
                    isRecupPion = false;
                    return;
                }
            } else if (isEnd) {
                if (btnYes.isClicked(x, y)) {
                    isEnd = false;
                    this.init();
                    return;
                }
                if (btnNo.isClicked(x, y)) {
                    isEnd = false;
                    ScreenGame.changeScreen(ChessGameScreen.screenIntro);
                    return;
                }
            } else if (this.isSavePlacingConfirm) {
                if (btnYes.isClicked(x, y)) {
                    ChessGame.savePlacement(ScreenGame.textMessage.text);
                    this.isSavePlacingConfirm = false;
                } else if (btnNo.isClicked(x, y)) {
                    this.isSavePlacingConfirm = false;
                }
            } else if (this.isSavePlacingPlayerConfirm) {
                if (btnYes.isClicked(x, y)) {
                    ChessGame.savePlacementPlayer(GameRules.currentPlayer, ScreenGame.textMessage.text);
                    this.isSavePlacingConfirm = false;
                } else if (btnNo.isClicked(x, y)) {
                    this.isSavePlacingConfirm = false;
                }
            } else if (isMessageAlert) {
                if (btnOk.isClicked(x, y)) {
                    isMessageAlert = false;
                    return;
                }
            } else if (isPlacing) {
                Object state;
                GDXTextButton button;
                if (this.btnRoiRed.isClicked(x, y)) {
                    this.setCurrentType(Pion.Type.ROI);
                    return;
                }
                if (this.btnFeuRed.isClicked(x, y)) {
                    this.setCurrentType(Pion.Type.FEU);
                    return;
                }
                if (this.btnEauRed.isClicked(x, y)) {
                    this.setCurrentType(Pion.Type.EAU);
                    return;
                }
                if (this.btnAirRed.isClicked(x, y)) {
                    this.setCurrentType(Pion.Type.AIR);
                    return;
                }
                if (this.btnOeufRed.isClicked(x, y)) {
                    this.setCurrentType(Pion.Type.OEUF);
                    return;
                }
                if (this.btnSupprPion.isClicked(x, y)) {
                    this.isActionDelete = true;
                    ScreenGame.imagePlacing.texture = this.btnSupprPion.img;
                    return;
                }
                this.processBoussoles(x, y);
                GDXTextButton[] gDXTextButtonArray = this.btnPlacements;
                int n = this.btnPlacements.length;
                int n2 = 0;
                while (n2 < n) {
                    button = gDXTextButtonArray[n2];
                    if (button.isClicked(x, y)) {
                        state = ChessGame.mapPlacements.get(button.label.text);
                        ChessGame.loadPlacement((SavePlateau)state);
                    }
                    ++n2;
                }
                gDXTextButtonArray = this.btnPlacementsPlayer;
                n = this.btnPlacementsPlayer.length;
                n2 = 0;
                while (n2 < n) {
                    button = gDXTextButtonArray[n2];
                    if (button.isClicked(x, y)) {
                        state = ChessGame.mapPlacementsPlayer.get(button.label.text);
                        ChessGame.loadPlacementPlayer((SavePlacementState)state);
                    }
                    ++n2;
                }
                if (this.btnFinishPlacement.isClicked(x, y)) {
                    GameRules.historiqueActions.add((Object)new PlacementMessage(GameRules.currentPlayer.color, GameRules.currentPlayer.pions));
                    GameRules.currentPlayer.hasFinishedPlacing = true;
                    ScreenGame.changeTurn();
                    if (GameRules.currentType != null) {
                        this.setCurrentType(GameRules.currentType);
                    }
                    if (ChessGame.playerBlue.hasFinishedPlacing() && ChessGame.playerRed.hasFinishedPlacing()) {
                        isPlacing = false;
                        this.isTurnConfirm = true;
                        textMessage.setText(Language.tr("message_choix_joueur_commence"));
                    }
                    return;
                }
                if (this.btnSavePlacement.isClicked(x, y)) {
                    this.isSavePlacingConfirm = true;
                    return;
                }
                if (this.btnSavePlacementPlayer.isClicked(x, y)) {
                    this.isSavePlacingPlayerConfirm = true;
                    return;
                }
            } else if (this.btnSeePionsPris.isClicked(x, y)) {
                this.isJailDisplayed = !this.isJailDisplayed;
            } else if (this.btnDeselect.isClicked(x, y)) {
                GameRules.selectedPion = null;
            } else if (this.btnPass.isClicked(x, y)) {
                if (GameRules.currentPlayer.canPass()) {
                    GameRules.historiqueActions.add((Object)new PassMessage(GameRules.currentPlayer));
                    GameRules.pass();
                } else {
                    isMessageAlert = true;
                    textMessage.setText(Language.tr("message_pass_impossible"));
                }
            } else if (this.btnSeeHelp.isClicked(x, y)) {
                this.isHelpDisplayed = !this.isHelpDisplayed;
            } else if (this.btnSeeOptions.isClicked(x, y)) {
                ScreenOptions.isIngame = true;
                ScreenGame.changeScreen(ChessGameScreen.screenOptions);
            } else if (this.btnSeeJokers.isClicked(x, y)) {
                GameRules.seeJokers();
            } else {
                this.processBoussoles(x, y);
            }
            int i = ScreenGame.getGridX(x);
            int j = ScreenGame.getGridY(y);
            if (GameRules.isInGrid(i, j)) {
                if (isPlacing) {
                    if (this.isActionDelete) {
                        GameRules.deletePion(i, j);
                    } else if (GameRules.currentType != null) {
                        GameRules.placePion(i, j);
                    }
                } else {
                    this.clickOnGrid(i, j);
                }
            }
            if (ChessGame.isDebug) {
                int bj = 0;
                while (bj < this.btnJokersWhite.length) {
                    if (this.btnJokersWhite[bj].isPointed(x, y)) {
                        ChessGame.playerBlue.perdJoker(1);
                    }
                    ++bj;
                }
                bj = 0;
                while (bj < this.btnJokersBlack.length) {
                    if (this.btnJokersBlack[bj].isPointed(x, y)) {
                        ChessGame.playerRed.perdJoker(1);
                    }
                    ++bj;
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            ChessGame.saveBug();
        }
    }

    private void processBoussoles(int x, int y) {
        if (btnBoussolePlayerWhite.isClicked(x, y)) {
            if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.BLACK, PlayerColor.WHITE));
                GameRules.changeBoussole(ChessGame.playerRed, ChessGame.playerBlue);
            } else if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.WHITE, PlayerColor.WHITE));
                GameRules.changeBoussole(ChessGame.playerBlue, ChessGame.playerBlue);
            }
        } else if (btnBoussolePlayerBlack.isClicked(x, y)) {
            if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.BLACK, PlayerColor.BLACK));
                GameRules.changeBoussole(ChessGame.playerRed, ChessGame.playerRed);
            } else if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.WHITE, PlayerColor.BLACK));
                GameRules.changeBoussole(ChessGame.playerBlue, ChessGame.playerRed);
            }
        }
    }

    private void setCurrentType(Pion.Type type) {
        GameRules.currentType = type;
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            ScreenGame.imagePlacing.texture = PionFactory.imagesPionsBlue[type.ordinal()].texture;
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            ScreenGame.imagePlacing.texture = PionFactory.imagesPionsRed[type.ordinal()].texture;
        }
        this.isActionDelete = false;
    }

    private void clickOnGrid(int i, int j) {
        Pion pion = GameRules.grid.getPion(i, j);
        if (GameRules.selectedPion == null) {
            if (pion != null && pion.player.color == GameRules.currentPlayer.color) {
                this.select(i, j);
            }
        } else if (pion == null) {
            GameRules.play(i, j);
        } else if (pion.player.color == GameRules.currentPlayer.color) {
            if (pion.type == Pion.Type.OEUF && pion.i == GameRules.selectedPion.i && pion.j == GameRules.selectedPion.j) {
                Oeuf oeuf = (Oeuf)pion;
                if (oeuf.content != null) {
                    GameRules.play(i, j);
                } else {
                    this.select(i, j);
                }
            } else {
                this.select(i, j);
            }
        } else {
            GameRules.play(i, j);
        }
    }

    private void select(int i, int j) {
        GameRules.selectedPion = GameRules.grid.getPion(i, j);
        GameRules.selectedPion.setAvailableCellsSuper();
        imageSelect.setPosition(GameRules.selectedPion.getPosition());
    }

    public static void select(Pion pion) {
        GameRules.selectedPion = pion;
        GameRules.selectedPion.setAvailableCellsSuper();
        imageSelect.setPosition(GameRules.selectedPion.getPosition());
    }

    public static void changeTurnPass() {
        GameRules.changeTurnPass();
        if (!isPlacing && ChessGame.isIA && GameRules.currentPlayer.color == PlayerColor.BLACK) {
            GameRules.playIA();
        }
        ScreenGame.updateTurn();
    }

    public static void changeTurn() {
        GameRules.changeTurnPlayer();
        if (!isPlacing && ChessGame.isIA && GameRules.currentPlayer.color == PlayerColor.BLACK) {
            GameRules.playIA();
        }
        ScreenGame.updateTurn();
    }

    public static void updateMovementIconsWhite(int start_i, int start_j, int end_i, int end_j) {
        imageStartMovementWhite.setVisible(true);
        imageEndMovementWhite.setVisible(true);
        BattleGraphics.setGridPosition(imageStartMovementWhite, start_i, start_j);
        BattleGraphics.setGridPosition(imageEndMovementWhite, end_i, end_j);
    }

    public static void updateMovementIconsBlack(int start_i, int start_j, int end_i, int end_j) {
        imageStartMovementBlack.setVisible(true);
        imageEndMovementBlack.setVisible(true);
        BattleGraphics.setGridPosition(imageStartMovementBlack, start_i, start_j);
        BattleGraphics.setGridPosition(imageEndMovementBlack, end_i, end_j);
    }

    public static void initTurn(Player player) {
        GameRules.initTurn(player);
        ScreenGame.updateTurn();
    }

    public static void updateTurn() {
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            imageTurn = imageTurnWhite;
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            imageTurn = imageTurnBlack;
        }
    }

    public static int getGridX(int x) {
        if ((float)x < Positions.gridPos.x) {
            return -1;
        }
        return (int)(((float)x - Positions.gridPos.x) / Positions.gridSize);
    }

    public static int getGridY(int y) {
        if ((float)y < Positions.gridPos.y) {
            return -1;
        }
        return (int)(((float)y - Positions.gridPos.y) / Positions.gridSize);
    }

    public static void updateDirections() {
        if (ChessGame.playerRed.directions == Player.Directions.DIAGONALES) {
            btnBoussolePlayerBlack = btnBoussolePlayerBlackDiag;
        } else if (ChessGame.playerRed.directions == Player.Directions.LIGNES_COLONNES) {
            btnBoussolePlayerBlack = btnBoussolePlayerBlackLines;
        }
        if (ChessGame.playerBlue.directions == Player.Directions.DIAGONALES) {
            btnBoussolePlayerWhite = btnBoussolePlayerWhiteDiag;
        } else if (ChessGame.playerBlue.directions == Player.Directions.LIGNES_COLONNES) {
            btnBoussolePlayerWhite = btnBoussolePlayerWhiteLines;
        }
    }

    @Override
    public void display() {
        decor.draw();
        BattleGraphics.drawGrid();
        Graphics.drawWithRatio(imageStartMovementWhite, Positions.gridSize, Positions.gridSize);
        Graphics.drawWithRatio(imageEndMovementWhite, Positions.gridSize, Positions.gridSize);
        Graphics.drawWithRatio(imageStartMovementBlack, Positions.gridSize, Positions.gridSize);
        Graphics.drawWithRatio(imageEndMovementBlack, Positions.gridSize, Positions.gridSize);
        GameRules.grid.draw();
        if (GameRules.selectedPion != null) {
            GameRules.selectedPion.drawDeplacement();
            Graphics.drawWithRatio(imageSelect, Positions.gridSize, Positions.gridSize);
        }
        imageTurn.draw();
        if (isEnd) {
            imageWin.draw();
            btnYes.draw();
            btnNo.draw();
        } else if (isRecupPion) {
            this.drawButtonsPions();
        } else if (this.isTurnConfirm) {
            imageDialogConfirm.draw();
            this.btnBlueTurn.draw();
            this.btnRedTurn.draw();
            textMessage.draw();
        } else if (this.isSavePlacingConfirm || this.isSavePlacingPlayerConfirm) {
            imageDialogConfirm.draw();
            btnYes.draw();
            btnNo.draw();
            textMessage.draw();
        } else if (isMessageAlert) {
            this.drawBoussoles();
            this.drawJokers();
            imageDialogConfirm.draw();
            btnOk.draw();
            textMessage.draw();
        } else if (isPlacing) {
            if ((Gdx.app.getType() == Application.ApplicationType.Desktop || Gdx.app.getType() == Application.ApplicationType.Applet) && ScreenGame.imagePlacing.texture != null && imagePlacing.isVisible()) {
                imagePlacing.draw(ScreenGame.imagePlacing.getPositionScale().x, ScreenGame.imagePlacing.getPositionScale().y, Positions.gridSize, Positions.gridSize);
            }
            this.drawButtonsPions();
            this.btnFinishPlacement.draw();
            this.btnSavePlacement.draw();
            GDXTextButton[] gDXTextButtonArray = this.btnPlacements;
            int n = this.btnPlacements.length;
            int n2 = 0;
            while (n2 < n) {
                GDXTextButton button = gDXTextButtonArray[n2];
                ((GDXButton)button).draw();
                ++n2;
            }
            this.drawBoussoles();
        } else {
            this.drawJokers();
            this.drawBoussoles();
            this.btnPass.draw();
            this.btnSeeJokers.draw();
            this.btnSeeOptions.draw();
            this.btnSeePionsPris.draw();
            this.btnSeeHelp.draw();
            this.btnDeselect.draw();
            if (this.isHelpDisplayed) {
                if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
                    imageAideReglesBlack.draw();
                } else if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
                    imageAideReglesWhite.draw();
                }
            }
            if (this.isJailDisplayed) {
                int i = 0;
                while (i < GameRules.currentPlayer.pionsPris.size) {
                    Pion pion = (Pion)GameRules.currentPlayer.pionsPris.get(i);
                    if (i > 2) {
                        pion.image.draw(10 + (i - 3) * 128, 120.0f);
                    } else {
                        pion.image.draw(10 + i * 128, 250.0f);
                    }
                    ++i;
                }
            }
        }
    }

    private void drawJokers() {
        int i = 0;
        while (i < ChessGame.playerRed.nbJokers) {
            if (this.btnJokersBlack[i] != null) {
                this.btnJokersBlack[i].draw();
            }
            ++i;
        }
        i = 0;
        while (i < ChessGame.playerBlue.nbJokers) {
            if (this.btnJokersWhite[i] != null) {
                this.btnJokersWhite[i].draw();
            }
            ++i;
        }
    }

    private void drawBoussoles() {
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussole.value) {
                imgFondBoussoleWhite.draw();
            } else {
                imgFondBoussoleWhiteDisabled.draw();
            }
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussoleOpponent.value) {
                imgFondBoussoleBlack.draw();
            } else {
                imgFondBoussoleBlackDisabled.draw();
            }
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussole.value) {
                imgFondBoussoleBlack.draw();
            } else {
                imgFondBoussoleBlackDisabled.draw();
            }
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussoleOpponent.value) {
                imgFondBoussoleWhite.draw();
            } else {
                imgFondBoussoleWhiteDisabled.draw();
            }
        }
        btnBoussolePlayerWhite.draw();
        btnBoussolePlayerBlack.draw();
    }

    private void drawButtonsPions() {
        GameRules.currentPlayer.imageFond.draw(this.btnRoiRed.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnFeuRed.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnEauRed.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnAirRed.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnOeufRed.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnSupprPion.getPositionScale());
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            this.btnRoiBlue.draw();
            this.btnFeuBlue.draw();
            this.btnEauBlue.draw();
            this.btnAirBlue.draw();
            this.btnOeufBlue.draw();
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            this.btnRoiRed.draw();
            this.btnFeuRed.draw();
            this.btnEauRed.draw();
            this.btnAirRed.draw();
            this.btnOeufRed.draw();
        }
        this.btnSupprPion.draw();
    }

    @Override
    public void process(float dt) {
        if (Gdx.input.isKeyJustPressed(131)) {
            GameRules.selectedPion = null;
        } else if (Gdx.input.isKeyJustPressed(41)) {
            ScreenGame.changeScreen(ChessGameScreen.screenIntro);
        }
    }
}

