/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.chess.utils;

import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.PropertiesUtils;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.Placeable;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;

public final class Positions {
    public static ObjectMap<String, String> properties;
    public static final String fileName = "data/cfg/positions.txt";
    public static float gridSize;
    public static float gridSizePlusGap;
    public static float gridGapScale;
    public static float gridGap;
    public static Position gridPos;
    public static float GRID_WIDTH;

    public Positions() {
        gridSize = 128.0f;
        gridGap = 8.0f;
        gridPos = new Position();
        gridPos.set(448.0f, 28.0f);
    }

    public static Position getScreenPos(String element) {
        String[] pos = ((String)properties.get((Object)element)).split(",");
        return new Position(Float.parseFloat(pos[0].trim()), Float.parseFloat(pos[1].trim()));
    }

    public static Position getPos(String element) {
        String[] pos = ((String)properties.get((Object)element)).split(",");
        return new Position(Float.parseFloat(pos[0].trim()), (float)Scene2D.SCREEN_HEIGHT_BASE - Float.parseFloat(pos[1].trim()));
    }

    public static Position getPos(String element, GDXImage image) {
        String[] pos = ((String)properties.get((Object)element)).split(",");
        return new Position(Float.parseFloat(pos[0].trim()), (float)Scene2D.SCREEN_HEIGHT_BASE - (Float.parseFloat(pos[1].trim()) + image.getHeight()));
    }

    public static Position getRelativePos(String element, float height) {
        String[] pos = ((String)properties.get((Object)element)).split(",");
        return new Position(Float.parseFloat(pos[0].trim()), height - Float.parseFloat(pos[1].trim()));
    }

    public static Position getPos(Properties prop, String element) {
        String[] pos = prop.getProperty(element).split(",");
        return new Position(Float.parseFloat(pos[0].trim()), (float)Scene2D.SCREEN_HEIGHT_BASE - Float.parseFloat(pos[1].trim()));
    }

    public static Position getRelativePos(Properties prop, String element, float height) {
        String[] pos = prop.getProperty(element).split(",");
        return new Position(Float.parseFloat(pos[0].trim()), height - Float.parseFloat(pos[1].trim()));
    }

    public static String pos(Placeable placeable) {
        return String.valueOf(placeable.getPosition().x) + "," + placeable.getPosition().y;
    }

    public static void save() {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(new File(fileName)));
            PropertiesUtils.store(properties, (Writer)bw, (String)"placements");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

