/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.dmqhbattle;

import com.badlogic.gdx.math.Vector2;
import com.takyon.chess.game.PlayerColor;
import com.takyon.dmqhbattle.GameState;
import com.takyon.dmqhbattle.GridDmqh;
import com.takyon.dmqhbattle.states.State;
import com.takyon.dmqhbattle.states.StateGameOver;
import com.takyon.dmqhbattle.states.StateMoving;
import com.takyon.dmqhbattle.states.StatePoping;
import com.takyon.dmqhbattle.states.StateWaitForPlay;
import com.takyon.dmqhbattle.states.StateWin;
import com.takyon.gamelib.Position;

public class DmqhPlayer {
    private Vector2 dragVector;
    private Position startPosition;
    private Position endPosition;
    public GameState gameState;
    public GridDmqh grid;
    public State state;
    public StateWaitForPlay stateWaitForPlay;
    public StatePoping statePoping;
    public StateMoving stateMoving;
    public StateWin stateWin;
    public StateGameOver stateGameOver;
    public boolean isTouchDown = false;
    public int old_i;
    public int old_j;
    public int score;
    public int bestScore;
    public PlayerColor color;

    public DmqhPlayer(PlayerColor color) {
        this.color = color;
        this.stateWaitForPlay = new StateWaitForPlay(State.StateEnum.WAIT_FOR_PLAY);
        this.stateWin = new StateWin(State.StateEnum.WIN);
        this.stateMoving = new StateMoving(State.StateEnum.MOVING){

            @Override
            public void onallMoved() {
                DmqhPlayer.this.setState(State.StateEnum.POPING);
            }
        };
        this.statePoping = new StatePoping(State.StateEnum.POPING){

            @Override
            public void onAllPopped() {
            }
        };
        this.stateGameOver = new StateGameOver(State.StateEnum.GAME_OVER);
        this.startPosition = new Position();
        this.endPosition = new Position();
        this.dragVector = new Vector2();
    }

    public void setState(State.StateEnum stateEnum) {
        switch (stateEnum) {
            case MOVING: {
                this.state = this.stateMoving;
                break;
            }
            case POPING: {
                this.state = this.statePoping;
                break;
            }
            case WAIT_FOR_PLAY: {
                this.state = this.stateWaitForPlay;
                break;
            }
            case GAME_OVER: {
                this.state = this.stateGameOver;
                break;
            }
        }
        this.state.init();
        this.state.grid = this.grid;
    }

    public void onTouchDown(int x, int y) {
        if (!this.isTouchDown) {
            this.startPosition.x = x;
            this.startPosition.y = y;
            this.isTouchDown = true;
        }
    }

    public void checkSwipe(int x, int y) {
        if (this.state == this.stateWaitForPlay) {
            this.endPosition.x = x;
            this.endPosition.y = y;
            this.dragVector.set(this.endPosition.x - this.startPosition.x, this.endPosition.y - this.startPosition.y);
            if (this.dragVector.len() > 15.0f) {
                if (Math.abs(this.dragVector.x) > Math.abs(this.dragVector.y)) {
                    if (this.dragVector.x > 0.0f) {
                        this.grid.moveRight();
                    } else {
                        this.grid.moveLeft();
                    }
                } else if (this.dragVector.y > 0.0f) {
                    this.grid.moveDown();
                } else {
                    this.grid.moveUp();
                }
            } else {
                this.onTouched(x, y);
            }
        }
        this.isTouchDown = false;
        this.startPosition.x = 0.0f;
        this.startPosition.y = 0.0f;
        this.endPosition.x = 0.0f;
        this.endPosition.y = 0.0f;
    }

    public void onTouched(int x, int y) {
    }

    public void onSwipe(float velocityX, float velocityY, int button) {
        if (this.state == this.stateWaitForPlay) {
            if (Math.abs(velocityX) > Math.abs(velocityY)) {
                if (velocityX > 0.0f) {
                    this.grid.moveRight();
                } else {
                    this.grid.moveLeft();
                }
            } else if (velocityY > 0.0f) {
                this.grid.moveDown();
            } else {
                this.grid.moveUp();
            }
        }
    }

    public void reset() {
    }
}

