/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.dmqhbattle;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.utils.Array;
import com.takyon.chess.game.Cell;
import com.takyon.chess.game.ChessGame;
import com.takyon.chess.game.Player;
import com.takyon.chess.game.PlayerColor;
import com.takyon.chess.game.rules.GameRules;
import com.takyon.chess.network.messages.game.ChangeBoussoleMessage;
import com.takyon.chess.network.messages.game.PassMessage;
import com.takyon.chess.network.messages.game.PlacementMessage;
import com.takyon.chess.pions.Oeuf;
import com.takyon.chess.pions.Pion;
import com.takyon.chess.pions.PionFactory;
import com.takyon.chess.screens.ChessGameScreen;
import com.takyon.chess.test.SavePlateau;
import com.takyon.chess.utils.BattleGraphics;
import com.takyon.chess.utils.Fonts;
import com.takyon.chess.utils.Positions;
import com.takyon.gamelib.GDXButton;
import com.takyon.gamelib.GDXGame;
import com.takyon.gamelib.GDXImage;
import com.takyon.gamelib.GDXText;
import com.takyon.gamelib.GDXTextButton;
import com.takyon.gamelib.GameScreen;
import com.takyon.gamelib.Graphics;

public class ScreenDmqhBattle
extends GameScreen {
    private static GDXImage imageTurnBlack;
    private static GDXImage imageTurnWhite;
    private static GDXImage imageTurn;
    private static GDXImage imageSelect;
    private static GDXImage imageStartMovementWhite;
    private static GDXImage imageEndMovementWhite;
    private static GDXImage imageStartMovementBlack;
    private static GDXImage imageEndMovementBlack;
    private GDXImage imageDialogConfirm;
    private GDXButton btnRoi;
    private GDXButton btnFeu;
    private GDXButton btnEau;
    private GDXButton btnAir;
    private GDXButton btnOeuf;
    private GDXButton btnSupprPion;
    private GDXButton btnSeePionsPris;
    private GDXButton btnDeselect;
    private GDXButton btnPass;
    private GDXButton btnArmistice;
    private GDXButton btnSeeJokers;
    private GDXButton btnSeeHelp;
    private GDXButton btnFinishPlacement;
    private GDXButton btnSavePlacement;
    private GDXButton btnYes;
    private GDXButton btnNo;
    private static GDXImage imgFondBoussoleWhiteDisabled;
    private static GDXImage imgFondBoussoleBlackDisabled;
    private static GDXImage imgFondBoussoleWhite;
    private static GDXImage imgFondBoussoleBlack;
    private static GDXButton btnBoussolePlayerWhite;
    private static GDXButton btnBoussolePlayerWhiteDiag;
    private static GDXButton btnBoussolePlayerWhiteLines;
    private static GDXButton btnBoussolePlayerBlack;
    private static GDXButton btnBoussolePlayerBlackDiag;
    private static GDXButton btnBoussolePlayerBlackLines;
    private GDXImage[] btnJokersWhite;
    private GDXImage[] btnJokersBlack;
    private GDXTextButton[] btnPlacements;
    public static boolean isPlacing;
    private static GDXImage imagePlacing;
    private boolean isPlacingConfirm;
    private boolean isActionDelete = false;
    private boolean isHelpDisplayed = false;
    private boolean isJailDisplayed = false;
    public static GDXText textInput;
    private static GDXImage decor;
    private static GDXImage imagePrisonBlack;
    private static GDXImage imagePrisonwWhite;
    private static GDXImage imageAideReglesBlack;
    private static GDXImage imageAideReglesWhite;
    public static boolean isRecupPion;
    public static boolean isEnd;

    static {
        isPlacing = true;
    }

    @Override
    public void firstInit() {
        ChessGame.initGame();
        imagePlacing = new GDXImage();
        this.imageDialogConfirm = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/dialog.png");
        this.imageDialogConfirm.setPosition(500.0f, 400.0f);
        imageTurnBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/turn_black.png");
        imageTurnBlack.setPosition(1650.0f, 600.0f);
        imageTurnWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/turn_white.png");
        imageTurnWhite.setPosition(imageTurnBlack.getPosition());
        this.btnRoi = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/ROI", true, false, false);
        this.btnRoi.setPosition(1500.0f, 256.0f);
        this.btnFeu = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/FEU", true, false, false);
        this.btnFeu.setPosition(1500.0f, 386.0f);
        this.btnEau = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/EAU", true, false, false);
        this.btnEau.setPosition(1500.0f, 514.0f);
        this.btnAir = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/AIR", true, false, false);
        this.btnAir.setPosition(1500.0f, 642.0f);
        this.btnOeuf = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/OEUF", true, false, false);
        this.btnOeuf.setPosition(1500.0f, 770.0f);
        this.btnSupprPion = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/suppr_pion", true, false, false);
        this.btnSupprPion.setPosition(1500.0f, 898.0f);
        this.btnSeePionsPris = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/voir_pions_pris", true, false, false);
        this.btnSeePionsPris.setPosition(250.0f, 900.0f);
        this.btnDeselect = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/deselect", true, false, false);
        this.btnDeselect.setPosition(350.0f, 900.0f);
        this.btnPass = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/pass", true, false, false);
        this.btnPass.setPosition(1650.0f, 450.0f);
        this.btnArmistice = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/armistice", true, false, false);
        this.btnArmistice.setPosition(1650.0f, 450.0f);
        this.btnSeeJokers = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/voir_jokers", true, false, false);
        this.btnSeeJokers.setPosition(1500.0f, 500.0f);
        this.btnSeeHelp = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/voir_aide", true, false, false);
        this.btnSeeHelp.setPosition(10.0f, 900.0f);
        this.btnFinishPlacement = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/placement_fini", true, false, false);
        this.btnFinishPlacement.setPosition(1650.0f, 500.0f);
        this.btnSavePlacement = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/save_placement", true, false, false);
        this.btnSavePlacement.setPosition(1650.0f, 400.0f);
        this.btnYes = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/yes", true, false, false);
        this.btnYes.setPosition(this.imageDialogConfirm.getPosition().x + 50.0f, this.imageDialogConfirm.getPosition().y + 350.0f);
        this.btnNo = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/no", true, false, false);
        this.btnNo.setPosition(this.imageDialogConfirm.getPosition().x + 450.0f, this.imageDialogConfirm.getPosition().y + 350.0f);
        textInput = new GDXText(Fonts.TEXT, "");
        textInput.setPosition(this.imageDialogConfirm.getPosition().x + 50.0f, this.imageDialogConfirm.getPosition().y + 150.0f);
        imgFondBoussoleBlackDisabled = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_disabled.png");
        imgFondBoussoleBlackDisabled.setPosition(1650.0f, 100.0f);
        imgFondBoussoleBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_black.png");
        imgFondBoussoleBlack.setPosition(1650.0f, 100.0f);
        btnBoussolePlayerBlackDiag = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_diagonales", true, false, false);
        btnBoussolePlayerBlackDiag.setPosition(1650.0f, 100.0f);
        btnBoussolePlayerBlackLines = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_horizontal_vertical", true, false, false);
        btnBoussolePlayerBlackLines.setPosition(1650.0f, 100.0f);
        imgFondBoussoleWhiteDisabled = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_disabled.png");
        imgFondBoussoleWhiteDisabled.setPosition(1650.0f, 724.0f);
        imgFondBoussoleWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/fond_boussole_white.png");
        imgFondBoussoleWhite.setPosition(1650.0f, 724.0f);
        btnBoussolePlayerWhiteDiag = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_diagonales", true, false, false);
        btnBoussolePlayerWhiteDiag.setPosition(1650.0f, 724.0f);
        btnBoussolePlayerWhiteLines = new GDXButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/boussole_horizontal_vertical", true, false, false);
        btnBoussolePlayerWhiteLines.setPosition(1650.0f, 724.0f);
        imageSelect = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/selection.png");
        imageStartMovementWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/start_move_white.png");
        imageEndMovementWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/end_move_white.png");
        imageStartMovementBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/start_move_black.png");
        imageEndMovementBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/end_move_black.png");
        imageStartMovementWhite.setVisible(false);
        imageEndMovementWhite.setVisible(false);
        imageStartMovementBlack.setVisible(false);
        imageEndMovementBlack.setVisible(false);
        this.btnJokersWhite = new GDXImage[12];
        this.btnJokersBlack = new GDXImage[12];
        int i = 0;
        while (i < 12) {
            this.btnJokersBlack[i] = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/joker_black.png");
            if (i < 6) {
                this.btnJokersBlack[i].setPosition(1500.0f, Positions.gridPos.y + (float)(i * 64));
            } else {
                this.btnJokersBlack[i].setPosition(1568.0f, Positions.gridPos.y + (float)((i - 6) * 64));
            }
            ++i;
        }
        i = 0;
        while (i < 12) {
            this.btnJokersWhite[i] = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/joker_white.png");
            if (i < 6) {
                this.btnJokersWhite[i].setPosition(1500.0f, Positions.gridPos.y + 1024.0f - 64.0f - (float)(i * 64));
            } else {
                this.btnJokersWhite[i].setPosition(1568.0f, Positions.gridPos.y + 1024.0f - 64.0f - (float)((i - 6) * 64));
            }
            ++i;
        }
        this.btnPlacements = new GDXTextButton[ChessGame.mapPlacements.entrySet().size()];
        int b = 0;
        for (String namePlacement : ChessGame.mapPlacements.keySet()) {
            this.btnPlacements[b] = new GDXTextButton(String.valueOf(GDXGame.KIT_DIRECTORY) + "/boutons/void", true, false, false);
            this.btnPlacements[b].label = new GDXText(Fonts.TEXT, namePlacement);
            this.btnPlacements[b].setPosition(0.0f, 250 + b * 50);
            ++b;
        }
        decor = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/images/decor.png");
        imageAideReglesBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/aide_regles_rouges.png");
        imageAideReglesWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/aide_regles_bleus.png");
        imageAideReglesBlack.setPosition(5.0f, 500.0f);
        imageAideReglesWhite.setPosition(5.0f, 500.0f);
        imagePrisonBlack = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/prison_rouges.png");
        imagePrisonwWhite = new GDXImage(String.valueOf(GDXGame.KIT_DIRECTORY) + "/interface/prison_bleus.png");
        imagePrisonBlack.setPosition(5.0f, 500.0f);
        imagePrisonwWhite.setPosition(5.0f, 500.0f);
    }

    @Override
    public void init() {
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            imageTurn = imageTurnWhite;
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            imageTurn = imageTurnBlack;
        }
        ScreenDmqhBattle.updateDirections();
        PionFactory.initImages();
        if (ChessGame.isDebug) {
            GameRules.historiqueActions = new Array();
        }
        Cell.initCells(GameRules.grid.cols, GameRules.grid.rows);
        isRecupPion = false;
        isEnd = false;
    }

    public void reset() {
        isPlacing = true;
        isRecupPion = false;
        isEnd = false;
        GameRules.reset();
    }

    @Override
    public void finish() {
    }

    @Override
    public void mouseMoved(int screenX, int screenY) {
        if (isPlacing) {
            int j;
            int i = ScreenDmqhBattle.getGridX(screenX);
            if (GameRules.isInGrid(i, j = ScreenDmqhBattle.getGridY(screenY))) {
                imagePlacing.setVisible(true);
                imagePlacing.setPosition(screenX - 64, screenY - 64);
            } else {
                imagePlacing.setVisible(false);
            }
        }
    }

    @Override
    public void keyTyped(char character) {
        textInput.addChar(character);
    }

    @Override
    public void keyUp(int keycode) {
        if (keycode == 67) {
            textInput.removeChar();
        }
    }

    @Override
    public void onTouched(int x, int y, int pointer, int button) {
        int j;
        int i;
        if (isRecupPion) {
            if (this.btnRoi.isClicked(x, y)) {
                GameRules.recupPion(Pion.Type.ROI);
                isRecupPion = false;
                return;
            }
            if (this.btnFeu.isClicked(x, y)) {
                GameRules.recupPion(Pion.Type.FEU);
                isRecupPion = false;
                return;
            }
            if (this.btnEau.isClicked(x, y)) {
                GameRules.recupPion(Pion.Type.EAU);
                isRecupPion = false;
                return;
            }
            if (this.btnAir.isClicked(x, y)) {
                GameRules.recupPion(Pion.Type.AIR);
                isRecupPion = false;
                return;
            }
            if (this.btnOeuf.isClicked(x, y)) {
                GameRules.recupPion(Pion.Type.OEUF);
                isRecupPion = false;
                return;
            }
        } else if (isEnd) {
            if (this.btnYes.isClicked(x, y)) {
                isEnd = false;
                this.init();
            } else if (this.btnNo.isClicked(x, y)) {
                isEnd = false;
                ScreenDmqhBattle.changeScreen(ChessGameScreen.screenIntro);
            }
        } else if (this.isPlacingConfirm) {
            if (this.btnYes.isClicked(x, y)) {
                ChessGame.savePlacement(ScreenDmqhBattle.textInput.text);
                this.isPlacingConfirm = false;
            } else if (this.btnNo.isClicked(x, y)) {
                this.isPlacingConfirm = false;
            }
        } else if (isPlacing) {
            if (this.btnRoi.isClicked(x, y)) {
                this.setCurrentType(Pion.Type.ROI);
                return;
            }
            if (this.btnFeu.isClicked(x, y)) {
                this.setCurrentType(Pion.Type.FEU);
                return;
            }
            if (this.btnEau.isClicked(x, y)) {
                this.setCurrentType(Pion.Type.EAU);
                return;
            }
            if (this.btnAir.isClicked(x, y)) {
                this.setCurrentType(Pion.Type.AIR);
                return;
            }
            if (this.btnOeuf.isClicked(x, y)) {
                this.setCurrentType(Pion.Type.OEUF);
                return;
            }
            if (this.btnSupprPion.isClicked(x, y)) {
                this.isActionDelete = true;
                ScreenDmqhBattle.imagePlacing.texture = this.btnSupprPion.img;
                return;
            }
            this.processBoussoles(x, y);
            GDXTextButton[] gDXTextButtonArray = this.btnPlacements;
            int n = this.btnPlacements.length;
            int n2 = 0;
            while (n2 < n) {
                GDXTextButton btn = gDXTextButtonArray[n2];
                if (btn.isClicked(x, y)) {
                    SavePlateau state = ChessGame.mapPlacements.get(btn.label.text);
                    ChessGame.loadPlacement(state);
                }
                ++n2;
            }
            if (this.btnFinishPlacement.isClicked(x, y)) {
                GameRules.historiqueActions.add((Object)new PlacementMessage(GameRules.currentPlayer.color, GameRules.currentPlayer.pions));
                GameRules.currentPlayer.hasFinishedPlacing = true;
                ScreenDmqhBattle.changeTurn();
                if (ChessGame.playerBlue.hasFinishedPlacing() && ChessGame.playerRed.hasFinishedPlacing()) {
                    isPlacing = false;
                }
                return;
            }
            if (this.btnSavePlacement.isClicked(x, y)) {
                this.isPlacingConfirm = true;
                return;
            }
        } else if (this.btnSeePionsPris.isClicked(x, y)) {
            this.isJailDisplayed = !this.isJailDisplayed;
        } else if (this.btnDeselect.isClicked(x, y)) {
            GameRules.selectedPion = null;
        } else if (this.btnPass.isClicked(x, y)) {
            if (GameRules.currentPlayer.canPass()) {
                GameRules.historiqueActions.add((Object)new PassMessage(GameRules.currentPlayer));
                GameRules.pass();
            }
        } else if (this.btnSeeHelp.isClicked(x, y)) {
            this.isHelpDisplayed = !this.isHelpDisplayed;
        } else if (this.btnSeeJokers.isClicked(x, y)) {
            GameRules.seeJokers();
        } else {
            this.processBoussoles(x, y);
        }
        if (GameRules.isInGrid(i = ScreenDmqhBattle.getGridX(x), j = ScreenDmqhBattle.getGridY(y))) {
            if (isPlacing) {
                if (this.isActionDelete) {
                    GameRules.deletePion(i, j);
                } else if (GameRules.currentType != null) {
                    GameRules.placePion(i, j);
                }
            } else {
                this.clickOnGrid(i, j);
            }
        }
    }

    private void processBoussoles(int x, int y) {
        if (btnBoussolePlayerWhite.isClicked(x, y)) {
            if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.BLACK, PlayerColor.WHITE));
                GameRules.changeBoussole(ChessGame.playerRed, ChessGame.playerBlue);
            } else if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.WHITE, PlayerColor.WHITE));
                GameRules.changeBoussole(ChessGame.playerBlue, ChessGame.playerBlue);
            }
        } else if (btnBoussolePlayerBlack.isClicked(x, y)) {
            if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.BLACK, PlayerColor.BLACK));
                GameRules.changeBoussole(ChessGame.playerRed, ChessGame.playerRed);
            } else if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
                GameRules.historiqueActions.add((Object)new ChangeBoussoleMessage(PlayerColor.WHITE, PlayerColor.BLACK));
                GameRules.changeBoussole(ChessGame.playerBlue, ChessGame.playerRed);
            }
        }
    }

    private void setCurrentType(Pion.Type type) {
        GameRules.currentType = type;
        ScreenDmqhBattle.imagePlacing.texture = PionFactory.imagesPionsBlue[type.ordinal()].texture;
        this.isActionDelete = false;
    }

    private void clickOnGrid(int i, int j) {
        Pion pion = GameRules.grid.getPion(i, j);
        if (GameRules.selectedPion == null) {
            if (pion != null && pion.player.color == GameRules.currentPlayer.color) {
                this.select(i, j);
            }
        } else if (pion == null) {
            GameRules.play(i, j);
        } else if (pion.player.color == GameRules.currentPlayer.color) {
            if (pion.type == Pion.Type.OEUF && pion.i == GameRules.selectedPion.i && pion.j == GameRules.selectedPion.j) {
                Oeuf oeuf = (Oeuf)pion;
                if (oeuf.content != null) {
                    GameRules.play(i, j);
                } else {
                    this.select(i, j);
                }
            } else {
                this.select(i, j);
            }
        } else {
            GameRules.play(i, j);
        }
    }

    private void select(int i, int j) {
        GameRules.selectedPion = GameRules.grid.getPion(i, j);
        GameRules.selectedPion.setAvailableCellsSuper();
        imageSelect.setPosition(GameRules.selectedPion.getPosition());
    }

    public static void changeTurn() {
        GameRules.changeTurnPlayer();
        if (!isPlacing && ChessGame.isIA && GameRules.currentPlayer.color == PlayerColor.BLACK) {
            GameRules.playIA();
        }
        ScreenDmqhBattle.updateTurn();
    }

    public static void updateMovementIconsWhite(int start_i, int start_j, int end_i, int end_j) {
        imageStartMovementWhite.setVisible(true);
        imageEndMovementWhite.setVisible(true);
        BattleGraphics.setGridPosition(imageStartMovementWhite, start_i, start_j);
        BattleGraphics.setGridPosition(imageEndMovementWhite, end_i, end_j);
    }

    public static void updateMovementIconsBlack(int start_i, int start_j, int end_i, int end_j) {
        imageStartMovementBlack.setVisible(true);
        imageEndMovementBlack.setVisible(true);
        BattleGraphics.setGridPosition(imageStartMovementBlack, start_i, start_j);
        BattleGraphics.setGridPosition(imageEndMovementBlack, end_i, end_j);
    }

    public static void initTurn(Player player) {
        GameRules.initTurn(player);
        imageTurn = imageTurnWhite;
    }

    public static void updateTurn() {
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            imageTurn = imageTurnWhite;
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            imageTurn = imageTurnBlack;
        }
    }

    public static int getGridX(int x) {
        if ((float)x < Positions.gridPos.x) {
            return -1;
        }
        return (int)(((float)x - Positions.gridPos.x) / Positions.gridSize);
    }

    public static int getGridY(int y) {
        if ((float)y < Positions.gridPos.y) {
            return -1;
        }
        return (int)(((float)y - Positions.gridPos.y) / Positions.gridSize);
    }

    public static void updateDirections() {
        if (ChessGame.playerRed.directions == Player.Directions.DIAGONALES) {
            btnBoussolePlayerBlack = btnBoussolePlayerBlackDiag;
        } else if (ChessGame.playerRed.directions == Player.Directions.LIGNES_COLONNES) {
            btnBoussolePlayerBlack = btnBoussolePlayerBlackLines;
        }
        if (ChessGame.playerBlue.directions == Player.Directions.DIAGONALES) {
            btnBoussolePlayerWhite = btnBoussolePlayerWhiteDiag;
        } else if (ChessGame.playerBlue.directions == Player.Directions.LIGNES_COLONNES) {
            btnBoussolePlayerWhite = btnBoussolePlayerWhiteLines;
        }
    }

    @Override
    public void display() {
        decor.draw();
        BattleGraphics.drawGrid();
        if (GameRules.selectedPion != null) {
            GameRules.selectedPion.drawDeplacement();
            Graphics.drawWithRatio(imageSelect, Positions.gridSize, Positions.gridSize);
        }
        Graphics.drawWithRatio(imageStartMovementWhite, Positions.gridSize, Positions.gridSize);
        Graphics.drawWithRatio(imageEndMovementWhite, Positions.gridSize, Positions.gridSize);
        Graphics.drawWithRatio(imageStartMovementBlack, Positions.gridSize, Positions.gridSize);
        Graphics.drawWithRatio(imageEndMovementBlack, Positions.gridSize, Positions.gridSize);
        GameRules.grid.draw();
        imageTurn.draw();
        if (isEnd) {
            this.imageDialogConfirm.draw();
            this.btnYes.draw();
            this.btnNo.draw();
        } else if (isRecupPion) {
            this.drawButtonsPions();
        } else if (this.isPlacingConfirm) {
            this.imageDialogConfirm.draw();
            this.btnYes.draw();
            this.btnNo.draw();
            textInput.draw();
        } else if (isPlacing) {
            if ((Gdx.app.getType() == Application.ApplicationType.Desktop || Gdx.app.getType() == Application.ApplicationType.Applet) && ScreenDmqhBattle.imagePlacing.texture != null && imagePlacing.isVisible()) {
                imagePlacing.draw(ScreenDmqhBattle.imagePlacing.getPositionScale().x, ScreenDmqhBattle.imagePlacing.getPositionScale().y, Positions.gridSize, Positions.gridSize);
            }
            this.drawButtonsPions();
            this.btnFinishPlacement.draw();
            this.btnSavePlacement.draw();
            GDXTextButton[] gDXTextButtonArray = this.btnPlacements;
            int n = this.btnPlacements.length;
            int n2 = 0;
            while (n2 < n) {
                GDXTextButton button = gDXTextButtonArray[n2];
                ((GDXButton)button).draw();
                ++n2;
            }
            this.drawBoussoles();
        } else {
            int i = 0;
            while (i < ChessGame.playerRed.nbJokers) {
                if (this.btnJokersBlack[i] != null) {
                    this.btnJokersBlack[i].draw();
                }
                ++i;
            }
            i = 0;
            while (i < ChessGame.playerBlue.nbJokers) {
                if (this.btnJokersWhite[i] != null) {
                    this.btnJokersWhite[i].draw();
                }
                ++i;
            }
            this.btnPass.draw();
            this.btnSeeJokers.draw();
            this.btnSeePionsPris.draw();
            this.btnSeeHelp.draw();
            this.btnDeselect.draw();
            this.drawBoussoles();
            if (this.isHelpDisplayed) {
                if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
                    imageAideReglesBlack.draw();
                } else if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
                    imageAideReglesWhite.draw();
                }
            }
            if (this.isJailDisplayed) {
                i = 0;
                while (i < GameRules.currentPlayer.pionsPris.size) {
                    Pion pion = (Pion)GameRules.currentPlayer.pionsPris.get(i);
                    if (i > 2) {
                        pion.image.draw(10 + (i - 3) * 128, 120.0f);
                    } else {
                        pion.image.draw(10 + i * 128, 250.0f);
                    }
                    ++i;
                }
            }
        }
    }

    private void drawBoussoles() {
        if (GameRules.currentPlayer.color == PlayerColor.WHITE) {
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussole.value) {
                imgFondBoussoleWhite.draw();
            } else {
                imgFondBoussoleWhiteDisabled.draw();
            }
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussoleOpponent.value) {
                imgFondBoussoleBlack.draw();
            } else {
                imgFondBoussoleBlackDisabled.draw();
            }
        } else if (GameRules.currentPlayer.color == PlayerColor.BLACK) {
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussole.value) {
                imgFondBoussoleBlack.draw();
            } else {
                imgFondBoussoleBlackDisabled.draw();
            }
            if (GameRules.currentPlayer.optionsPlayer.canChangeBoussoleOpponent.value) {
                imgFondBoussoleWhite.draw();
            } else {
                imgFondBoussoleWhiteDisabled.draw();
            }
        }
        btnBoussolePlayerWhite.draw();
        btnBoussolePlayerBlack.draw();
    }

    private void drawButtonsPions() {
        GameRules.currentPlayer.imageFond.draw(this.btnRoi.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnFeu.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnEau.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnAir.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnOeuf.getPositionScale());
        GameRules.currentPlayer.imageFond.draw(this.btnSupprPion.getPositionScale());
        this.btnRoi.draw();
        this.btnFeu.draw();
        this.btnEau.draw();
        this.btnAir.draw();
        this.btnOeuf.draw();
        this.btnSupprPion.draw();
    }

    @Override
    public void process(float dt) {
        if (Gdx.input.isKeyJustPressed(131)) {
            GameRules.selectedPion = null;
        }
    }
}

