/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.dmqhbattle.states;

import com.takyon.dmqhbattle.dalles.Dalle;
import com.takyon.dmqhbattle.dalles.GridObject;
import com.takyon.dmqhbattle.states.State;

public class StateMoving
extends State {
    private boolean hasAllMoved = true;

    public StateMoving(State.StateEnum stateEnum) {
        super(stateEnum);
    }

    @Override
    public void init() {
    }

    @Override
    public void logic(float dt) {
        this.hasAllMoved = true;
        switch (this.grid.direction) {
            case LEFT: {
                int j = 0;
                while (j < this.grid.rows) {
                    int i = 1;
                    while (i < this.grid.cols) {
                        this.logic(i, j, dt);
                        ++i;
                    }
                    ++j;
                }
                break;
            }
            case RIGHT: {
                int j = 0;
                while (j < this.grid.rows) {
                    int i = this.grid.cols - 2;
                    while (i >= 0) {
                        this.logic(i, j, dt);
                        --i;
                    }
                    ++j;
                }
                break;
            }
            case UP: {
                int i = 0;
                while (i < this.grid.cols) {
                    int j = 1;
                    while (j < this.grid.rows) {
                        this.logic(i, j, dt);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            case DOWN: {
                int i = 0;
                while (i < this.grid.cols) {
                    int j = this.grid.rows - 2;
                    while (j >= 0) {
                        this.logic(i, j, dt);
                        --j;
                    }
                    ++i;
                }
                break;
            }
        }
        if (this.hasAllMoved) {
            boolean cfr_ignored_0 = this.grid.hasFusion;
            if (this.grid.hasSteped) {
                this.grid.onStep();
            }
            this.grid.hasFusion = false;
            this.grid.hasSteped = false;
            this.grid.updateAfterMove();
            this.grid.pop();
            this.onallMoved();
            this.grid.print();
        }
    }

    private void logic(int i, int j, float dt) {
        GridObject dalle = this.grid.getDalle(i, j);
        if (dalle != null) {
            dalle.logic(dt);
            if (dalle.getState() == Dalle.State.MOVING) {
                this.hasAllMoved = false;
            }
        }
    }

    public void onallMoved() {
    }
}

