/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import java.io.Serializable;

public class Color
implements Serializable {
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public Color() {
    }

    public Color(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = 1.0f;
    }

    public Color(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public Color(int red, int green, int blue) {
        this.red = (float)red / 255.0f;
        this.green = (float)green / 255.0f;
        this.blue = (float)blue / 255.0f;
        this.alpha = 1.0f;
    }

    public Color(int red, int green, int blue, int alpha) {
        this(red, green, blue);
        this.alpha = (float)alpha / 255.0f;
    }

    public boolean equals(Object other) {
        if (other instanceof Color) {
            Color color = (Color)other;
            return this.red == color.red && this.green == color.green && this.blue == color.blue && this.alpha == color.alpha;
        }
        return false;
    }

    public float getRed() {
        return this.red;
    }

    public void setRed(int red) {
        this.red = red;
    }

    public float getGreen() {
        return this.green;
    }

    public void setGreen(int green) {
        this.green = green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public void setBlue(int blue) {
        this.blue = blue;
    }

    public void set(Color color) {
        this.red = color.red;
        this.green = color.green;
        this.blue = color.blue;
        this.alpha = color.alpha;
    }

    public void set(int red, int green, int blue) {
        this.red = (float)red / 255.0f;
        this.green = (float)green / 255.0f;
        this.blue = (float)blue / 255.0f;
        this.alpha /= 255.0f;
    }

    public void set(int red, int green, int blue, int alpha) {
        this.set(red, green, blue);
        this.alpha = (float)alpha / 255.0f;
    }

    public boolean equals(Color color) {
        return this.red == color.getRed() && this.green == color.getGreen() && this.blue == color.getBlue();
    }

    public String toString() {
        return "<" + this.getRed() + ", " + this.getGreen() + "," + this.getBlue() + ">";
    }
}

