/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Color;
import com.takyon.gamelib.Drawable;
import com.takyon.gamelib.Placeable;
import com.takyon.gamelib.Position;
import com.takyon.gamelib.Scene2D;

public abstract class DrawableObject
implements Placeable,
Drawable {
    public Position position;
    public Position positionScaled;
    public Position initialPosition;
    private transient boolean visible = true;
    public transient Color color;
    private DrawableObject drawable;

    public DrawableObject() {
        this.color = new Color();
        this.position = new Position();
        this.positionScaled = new Position();
        this.initialPosition = new Position();
    }

    public DrawableObject(DrawableObject drawable) {
    }

    public float getAlpha() {
        return this.color.alpha;
    }

    public void setAlpha(float alpha) {
        this.color.alpha = alpha;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    public Position getPositionScale() {
        this.positionScaled.x = this.getPosition().x * Scene2D.RATIO;
        this.positionScaled.y = ((float)Scene2D.SCREEN_HEIGHT_BASE - this.getPosition().y) * Scene2D.RATIO;
        return this.positionScaled;
    }

    @Override
    public Position getInitialPosition() {
        return this.initialPosition;
    }

    public void setInitialPosition(Position position) {
        this.initialPosition.set(position.x, position.y);
        this.setPosition(position.x, position.y);
    }

    public void setInitialPosition() {
        this.setPosition(this.initialPosition);
    }

    @Override
    public void setInitialPosition(float x, float y) {
        this.initialPosition.set(x, y);
        this.setPosition(x, y);
    }

    @Override
    public void setInitialPosition(float x, float y, float z) {
        this.initialPosition.set(x, y, z);
        this.setPosition(x, y, z);
    }

    public void setPosition(Position position) {
        this.setPosition(position.x, position.y, position.z);
    }

    @Override
    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.position.set(x, y, z);
    }

    public void moveX(float dx) {
        this.getPosition().x += dx;
    }

    public void moveY(float dy) {
        this.getPosition().y += dy;
    }

    public void moveZ(float dz) {
        this.getPosition().z += dz;
    }

    public void move(float dx, float dy, float dz) {
        this.getPosition().x += dx;
        this.getPosition().y += dy;
        this.getPosition().z += dz;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void display() {
        if (this.isVisible()) {
            this.draw();
        }
    }

    @Override
    public abstract void draw();
}

