/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.IResourceLoader;
import com.takyon.gamelib.Resource;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class FileResourceLoader
extends IResourceLoader {
    @Override
    public InputStream load(String resourcePath) throws FileNotFoundException {
        InputStream inputStream = null;
        if (!this.isLoaded(resourcePath)) {
            inputStream = new FileInputStream(new File(resourcePath));
        } else {
            inputStream = (InputStream)this.resources.get(resourcePath);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(resourcePath);
        }
        return inputStream;
    }

    @Override
    public ByteBuffer loadResourceInMemoey(String resourceName, String resourcePath) {
        MappedByteBuffer buffer = null;
        if (!this.isLoaded(resourceName)) {
            try {
                File file = new File(resourcePath);
                FileChannel channel = new RandomAccessFile(file, "r").getChannel();
                buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)channel.size());
                this.resources.put(resourcePath, new Resource(resourceName, resourcePath, true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buffer;
    }

    @Override
    public String[] listFiles(String path) {
        File dir = new File(path);
        return dir.list();
    }

    @Override
    public void openURL(String url) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(URI.create(url));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

