/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Resource;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Properties;

public abstract class IResourceLoader {
    public HashMap<String, Object> resources = new HashMap();

    public abstract InputStream load(String var1) throws FileNotFoundException;

    public InputStream loadResource(String resourcePath) throws FileNotFoundException {
        InputStream inputStream = this.load(resourcePath);
        if (inputStream != null) {
            this.resources.put(resourcePath, inputStream);
        }
        if (inputStream == null) {
            throw new FileNotFoundException(resourcePath);
        }
        return inputStream;
    }

    public InputStream reloadResource(String resourcePath) throws FileNotFoundException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(resourcePath));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (inputStream == null) {
            throw new FileNotFoundException(resourcePath);
        }
        return inputStream;
    }

    public InputStream loadResource(String resourceName, String resourcePath) throws FileNotFoundException {
        InputStream inputStream = this.loadResource(resourcePath);
        if (inputStream == null) {
            throw new FileNotFoundException(resourcePath);
        }
        this.resources.put(resourcePath, new Resource(resourceName, resourcePath, false));
        return inputStream;
    }

    public byte[] toByteBuffer(File file) {
        byte[] bytes = new byte[(int)file.length()];
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int c = 0;
            while (reader.ready()) {
                bytes[c] = (byte)reader.read();
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    public static Dimension getImageDimensions(String resourceName) {
        resourceName = resourceName.replace('\\', '/');
        String path = resourceName.split("data/")[1].split("[.]")[0];
        Properties imageProperties = new Properties();
        String size = (String)imageProperties.get(path);
        String[] dims = size.split("x");
        int w = Integer.parseInt(dims[0]);
        int h = Integer.parseInt(dims[1]);
        return new Dimension(w, h);
    }

    public ByteBuffer loadResourceInMemoey(String resourceName, String resourcePath) {
        MappedByteBuffer buffer = null;
        if (!this.isLoaded(resourceName)) {
            try {
                File file = new File(resourcePath);
                FileChannel channel = new RandomAccessFile(file, "r").getChannel();
                buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)channel.size());
                this.resources.put(resourcePath, new Resource(resourceName, resourcePath, true));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return buffer;
    }

    public boolean isLoaded(String resourceName) {
        return this.resources.get(resourceName) != null;
    }

    public abstract String[] listFiles(String var1);

    public abstract void openURL(String var1);
}

