/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.takyon.gamelib.Input;
import java.util.HashMap;

public class InputConfiguration {
    public HashMap<Enum, Integer> buttonsMap = new HashMap();
    public Input input;
    public int currentButton = 0;
    public boolean currentState = false;
    public int[] buttons;
    public boolean isReady = false;

    public InputConfiguration() {
    }

    public InputConfiguration(Input input) {
        this();
        this.input = input;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public boolean isButtonReleased(Enum button) {
        int realButton = this.buttonsMap.get(button);
        return this.input.isButtonReleased(realButton);
    }

    public boolean isButtonReleased(int realButton) {
        return this.input.isButtonReleased(realButton);
    }

    public boolean isButtonPressed(int realButton) {
        return this.input.isButtonPressed(realButton);
    }

    public boolean isButtonPressed(Enum button) {
        int realButton = this.buttonsMap.get(button);
        return this.input.isButtonPressed(realButton);
    }

    public boolean isButtonDown(Enum button) {
        int realButton = this.buttonsMap.get(button);
        return this.input.isButtonDown(realButton);
    }

    public boolean isButtonDown(int button) {
        return this.input.isButtonDown(button);
    }

    public void process() {
        if (!this.isReady && this.input.hasNext()) {
            this.isReady = true;
        }
        this.input.process();
        int i = 0;
        while (i < this.buttons.length) {
            int button = this.buttons[i];
            boolean isButtonDown = this.input.isButtonDown(button);
            this.input.isButtonPressed[button] = isButtonDown && !this.input.isButtonDown[button];
            if (isButtonDown) {
                this.input.isButtonDown[button] = true;
            }
            if (!isButtonDown && this.input.isButtonDown[button]) {
                this.input.isButtonReleased[button] = true;
                this.input.isButtonDown[button] = false;
            } else {
                this.input.isButtonReleased[button] = false;
            }
            ++i;
        }
    }

    public void clearStates() {
    }

    public void init() {
        Integer[] values = new Integer[this.buttonsMap.values().size()];
        this.buttonsMap.values().toArray(values);
        this.buttons = new int[values.length];
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i] = values[i];
            ++i;
        }
    }
}

