/*
 * Decompiled with CFR 0.152.
 */
package com.takyon.gamelib;

import com.badlogic.gdx.Gdx;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Language {
    public static Properties properties;
    private InputStream in;
    private OutputStream out;
    private static DateFormat formatDateFr;
    private static DateFormat formatDateEn;
    private static DateFormat formatHeureFr;
    private static DateFormat formatHeureEn;
    public static int lang;
    public static final int FR = 0;
    public static final int EN = 1;

    static {
        formatDateFr = new SimpleDateFormat("dd/MM/yy");
        formatDateEn = new SimpleDateFormat("dd/MM/yy");
        formatHeureFr = new SimpleDateFormat("hh:mm");
        formatHeureEn = new SimpleDateFormat("hh:mm");
    }

    public Language(InputStream is) {
        properties = new Properties();
        try {
            properties.load(is);
            is.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Language(String file) {
        properties = new Properties();
        try {
            this.in = Gdx.files.internal(file).read();
            properties.load(this.in);
            this.in.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String tr(String label) {
        String traducedlabel = (String)properties.get(label);
        if (traducedlabel == null) {
            traducedlabel = label;
        }
        return traducedlabel.trim();
    }

    public static void printFields() {
    }

    public static String getDate(Date date) {
        if (lang == 0) {
            return formatDateFr.format(date);
        }
        if (lang == 1) {
            return formatDateEn.format(date);
        }
        return null;
    }

    public static String getHeure(Date date) {
        if (lang == 0) {
            return formatHeureFr.format(date);
        }
        if (lang == 1) {
            return formatHeureEn.format(date);
        }
        return null;
    }
}

